/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.config;

import java.util.List;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.amqp.channel.AbstractAmqpChannel;
import org.springframework.integration.amqp.channel.PointToPointSubscribableAmqpChannel;
import org.springframework.integration.amqp.channel.PollableAmqpChannel;
import org.springframework.integration.amqp.channel.PublishSubscribeAmqpChannel;
import org.springframework.integration.channel.ChannelInterceptor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ErrorHandler;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmqpChannelFactoryBean
extends AbstractFactoryBean<AbstractAmqpChannel>
implements SmartLifecycle,
DisposableBean,
BeanNameAware {
    private volatile AbstractAmqpChannel channel;
    private volatile List<ChannelInterceptor> interceptors;
    private final boolean messageDriven;
    private final AmqpTemplate amqpTemplate = new RabbitTemplate();
    private volatile SimpleMessageListenerContainer container;
    private volatile AmqpAdmin amqpAdmin;
    private volatile FanoutExchange exchange;
    private volatile String queueName;
    private volatile boolean autoStartup = true;
    private volatile Advice[] adviceChain;
    private volatile Integer concurrentConsumers;
    private volatile ConnectionFactory connectionFactory;
    private volatile MessagePropertiesConverter messagePropertiesConverter;
    private volatile ErrorHandler errorHandler;
    private volatile Boolean exposeListenerChannel;
    private volatile Integer phase;
    private volatile Integer prefetchCount;
    private volatile Boolean isPubSub;
    private volatile Long receiveTimeout;
    private volatile Long recoveryInterval;
    private volatile Long shutdownTimeout;
    private volatile String beanName;
    private volatile AcknowledgeMode acknowledgeMode;
    private volatile boolean channelTransacted = true;
    private volatile Executor taskExecutor;
    private volatile PlatformTransactionManager transactionManager;
    private volatile TransactionAttribute transactionAttribute;
    private volatile Integer txSize;
    private volatile int maxSubscribers = Integer.MAX_VALUE;

    public AmqpChannelFactoryBean() {
        this(true);
    }

    public AmqpChannelFactoryBean(boolean messageDriven) {
        this.messageDriven = messageDriven;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setInterceptors(List<ChannelInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setAmqpAdmin(AmqpAdmin amqpAdmin) {
        this.amqpAdmin = amqpAdmin;
    }

    public void setExchange(FanoutExchange exchange) {
        this.exchange = exchange;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setEncoding(String encoding) {
        if (this.amqpTemplate instanceof RabbitTemplate) {
            ((RabbitTemplate)this.amqpTemplate).setEncoding(encoding);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"AmqpTemplate is not a RabbitTemplate, so configured 'encoding' value will be ignored.");
        }
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        if (this.amqpTemplate instanceof RabbitTemplate) {
            ((RabbitTemplate)this.amqpTemplate).setMessageConverter(messageConverter);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"AmqpTemplate is not a RabbitTemplate, so configured MessageConverter will be ignored.");
        }
    }

    public void setChannelTransacted(boolean channelTransacted) {
        this.channelTransacted = channelTransacted;
        if (this.amqpTemplate instanceof RabbitTemplate) {
            ((RabbitTemplate)this.amqpTemplate).setChannelTransacted(channelTransacted);
        }
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        if (this.amqpTemplate instanceof RabbitTemplate) {
            ((RabbitTemplate)this.amqpTemplate).setConnectionFactory(this.connectionFactory);
        }
    }

    public void setMessagePropertiesConverter(MessagePropertiesConverter messagePropertiesConverter) {
        this.messagePropertiesConverter = messagePropertiesConverter;
        if (this.amqpTemplate instanceof RabbitTemplate) {
            ((RabbitTemplate)this.amqpTemplate).setMessagePropertiesConverter(messagePropertiesConverter);
        }
    }

    public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public void setAdviceChain(Advice[] adviceChain) {
        this.adviceChain = adviceChain;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setExposeListenerChannel(boolean exposeListenerChannel) {
        this.exposeListenerChannel = exposeListenerChannel;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public void setPubSub(boolean pubSub) {
        this.isPubSub = pubSub;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setTransactionAttribute(TransactionAttribute transactionAttribute) {
        this.transactionAttribute = transactionAttribute;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTxSize(int txSize) {
        this.txSize = txSize;
    }

    public void setMaxSubscribers(int maxSubscribers) {
        this.maxSubscribers = maxSubscribers;
    }

    public Class<?> getObjectType() {
        return this.channel != null ? ((Object)((Object)this.channel)).getClass() : AbstractAmqpChannel.class;
    }

    protected AbstractAmqpChannel createInstance() throws Exception {
        if (this.messageDriven) {
            this.container = this.createContainer();
            if (this.amqpTemplate instanceof InitializingBean) {
                ((InitializingBean)this.amqpTemplate).afterPropertiesSet();
            }
            if (this.isPubSub.booleanValue()) {
                PublishSubscribeAmqpChannel pubsub = new PublishSubscribeAmqpChannel(this.beanName, this.container, this.amqpTemplate);
                if (this.exchange != null) {
                    pubsub.setExchange(this.exchange);
                }
                pubsub.setMaxSubscribers(this.maxSubscribers);
                this.channel = pubsub;
            } else {
                PointToPointSubscribableAmqpChannel p2p = new PointToPointSubscribableAmqpChannel(this.beanName, this.container, this.amqpTemplate);
                if (StringUtils.hasText((String)this.queueName)) {
                    p2p.setQueueName(this.queueName);
                }
                p2p.setMaxSubscribers(this.maxSubscribers);
                this.channel = p2p;
            }
        } else {
            Assert.isTrue((!Boolean.TRUE.equals(this.isPubSub) ? 1 : 0) != 0, (String)"An AMQP 'publish-subscribe-channel' must be message-driven.");
            PollableAmqpChannel pollable = new PollableAmqpChannel(this.beanName, this.amqpTemplate);
            if (this.amqpAdmin != null) {
                pollable.setAmqpAdmin(this.amqpAdmin);
            }
            if (StringUtils.hasText((String)this.queueName)) {
                pollable.setQueueName(this.queueName);
            }
            this.channel = pollable;
        }
        if (!CollectionUtils.isEmpty(this.interceptors)) {
            this.channel.setInterceptors(this.interceptors);
        }
        this.channel.afterPropertiesSet();
        this.channel.setBeanName(this.beanName);
        return this.channel;
    }

    private SimpleMessageListenerContainer createContainer() throws Exception {
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer();
        if (this.acknowledgeMode != null) {
            container.setAcknowledgeMode(this.acknowledgeMode);
        }
        if (!ObjectUtils.isEmpty((Object[])this.adviceChain)) {
            container.setAdviceChain(this.adviceChain);
        }
        container.setAutoStartup(this.autoStartup);
        container.setChannelTransacted(this.channelTransacted);
        if (this.concurrentConsumers != null) {
            container.setConcurrentConsumers(this.concurrentConsumers.intValue());
        }
        container.setConnectionFactory(this.connectionFactory);
        if (this.errorHandler != null) {
            container.setErrorHandler(this.errorHandler);
        }
        if (this.exposeListenerChannel != null) {
            container.setExposeListenerChannel(this.exposeListenerChannel.booleanValue());
        }
        if (this.messagePropertiesConverter != null) {
            container.setMessagePropertiesConverter(this.messagePropertiesConverter);
        }
        if (this.phase != null) {
            container.setPhase(this.phase.intValue());
        }
        if (this.prefetchCount != null) {
            container.setPrefetchCount(this.prefetchCount.intValue());
        }
        if (this.receiveTimeout != null) {
            container.setReceiveTimeout(this.receiveTimeout.longValue());
        }
        if (this.recoveryInterval != null) {
            container.setRecoveryInterval(this.recoveryInterval.longValue());
        }
        if (this.shutdownTimeout != null) {
            container.setShutdownTimeout(this.shutdownTimeout.longValue());
        }
        if (this.taskExecutor != null) {
            container.setTaskExecutor(this.taskExecutor);
        }
        if (this.transactionAttribute != null) {
            container.setTransactionAttribute(this.transactionAttribute);
        }
        if (this.transactionManager != null) {
            container.setTransactionManager(this.transactionManager);
        }
        if (this.txSize != null) {
            container.setTxSize(this.txSize.intValue());
        }
        return container;
    }

    public boolean isAutoStartup() {
        return this.channel instanceof SmartLifecycle ? ((SmartLifecycle)this.channel).isAutoStartup() : false;
    }

    public int getPhase() {
        return this.channel instanceof SmartLifecycle ? ((SmartLifecycle)this.channel).getPhase() : 0;
    }

    public boolean isRunning() {
        return this.channel instanceof Lifecycle ? ((Lifecycle)this.channel).isRunning() : false;
    }

    public void start() {
        if (this.channel instanceof Lifecycle) {
            ((Lifecycle)this.channel).start();
        }
    }

    public void stop() {
        if (this.channel instanceof Lifecycle) {
            ((Lifecycle)this.channel).stop();
        }
    }

    public void stop(Runnable callback) {
        if (this.channel instanceof SmartLifecycle) {
            ((SmartLifecycle)this.channel).stop(callback);
        }
    }

    protected void destroyInstance(AbstractAmqpChannel instance) throws Exception {
        if (instance instanceof DisposableBean) {
            ((DisposableBean)this.channel).destroy();
        }
    }
}

