/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.uber;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.JacksonHelper;
import org.springframework.hateoas.mediatype.PropertyUtils;
import org.springframework.hateoas.mediatype.uber.Uber;
import org.springframework.hateoas.mediatype.uber.UberAction;
import org.springframework.hateoas.mediatype.uber.UberData;
import org.springframework.hateoas.mediatype.uber.UberDocument;
import org.springframework.util.StringUtils;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.Version;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JsonDeserialize;
import tools.jackson.databind.deser.std.ContainerDeserializerBase;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.module.SimpleModule;
import tools.jackson.databind.ser.std.StdContainerSerializer;
import tools.jackson.databind.type.TypeFactory;

public class UberJacksonModule
extends SimpleModule {
    private static final long serialVersionUID = -2396790508486870880L;
    private static final TypeFactory TYPE_FACTORY = TypeFactory.createDefaultInstance();

    public UberJacksonModule() {
        super("uber-module", new Version(1, 0, 0, null, "org.springframework.hateoas", "spring-hateoas"));
        this.addSerializer((ValueSerializer)new UberPagedModelSerializer());
        this.addSerializer((ValueSerializer)new UberCollectionModelSerializer());
        this.addSerializer((ValueSerializer)new UberEntityModelSerializer());
        this.addSerializer((ValueSerializer)new UberRepresentationModelSerializer());
        this.setMixInAnnotation(RepresentationModel.class, RepresentationModelMixin.class);
        this.setMixInAnnotation(EntityModel.class, EntityModelMixin.class);
        this.setMixInAnnotation(CollectionModel.class, CollectionModelMixin.class);
        this.setMixInAnnotation(PagedModel.class, PagedModelMixin.class);
    }

    private static CollectionModel<?> extractResources(UberDocument doc, JavaType rootType, JavaType contentType) {
        ArrayList content = new ArrayList();
        for (UberData uberData : doc.getUber().getData()) {
            String name = uberData.getName();
            if (name != null && name.equals("page") || !uberData.getLinks().isEmpty()) continue;
            ArrayList<Link> resourceLinks = new ArrayList<Link>();
            RepresentationModel<?> resource = null;
            List<UberData> data = uberData.getData();
            if (data == null) {
                throw new RuntimeException("No content!");
            }
            for (UberData item2 : data) {
                List<LinkRelation> rel = item2.getRel();
                if (rel != null) {
                    resourceLinks.addAll(item2.getLinks());
                    continue;
                }
                List<UberData> itemData = item2.getData();
                if (UberJacksonModule.isPrimitiveType(itemData)) {
                    if (itemData == null) {
                        throw new IllegalStateException();
                    }
                    UberData firstItem = itemData.get(0);
                    Object scalarValue = firstItem.getValue();
                    resource = RepresentationModel.of(scalarValue, uberData.getLinks());
                    continue;
                }
                HashMap<String, Object> properties = itemData == null ? new HashMap<String, Object>() : itemData.stream().collect(Collectors.toMap(UberData::getName, UberData::getValue));
                Object obj = PropertyUtils.createObjectFromProperties(rootType.getRawClass(), properties);
                resource = EntityModel.of(obj, uberData.getLinks());
            }
            if (resource != null) {
                resource.add(resourceLinks);
                content.add(resource);
                continue;
            }
            throw new RuntimeException("No content!");
        }
        if (JacksonHelper.isResourcesOfResource(contentType)) {
            return CollectionModel.of(content, (Iterable<Link>)doc.getUber().getLinks());
        }
        List resourceLessContent = content.stream().map(item -> (EntityModel)item).map(EntityModel::getContent).collect(Collectors.toList());
        return CollectionModel.of(resourceLessContent, (Iterable<Link>)doc.getUber().getLinks());
    }

    private static boolean isPrimitiveType(@Nullable List<UberData> data) {
        return data != null && data.size() == 1 && data.get(0).getName() == null;
    }

    private static @Nullable PagedModel.PageMetadata extractPagingMetadata(UberDocument doc) {
        return doc.getUber().getData().stream().filter(uberData -> Optional.ofNullable(uberData.getName()).map("page"::equals).orElse(false)).findFirst().map(UberJacksonModule::convertUberDataToPageMetaData).orElse(null);
    }

    private static PagedModel.PageMetadata convertUberDataToPageMetaData(UberData uberData) {
        int size = 0;
        int number = 0;
        int totalElements = 0;
        int totalPages = 0;
        List<UberData> content = uberData.getData();
        if (content != null) {
            for (UberData data : content) {
                String name = data.getName();
                Object value = data.getValue();
                switch (name) {
                    case "size": {
                        size = (Integer)value;
                        break;
                    }
                    case "number": {
                        number = (Integer)value;
                        break;
                    }
                    case "totalElements": {
                        totalElements = (Integer)value;
                        break;
                    }
                    case "totalPages": {
                        totalPages = (Integer)value;
                        break;
                    }
                }
            }
        }
        return new PagedModel.PageMetadata(size, number, totalElements, totalPages);
    }

    static class UberPagedModelSerializer
    extends StdContainerSerializer<PagedModel<?>> {
        private @Nullable BeanProperty property;

        UberPagedModelSerializer(@Nullable BeanProperty property) {
            super(PagedModel.class);
            this.property = property;
        }

        UberPagedModelSerializer() {
            this(null);
        }

        public void serialize(PagedModel<?> value, JsonGenerator gen, SerializationContext provider) {
            UberDocument doc = new UberDocument().withUber(new Uber().withVersion("1.0").withData(UberData.extractLinksAndContent(value)));
            provider.findPrimaryPropertySerializer(UberDocument.class, this.property).serialize((Object)doc, gen, provider);
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable ValueSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(SerializationContext prov, PagedModel<?> value) {
            return value.getContent().isEmpty();
        }

        public boolean hasSingleElement(PagedModel<?> value) {
            return value.getContent().size() == 1;
        }

        protected @Nullable StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }

        public ValueSerializer<?> createContextual(SerializationContext prov, BeanProperty property) {
            return new UberPagedModelSerializer(property);
        }
    }

    static class UberCollectionModelSerializer
    extends StdContainerSerializer<CollectionModel<?>> {
        private @Nullable BeanProperty property;

        UberCollectionModelSerializer(@Nullable BeanProperty property) {
            super(CollectionModel.class);
            this.property = property;
        }

        UberCollectionModelSerializer() {
            this(null);
        }

        public void serialize(CollectionModel<?> value, JsonGenerator gen, SerializationContext provider) {
            UberDocument doc = new UberDocument().withUber(new Uber().withVersion("1.0").withData(UberData.extractLinksAndContent(value)));
            provider.findPrimaryPropertySerializer(UberDocument.class, this.property).serialize((Object)doc, gen, provider);
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable ValueSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(SerializationContext prov, CollectionModel<?> value) {
            return value.getContent().isEmpty();
        }

        public boolean hasSingleElement(CollectionModel<?> value) {
            return value.getContent().size() == 1;
        }

        protected @Nullable StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }

        public ValueSerializer<?> createContextual(SerializationContext prov, BeanProperty property) {
            return new UberCollectionModelSerializer(property);
        }
    }

    static class UberEntityModelSerializer
    extends StdContainerSerializer<EntityModel<?>> {
        private final @Nullable BeanProperty property;

        UberEntityModelSerializer(@Nullable BeanProperty property) {
            super(EntityModel.class);
            this.property = property;
        }

        UberEntityModelSerializer() {
            this(null);
        }

        public void serialize(EntityModel<?> value, JsonGenerator gen, SerializationContext context) {
            UberDocument doc = new UberDocument().withUber(new Uber().withVersion("1.0").withData(UberData.extractLinksAndContent(value)));
            context.findPrimaryPropertySerializer(UberDocument.class, this.property).serialize((Object)doc, gen, context);
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable ValueSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(SerializationContext prov, EntityModel<?> value) {
            return value.getContent() == null;
        }

        public boolean hasSingleElement(EntityModel<?> value) {
            return false;
        }

        protected @Nullable StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }

        public ValueSerializer<?> createContextual(SerializationContext prov, BeanProperty property) {
            return new UberEntityModelSerializer(property);
        }
    }

    static class UberRepresentationModelSerializer
    extends StdContainerSerializer<RepresentationModel<?>> {
        private static final long serialVersionUID = -572866287910993300L;
        private final @Nullable BeanProperty property;

        UberRepresentationModelSerializer(@Nullable BeanProperty property) {
            super(RepresentationModel.class);
            this.property = property;
        }

        UberRepresentationModelSerializer() {
            this(null);
        }

        public void serialize(RepresentationModel<?> value, JsonGenerator gen, SerializationContext provider) {
            UberDocument doc = new UberDocument().withUber(new Uber().withVersion("1.0").withData(UberData.extractLinksAndContent(value)));
            provider.findPrimaryPropertySerializer(UberDocument.class, this.property).serialize((Object)doc, gen, provider);
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable ValueSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(SerializationContext prov, RepresentationModel<?> value) {
            return false;
        }

        public boolean hasSingleElement(RepresentationModel<?> value) {
            return false;
        }

        protected @Nullable StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }

        public ValueSerializer<?> createContextual(SerializationContext prov, BeanProperty property) {
            return new UberRepresentationModelSerializer(property);
        }
    }

    @JsonDeserialize(using=UberRepresentationModelDeserializer.class)
    abstract class RepresentationModelMixin
    extends RepresentationModel<RepresentationModelMixin> {
        RepresentationModelMixin() {
        }
    }

    @JsonDeserialize(using=UberEntityModelDeserializer.class)
    abstract class EntityModelMixin<T>
    extends EntityModel<T> {
        EntityModelMixin() {
        }
    }

    @JsonDeserialize(using=UberCollectionModelDeserializer.class)
    abstract class CollectionModelMixin<T>
    extends CollectionModel<T> {
        CollectionModelMixin() {
        }
    }

    @JsonDeserialize(using=UberPagedModelDeserializer.class)
    abstract class PagedModelMixin<T>
    extends PagedModel<T> {
        PagedModelMixin() {
        }
    }

    static class UberActionDeserializer
    extends StdDeserializer<UberAction> {
        UberActionDeserializer() {
            super(UberAction.class);
        }

        public UberAction deserialize(JsonParser p, DeserializationContext ctxt) {
            return UberAction.valueOf(p.getString().toUpperCase());
        }
    }

    static class UberPagedModelDeserializer
    extends ContainerDeserializerBase<PagedModel<?>> {
        private JavaType contentType;

        UberPagedModelDeserializer(JavaType contentType) {
            super(contentType);
            this.contentType = contentType;
        }

        UberPagedModelDeserializer() {
            this(TYPE_FACTORY.constructSimpleType(UberDocument.class, new JavaType[0]));
        }

        public PagedModel<?> deserialize(JsonParser p, DeserializationContext ctxt) {
            JavaType rootType = JacksonHelper.findRootType(this.contentType);
            UberDocument doc = (UberDocument)p.readValueAs(UberDocument.class);
            CollectionModel<?> resources = UberJacksonModule.extractResources(doc, rootType, this.contentType);
            PagedModel.PageMetadata pageMetadata = UberJacksonModule.extractPagingMetadata(doc);
            return PagedModel.of(resources.getContent(), pageMetadata, resources.getLinks());
        }

        public JavaType getContentType() {
            return this.contentType;
        }

        public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            JavaType type = property == null ? ctxt.getContextualType() : property.getType().getContentType();
            return new UberPagedModelDeserializer(type);
        }

        public @Nullable ValueDeserializer<Object> getContentDeserializer() {
            return null;
        }
    }

    static class UberCollectionModelDeserializer
    extends ContainerDeserializerBase<CollectionModel<?>> {
        private final JavaType contentType;

        UberCollectionModelDeserializer(JavaType contentType) {
            super(contentType);
            this.contentType = contentType;
        }

        UberCollectionModelDeserializer() {
            this(TYPE_FACTORY.constructSimpleType(UberDocument.class, new JavaType[0]));
        }

        public CollectionModel<?> deserialize(JsonParser p, DeserializationContext ctxt) {
            JavaType rootType = JacksonHelper.findRootType(this.contentType);
            UberDocument doc = (UberDocument)p.readValueAs(UberDocument.class);
            return UberJacksonModule.extractResources(doc, rootType, this.contentType);
        }

        public JavaType getContentType() {
            return this.contentType;
        }

        public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            JavaType type = property == null ? ctxt.getContextualType() : property.getType().getContentType();
            return new UberCollectionModelDeserializer(type);
        }

        public @Nullable ValueDeserializer<Object> getContentDeserializer() {
            return null;
        }
    }

    static class UberEntityModelDeserializer
    extends ContainerDeserializerBase<RepresentationModel<?>> {
        private final JavaType contentType;

        UberEntityModelDeserializer() {
            this(TYPE_FACTORY.constructSimpleType(UberDocument.class, new JavaType[0]));
        }

        private UberEntityModelDeserializer(JavaType contentType) {
            super(contentType);
            this.contentType = contentType;
        }

        public RepresentationModel<?> deserialize(JsonParser p, DeserializationContext ctxt) {
            UberDocument doc = (UberDocument)p.readValueAs(UberDocument.class);
            Links links = doc.getUber().getLinks();
            return doc.getUber().getData().stream().filter(uberData -> StringUtils.hasText((String)uberData.getName())).findFirst().map(uberData -> this.convertToResource((UberData)uberData, links)).orElseThrow(() -> new IllegalStateException("No data entry containing a 'value' was found in this document!"));
        }

        private RepresentationModel<?> convertToResource(UberData uberData, Links links) {
            List<UberData> data = uberData.getData();
            if (data == null) {
                throw new IllegalStateException();
            }
            if (UberJacksonModule.isPrimitiveType(data)) {
                UberData firstItem = data.get(0);
                Object scalarValue = firstItem.getValue();
                return RepresentationModel.of(scalarValue, links);
            }
            HashMap<String, Object> properties = data == null ? new HashMap<String, Object>() : data.stream().collect(Collectors.toMap(UberData::getName, UberData::getValue));
            JavaType rootType = JacksonHelper.findRootType(this.contentType);
            Object value = PropertyUtils.createObjectFromProperties(rootType.getRawClass(), properties);
            return EntityModel.of(value, links);
        }

        public JavaType getContentType() {
            return this.contentType;
        }

        public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            JavaType type = property == null ? ctxt.getContextualType() : property.getType().getContentType();
            return new UberEntityModelDeserializer(type);
        }

        public @Nullable ValueDeserializer<Object> getContentDeserializer() {
            return null;
        }
    }

    static class UberRepresentationModelDeserializer
    extends ContainerDeserializerBase<RepresentationModel<?>> {
        private final JavaType contentType;

        UberRepresentationModelDeserializer() {
            this(TYPE_FACTORY.constructType(RepresentationModel.class));
        }

        private UberRepresentationModelDeserializer(JavaType contentType) {
            super(contentType);
            this.contentType = contentType;
        }

        public RepresentationModel<?> deserialize(JsonParser p, DeserializationContext ctxt) {
            UberDocument doc = (UberDocument)p.readValueAs(UberDocument.class);
            Links links = doc.getUber().getLinks();
            RepresentationModel result = doc.getUber().getData().stream().filter(uberData -> StringUtils.hasText((String)uberData.getName())).findFirst().map(uberData -> this.convertToResourceSupport((UberData)uberData, links)).orElse(null);
            return result == null ? new RepresentationModel().add(links) : result;
        }

        @NotNull
        private RepresentationModel<?> convertToResourceSupport(UberData uberData, Links links) {
            List<UberData> data = uberData.getData();
            Map<Object, Object> properties = data == null ? new HashMap() : data.stream().collect(Collectors.toMap(UberData::getName, UberData::getValue));
            RepresentationModel resourceSupport = (RepresentationModel)PropertyUtils.createObjectFromProperties(this.getContentType().getRawClass(), properties);
            return resourceSupport.add(links);
        }

        public JavaType getContentType() {
            return this.contentType;
        }

        public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            JavaType type = property == null ? ctxt.getContextualType() : property.getType().getContentType();
            return new UberRepresentationModelDeserializer(type);
        }

        public @Nullable ValueDeserializer<Object> getContentDeserializer() {
            return null;
        }
    }
}

