/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.jsonpath;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.ObjectReader;
import tools.jackson.databind.json.JsonMapper;

public class JacksonJsonProvider
extends AbstractJsonProvider {
    private static final JsonMapper DEFAULT_MAPPER = new JsonMapper();
    private static final ObjectReader DEFAULT_READER = DEFAULT_MAPPER.reader().forType(Object.class);
    protected JsonMapper mapper;
    protected ObjectReader reader;

    public JsonMapper getMapper() {
        return this.mapper;
    }

    public JacksonJsonProvider() {
        this(DEFAULT_MAPPER, DEFAULT_READER);
    }

    public JacksonJsonProvider(JsonMapper JsonMapper2) {
        this(JsonMapper2, JsonMapper2.reader().forType(Object.class));
    }

    public JacksonJsonProvider(JsonMapper JsonMapper2, ObjectReader reader) {
        this.mapper = JsonMapper2;
        this.reader = reader;
    }

    public Object parse(String json) throws InvalidJsonException {
        try {
            return this.reader.readValue(json);
        }
        catch (JacksonException e) {
            throw new InvalidJsonException((Throwable)e, json);
        }
    }

    public Object parse(byte[] json) throws InvalidJsonException {
        try {
            return this.reader.readValue(json);
        }
        catch (JacksonException e) {
            throw new InvalidJsonException((Throwable)e, new String(json, StandardCharsets.UTF_8));
        }
    }

    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        try {
            return this.reader.readValue((Reader)new InputStreamReader(jsonStream, charset));
        }
        catch (IOException | JacksonException e) {
            throw new InvalidJsonException(e);
        }
    }

    public String toJson(Object obj) {
        return this.mapper.writeValueAsString(obj);
    }

    public List<Object> createArray() {
        return new LinkedList<Object>();
    }

    public Object createMap() {
        return new LinkedHashMap();
    }
}

