/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.http.MediaType;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.std.ContainerDeserializerBase;
import tools.jackson.databind.type.TypeFactory;

class HalFormsDeserializers {
    private static final TypeFactory TYPE_FACTORY = TypeFactory.createDefaultInstance();

    HalFormsDeserializers() {
    }

    static class MediaTypesDeserializer
    extends ContainerDeserializerBase<List<MediaType>> {
        public MediaTypesDeserializer() {
            super((JavaType)TYPE_FACTORY.constructCollectionLikeType(List.class, MediaType.class));
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable ValueDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public List<MediaType> deserialize(JsonParser p, DeserializationContext ctxt) {
            return MediaType.parseMediaTypes((String)p.getString());
        }
    }

    static class HalFormsCollectionModelDeserializer
    extends ContainerDeserializerBase<List<Object>> {
        private JavaType contentType;

        HalFormsCollectionModelDeserializer(JavaType contentType) {
            super(contentType);
            this.contentType = contentType;
        }

        HalFormsCollectionModelDeserializer() {
            this((JavaType)TYPE_FACTORY.constructCollectionLikeType(List.class, Object.class));
        }

        public List<Object> deserialize(JsonParser jp, DeserializationContext ctxt) {
            ArrayList<Object> result = new ArrayList<Object>();
            ValueDeserializer deser = ctxt.findRootValueDeserializer(this.contentType);
            while (!JsonToken.END_OBJECT.equals((Object)jp.nextToken())) {
                Object object;
                if (!JsonToken.PROPERTY_NAME.equals((Object)jp.currentToken())) {
                    throw new StreamReadException(jp, "Expected relation name");
                }
                if (JsonToken.START_ARRAY.equals((Object)jp.nextToken())) {
                    while (!JsonToken.END_ARRAY.equals((Object)jp.nextToken())) {
                        object = deser.deserialize(jp, ctxt);
                        result.add(object);
                    }
                    continue;
                }
                object = deser.deserialize(jp, ctxt);
                result.add(object);
            }
            return result;
        }

        public JavaType getContentType() {
            return this.contentType;
        }

        public @Nullable ValueDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            return new HalFormsCollectionModelDeserializer(property == null ? ctxt.getContextualType() : property.getType().getContentType());
        }
    }
}

