/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.hateoas.server.core.MappingDiscoverer;
import org.springframework.hateoas.server.core.RawMappingDiscoverer;
import org.springframework.hateoas.server.core.UriMapping;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

class PropertyResolvingMappingDiscoverer
implements MappingDiscoverer {
    private final RawMappingDiscoverer delegate;

    PropertyResolvingMappingDiscoverer(RawMappingDiscoverer delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate MappingDiscoverer must not be null!");
        this.delegate = delegate;
    }

    @Override
    public @Nullable UriMapping getUriMapping(Class<?> type) {
        String mapping = this.delegate.getMapping(type, null);
        return mapping == null ? null : UriMapping.of(PropertyResolvingMappingDiscoverer.resolveProperties(mapping));
    }

    @Override
    public @Nullable UriMapping getUriMapping(Method method) {
        String mapping = this.delegate.getMapping(method.getDeclaringClass(), method);
        return mapping == null ? null : UriMapping.of(PropertyResolvingMappingDiscoverer.resolveProperties(mapping));
    }

    @Override
    public @Nullable UriMapping getUriMapping(Class<?> type, Method method) {
        String mapping = this.delegate.getMapping(type, method);
        return mapping == null ? null : UriMapping.of(PropertyResolvingMappingDiscoverer.resolveProperties(mapping));
    }

    @Override
    public Collection<HttpMethod> getRequestMethod(Class<?> type, Method method) {
        return this.delegate.getRequestMethod(type, method);
    }

    @Override
    public List<MediaType> getConsumes(Method method) {
        return this.delegate.getConsumes(method);
    }

    @Override
    public String[] getParams(Method method) {
        return this.delegate.getParams(method);
    }

    private static @Nullable String resolveProperties(@Nullable String mapping) {
        if (mapping == null) {
            return mapping;
        }
        WebApplicationContext context = ContextLoader.getCurrentWebApplicationContext();
        return context == null ? mapping : context.getEnvironment().resolvePlaceholders(mapping);
    }
}

