/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.ConfigurableHandlerInstantiator;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.MessageSourceResolvableSerializer;
import org.springframework.hateoas.mediatype.hal.CollectionModelMixin;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.mediatype.hal.HalEmbeddedBuilder;
import org.springframework.hateoas.mediatype.hal.HalLinkRelation;
import org.springframework.hateoas.mediatype.hal.LinkMixin;
import org.springframework.hateoas.mediatype.hal.RepresentationModelMixin;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;

public class Jackson2HalModule
extends SimpleModule {
    private static final long serialVersionUID = 7806951456457932384L;
    private static final Link CURIES_REQUIRED_DUE_TO_EMBEDS = Link.of("__rel__", "\u00af\\_(\u30c4)_/\u00af");

    public Jackson2HalModule() {
        super("json-hal-module", new Version(1, 0, 0, null, "org.springframework.hateoas", "spring-hateoas"));
        this.setMixInAnnotation(Link.class, LinkMixin.class);
        this.setMixInAnnotation(RepresentationModel.class, RepresentationModelMixin.class);
        this.setMixInAnnotation(CollectionModel.class, CollectionModelMixin.class);
    }

    public static boolean isAlreadyRegisteredIn(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        return LinkMixin.class.equals((Object)mapper.findMixInClassFor(Link.class));
    }

    static class HalLink {
        private final Link link;
        private final @Nullable String title;

        public HalLink(Link link, @Nullable String title) {
            this.link = link;
            this.title = title;
        }

        @JsonUnwrapped
        public Link getLink() {
            return this.link;
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonProperty
        public @Nullable String getTitle() {
            return this.title;
        }
    }

    public static class EmbeddedMapper {
        private static final Function<String, String> NO_OP = Function.identity();
        private final LinkRelationProvider relProvider;
        private final CurieProvider curieProvider;
        private final boolean preferCollectionRels;
        private Function<String, String> relationTransformer = Function.identity();

        public EmbeddedMapper(LinkRelationProvider relProvider, CurieProvider curieProvider, boolean preferCollectionRels) {
            Assert.notNull((Object)relProvider, (String)"relProvider must not be null!");
            this.relProvider = relProvider;
            this.curieProvider = curieProvider;
            this.preferCollectionRels = preferCollectionRels;
        }

        private EmbeddedMapper(LinkRelationProvider relProvider, CurieProvider curieProvider, boolean preferCollectionRels, Function<String, String> relationTransformer) {
            Assert.notNull((Object)relProvider, (String)"relProvider must not be null!");
            this.relProvider = relProvider;
            this.curieProvider = curieProvider;
            this.preferCollectionRels = preferCollectionRels;
            this.relationTransformer = relationTransformer;
        }

        public EmbeddedMapper with(@Nullable PropertyNamingStrategy strategy) {
            Function<String, String> mapper = strategy instanceof PropertyNamingStrategies.NamingBase ? arg_0 -> ((PropertyNamingStrategies.NamingBase)((PropertyNamingStrategies.NamingBase)strategy)).translate(arg_0) : null;
            return mapper == null ? this : new EmbeddedMapper(this.relProvider, this.curieProvider, this.preferCollectionRels, mapper);
        }

        public Map<HalLinkRelation, Object> map(Iterable<?> source) {
            Assert.notNull(source, (String)"Elements must not be null!");
            HalEmbeddedBuilder builder = new HalEmbeddedBuilder(this.relProvider, this.curieProvider, this.preferCollectionRels).withRelationTransformer(this.relationTransformer);
            source.forEach(builder::add);
            return builder.asMap();
        }

        public HalLinkRelation map(LinkRelation source) {
            Assert.notNull((Object)source, (String)"Link relation must not be null!");
            return HalLinkRelation.of(this.relationTransformer == NO_OP ? source : source.map(this.relationTransformer));
        }

        public boolean hasCuriedEmbed(Iterable<?> source) {
            return this.map(source).keySet().stream().anyMatch(HalLinkRelation::isCuried);
        }
    }

    public static class TrueOnlyBooleanSerializer
    extends StdScalarSerializer<Boolean> {
        private static final long serialVersionUID = 5817795880782727569L;

        public TrueOnlyBooleanSerializer() {
            super(Boolean.class);
        }

        public boolean isEmpty(SerializerProvider provider, Boolean value) {
            return value == null || Boolean.FALSE.equals(value);
        }

        public void serialize(Boolean value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeBoolean(value.booleanValue());
        }

        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("boolean", true);
        }

        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            if (visitor != null) {
                visitor.expectBooleanFormat(typeHint);
            }
        }
    }

    public static class HalHandlerInstantiator
    extends ConfigurableHandlerInstantiator {
        public HalHandlerInstantiator(LinkRelationProvider provider, CurieProvider curieProvider, MessageResolver resolver) {
            this(provider, curieProvider, resolver, new HalConfiguration(), (AutowireCapableBeanFactory)new DefaultListableBeanFactory());
        }

        public HalHandlerInstantiator(LinkRelationProvider provider, CurieProvider curieProvider, MessageResolver resolver, HalConfiguration halConfiguration, AutowireCapableBeanFactory delegate) {
            super(delegate);
            Assert.notNull((Object)provider, (String)"RelProvider must not be null!");
            Assert.notNull((Object)curieProvider, (String)"CurieProvider must not be null!");
            EmbeddedMapper mapper = new EmbeddedMapper(provider, curieProvider, halConfiguration.isEnforceEmbeddedCollections());
            this.registerInstance((Object)new HalResourcesSerializer(mapper, halConfiguration));
            this.registerInstance((Object)new HalLinkListSerializer(curieProvider, mapper, resolver, halConfiguration));
            this.registerInstance((Object)new MessageSourceResolvableSerializer(resolver));
        }
    }

    public static class HalResourcesDeserializer
    extends ContainerDeserializerBase<List<Object>>
    implements ContextualDeserializer {
        private static final long serialVersionUID = 4755806754621032622L;
        private @Nullable JavaType contentType;

        public HalResourcesDeserializer() {
            this((JavaType)TypeFactory.defaultInstance().constructCollectionLikeType(List.class, Object.class), null);
        }

        public HalResourcesDeserializer(JavaType vc) {
            this((JavaType)TypeFactory.defaultInstance().constructCollectionLikeType(List.class, vc), vc);
        }

        private HalResourcesDeserializer(JavaType type, @Nullable JavaType contentType) {
            super(type);
            this.contentType = contentType;
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable JsonDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public List<Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ArrayList<Object> result = new ArrayList<Object>();
            JsonDeserializer deser = ctxt.findRootValueDeserializer(this.contentType);
            while (!JsonToken.END_OBJECT.equals((Object)jp.nextToken())) {
                Object object;
                if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                    throw new JsonParseException(jp, "Expected relation name");
                }
                if (JsonToken.START_ARRAY.equals((Object)jp.nextToken())) {
                    while (!JsonToken.END_ARRAY.equals((Object)jp.nextToken())) {
                        object = deser.deserialize(jp, ctxt);
                        result.add(object);
                    }
                    continue;
                }
                object = deser.deserialize(jp, ctxt);
                result.add(object);
            }
            return result;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) throws JsonMappingException {
            JavaType type = property.getType().getContentType();
            return new HalResourcesDeserializer(type);
        }
    }

    public static class HalLinkListDeserializer
    extends ContainerDeserializerBase<List<Link>> {
        private static final long serialVersionUID = 6420432361123210955L;

        public HalLinkListDeserializer() {
            super((JavaType)TypeFactory.defaultInstance().constructCollectionLikeType(List.class, Link.class));
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable JsonDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public List<Link> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ArrayList<Link> result = new ArrayList<Link>();
            while (!JsonToken.END_OBJECT.equals((Object)jp.nextToken())) {
                if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                    throw new JsonParseException(jp, "Expected relation name");
                }
                String relation = jp.getText();
                if (JsonToken.START_ARRAY.equals((Object)jp.nextToken())) {
                    while (!JsonToken.END_ARRAY.equals((Object)jp.nextToken())) {
                        result.add(((Link)jp.readValueAs(Link.class)).withRel(relation));
                    }
                    continue;
                }
                result.add(((Link)jp.readValueAs(Link.class)).withRel(relation));
            }
            return result;
        }
    }

    public static class OptionalListJackson2Serializer
    extends ContainerSerializer<Object>
    implements ContextualSerializer {
        private static final long serialVersionUID = 3700806118177419817L;
        private final @Nullable BeanProperty property;
        private final Map<Class<?>, JsonSerializer<Object>> serializers;
        private final HalConfiguration halConfiguration;

        public OptionalListJackson2Serializer(@Nullable BeanProperty property, HalConfiguration halConfiguration) {
            super(TypeFactory.defaultInstance().constructType(List.class));
            this.property = property;
            this.serializers = new HashMap();
            this.halConfiguration = halConfiguration;
        }

        public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            List list = (List)value;
            if (list.isEmpty()) {
                return;
            }
            Object firstElement = list.get(0);
            if (!HalLink.class.isInstance(firstElement)) {
                this.serializeContents(list, jgen, provider);
                return;
            }
            HalLink halLink = (HalLink)firstElement;
            if (list.size() == 1 && this.halConfiguration.getSingleLinkRenderModeFor(halLink.getLink().getRel()).equals((Object)HalConfiguration.RenderSingleLinks.AS_SINGLE)) {
                this.serializeContents(halLink, jgen, provider);
                return;
            }
            this.serializeContents(list, jgen, provider);
        }

        public @Nullable JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public boolean hasSingleElement(Object arg0) {
            return false;
        }

        public boolean isEmpty(SerializerProvider provider, Object value) {
            return false;
        }

        public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
            return new OptionalListJackson2Serializer(property, this.halConfiguration);
        }

        private void serializeContents(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            this.getOrLookupSerializerFor(value, provider).serialize(value, jgen, provider);
        }

        private JsonSerializer<Object> getOrLookupSerializerFor(Object value, SerializerProvider provider) throws JsonMappingException {
            Class<?> type = value.getClass();
            JsonSerializer serializer = this.serializers.get(type);
            if (serializer == null) {
                serializer = provider.findValueSerializer(type, this.property);
                this.serializers.put(type, (JsonSerializer<Object>)serializer);
            }
            return serializer;
        }
    }

    public static class HalResourcesSerializer
    extends ContainerSerializer<Collection<?>>
    implements ContextualSerializer {
        private static final long serialVersionUID = 8030706944344625390L;
        private final EmbeddedMapper embeddedMapper;
        private final HalConfiguration configuration;
        private final @Nullable BeanProperty property;

        public HalResourcesSerializer(EmbeddedMapper embeddedMapper, HalConfiguration configuration) {
            this(embeddedMapper, configuration, null);
        }

        public HalResourcesSerializer(EmbeddedMapper embeddedMapper, HalConfiguration configuration, @Nullable BeanProperty property) {
            super(TypeFactory.defaultInstance().constructType(Collection.class));
            this.embeddedMapper = embeddedMapper;
            this.configuration = configuration;
            this.property = property;
        }

        public void serialize(Collection<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            EmbeddedMapper mapper = this.configuration.isApplyPropertyNamingStrategy() ? this.embeddedMapper.with(provider.getConfig().getPropertyNamingStrategy()) : this.embeddedMapper;
            Map<HalLinkRelation, Object> embeddeds = mapper.map(value);
            Object currentValue = jgen.getCurrentValue();
            if (currentValue instanceof RepresentationModel && mapper.hasCuriedEmbed(value)) {
                ((RepresentationModel)currentValue).add(CURIES_REQUIRED_DUE_TO_EMBEDS);
            }
            LinkedHashMap map = new LinkedHashMap(embeddeds.size());
            embeddeds.forEach((key, it) -> map.put(key.value(), it));
            provider.findValueSerializer(Map.class, this.property).serialize(map, jgen, provider);
        }

        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            return new HalResourcesSerializer(this.embeddedMapper, this.configuration, property);
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(SerializerProvider provider, Collection<?> value) {
            return value.isEmpty();
        }

        public boolean hasSingleElement(Collection<?> value) {
            return value.size() == 1;
        }

        protected @Nullable ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }

    public static class HalLinkListSerializer
    extends ContainerSerializer<Links>
    implements ContextualSerializer {
        private static final long serialVersionUID = -1844788111509966406L;
        private final @Nullable BeanProperty property;
        private final CurieProvider curieProvider;
        private final EmbeddedMapper mapper;
        private final MessageResolver resolver;
        private final HalConfiguration halConfiguration;

        public HalLinkListSerializer(CurieProvider curieProvider, EmbeddedMapper mapper, MessageResolver resolver, HalConfiguration halConfiguration) {
            this(null, curieProvider, mapper, resolver, halConfiguration);
        }

        public HalLinkListSerializer(@Nullable BeanProperty property, CurieProvider curieProvider, EmbeddedMapper mapper, MessageResolver resolver, HalConfiguration halConfiguration) {
            super(TypeFactory.defaultInstance().constructType(Links.class));
            Assert.notNull((Object)curieProvider, (String)"CurieProvider must not be null!");
            Assert.notNull((Object)mapper, (String)"EmbeddedMapper must not be null!");
            Assert.notNull((Object)resolver, (String)"MessageResolver must not be null!");
            Assert.notNull((Object)halConfiguration, (String)"HalConfiguration must not be null!");
            this.property = property;
            this.curieProvider = curieProvider;
            this.mapper = mapper;
            this.resolver = resolver;
            this.halConfiguration = halConfiguration;
        }

        public void serialize(Links value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            Collection<?> curies;
            EmbeddedMapper transformingMapper;
            LinkedMultiValueMap sortedLinks = new LinkedMultiValueMap();
            ArrayList<Link> links = new ArrayList<Link>();
            boolean prefixingRequired = this.curieProvider != CurieProvider.NONE;
            boolean curiedLinkPresent = false;
            boolean skipCuries = !jgen.getOutputContext().getParent().inRoot();
            Object currentValue = jgen.getCurrentValue();
            PropertyNamingStrategy propertyNamingStrategy = provider.getConfig().getPropertyNamingStrategy();
            EmbeddedMapper embeddedMapper = transformingMapper = this.halConfiguration.isApplyPropertyNamingStrategy() ? this.mapper.with(propertyNamingStrategy) : this.mapper;
            if (currentValue instanceof CollectionModel && transformingMapper.hasCuriedEmbed((CollectionModel)currentValue)) {
                curiedLinkPresent = true;
            }
            for (Link link : value) {
                if (link.equals(CURIES_REQUIRED_DUE_TO_EMBEDS)) continue;
                LinkRelation rel = prefixingRequired ? this.curieProvider.getNamespacedRelFrom(link) : link.getRel();
                HalLinkRelation relation = transformingMapper.map(rel);
                if (relation.isCuried()) {
                    curiedLinkPresent = true;
                }
                sortedLinks.add((Object)relation.value(), (Object)this.toHalLink(link, relation));
                links.add(link);
            }
            if (!skipCuries && prefixingRequired && curiedLinkPresent && !(curies = this.curieProvider.getCurieInformation(Links.of(links))).isEmpty()) {
                sortedLinks.addAll((Object)HalLinkRelation.CURIES.value(), new ArrayList(curies));
            }
            TypeFactory typeFactory = provider.getConfig().getTypeFactory();
            JavaType keyType = typeFactory.constructType(String.class);
            CollectionType valueType = typeFactory.constructCollectionType(ArrayList.class, Object.class);
            MapType mapType = typeFactory.constructMapType(HashMap.class, keyType, (JavaType)valueType);
            MapSerializer serializer = MapSerializer.construct(Collections.emptySet(), (JavaType)mapType, (boolean)true, null, (JsonSerializer)provider.findKeySerializer(keyType, null), (JsonSerializer)new OptionalListJackson2Serializer(this.property, this.halConfiguration), null);
            serializer.serialize((Map)sortedLinks, jgen, provider);
        }

        private HalLink toHalLink(Link link, HalLinkRelation rel) {
            return new HalLink(link, this.resolver.resolve(rel));
        }

        public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
            return new HalLinkListSerializer(property, this.curieProvider, this.mapper, this.resolver, this.halConfiguration);
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(SerializerProvider provider, Links value) {
            return value.isEmpty();
        }

        public boolean hasSingleElement(Links value) {
            return value.toList().size() == 1;
        }

        protected @Nullable ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }
}

