/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.core.EmbeddedWrappers;
import org.springframework.util.Assert;

public class HalModelBuilder {
    private final EmbeddedWrappers wrappers;
    private @Nullable Object model;
    private Links links = Links.NONE;
    private final List<Object> embeddeds = new ArrayList<Object>();

    private HalModelBuilder(EmbeddedWrappers wrappers) {
        this.wrappers = wrappers;
    }

    public static HalModelBuilder halModel() {
        return new HalModelBuilder(new EmbeddedWrappers(false));
    }

    public static HalModelBuilder halModel(EmbeddedWrappers wrappers) {
        Assert.notNull((Object)wrappers, (String)"EmbeddedWrappers must not be null!");
        return new HalModelBuilder(wrappers);
    }

    public static HalModelBuilder halModelOf(Object entity) {
        return HalModelBuilder.halModel().entity(entity);
    }

    public static HalModelBuilder emptyHalModel() {
        return HalModelBuilder.halModel();
    }

    public HalModelBuilder entity(Object entity) {
        Assert.notNull((Object)entity, (String)"Entity must not be null!");
        if (this.model != null) {
            throw new IllegalStateException("Model object already set!");
        }
        this.model = entity;
        return this;
    }

    public HalModelBuilder embed(Object entity, LinkRelation linkRelation) {
        Assert.notNull((Object)entity, (String)"Entity must not be null!");
        Assert.notNull((Object)linkRelation, (String)"Link relation must not be null!");
        this.embeddeds.add(this.wrappers.wrap(entity, linkRelation));
        return this;
    }

    public HalModelBuilder embed(Object entity) {
        Assert.notNull((Object)entity, (String)"Entity must not be null!");
        this.embeddeds.add(this.wrappers.wrap(entity));
        return this;
    }

    public HalModelBuilder embed(Collection<?> collection) {
        return this.embed(collection, Void.class);
    }

    public HalModelBuilder embed(Collection<?> collection, Class<?> type) {
        Assert.notNull(collection, (String)"Collection must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        if (!collection.isEmpty()) {
            return this.embed(this.wrappers.wrap(collection));
        }
        return Void.class.equals(type) ? this : this.embed(this.wrappers.emptyCollectionOf(type));
    }

    public HalModelBuilder embed(Collection<?> collection, LinkRelation relation) {
        Assert.notNull(collection, (String)"Collection must not be null!");
        Assert.notNull((Object)relation, (String)"Link relation must not be null!");
        return this.embed(this.wrappers.wrap(collection, relation));
    }

    public HalModelBuilder embed(Stream<?> stream) {
        return this.embed(stream, Void.class);
    }

    public HalModelBuilder embed(Stream<?> stream, Class<?> type) {
        Assert.notNull(stream, (String)"Stream must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        return this.embed((Collection)stream.collect(Collectors.toList()), type);
    }

    public HalModelBuilder embed(Stream<?> stream, LinkRelation relation) {
        Assert.notNull(stream, (String)"Stream must not be null!");
        Assert.notNull((Object)relation, (String)"Link relation must not be null!");
        return this.embed((Collection)stream.collect(Collectors.toList()), relation);
    }

    public PreviewBuilder preview(Object entity) {
        Assert.notNull((Object)entity, (String)"Preview entity must not be null!");
        return link -> this.previewFor(entity, link);
    }

    public PreviewBuilder preview(Collection<?> collection) {
        Assert.notNull(collection, (String)"Preview collection must not be null!");
        return link -> this.previewFor(collection, link);
    }

    public PreviewBuilder preview(Collection<?> collection, Class<?> type) {
        Assert.notNull(collection, (String)"Preview collection must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        return link -> this.previewFor(type, link);
    }

    public HalModelBuilder link(Link link) {
        this.links = this.links.and(link);
        return this;
    }

    public HalModelBuilder link(String href, LinkRelation relation) {
        return this.link(Link.of(href, relation));
    }

    public HalModelBuilder links(Iterable<Link> links) {
        this.links = this.links.and(links);
        return this;
    }

    public <T extends RepresentationModel<T>> RepresentationModel<T> build() {
        return this.model == null ? new EmbedsOnlyHalRepresentationModel(this.embeddeds, this.links) : new HalRepresentationModel<Object>(this.model, this.embeddeds, this.links);
    }

    private HalModelBuilder previewFor(Object entity, Link link) {
        this.link(link);
        this.embed(entity, link.getRel());
        return this;
    }

    public static interface PreviewBuilder {
        public HalModelBuilder forLink(Link var1);

        default public HalModelBuilder forLink(String href, LinkRelation relation) {
            return this.forLink(Link.of(href, relation));
        }
    }

    private static class EmbedsOnlyHalRepresentationModel
    extends CollectionModel<Object> {
        public EmbedsOnlyHalRepresentationModel(List<Object> embeddeds, Links links) {
            super(embeddeds);
            this.add(links);
        }
    }

    private static class HalRepresentationModel<T>
    extends EntityModel<T> {
        private final T entity;
        private final List<Object> embeddeds;

        public HalRepresentationModel(T entity, List<Object> embeddeds, Links links) {
            this(entity, embeddeds);
            this.add(links);
        }

        private HalRepresentationModel(T entity, List<Object> embeddeds) {
            Assert.notNull(embeddeds, (String)"Embedds must not be null!");
            this.entity = entity;
            this.embeddeds = embeddeds;
        }

        @Override
        public T getContent() {
            return this.entity;
        }

        @JsonUnwrapped
        public CollectionModel<?> getEmbeddeds() {
            return new CollectionModel<Object>(this.embeddeds){

                @Override
                public CollectionModel<Object> add(Link link) {
                    this.add(link);
                    return this;
                }
            };
        }
    }
}

