/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.collectionjson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonData;

@NullUnmarked
final class CollectionJsonQuery {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String rel;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String href;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String prompt;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<CollectionJsonData> data;

    @JsonCreator
    CollectionJsonQuery(@JsonProperty(value="rel") @Nullable String rel, @JsonProperty(value="href") @Nullable String href, @JsonProperty(value="prompt") @Nullable String prompt, @JsonProperty(value="data") @Nullable List<CollectionJsonData> data) {
        this.rel = rel;
        this.href = href;
        this.prompt = prompt;
        this.data = data;
    }

    CollectionJsonQuery() {
        this(null, null, null, null);
    }

    public CollectionJsonQuery withRel(String rel) {
        return this.rel == rel ? this : new CollectionJsonQuery(rel, this.href, this.prompt, this.data);
    }

    public CollectionJsonQuery withHref(String href) {
        return this.href == href ? this : new CollectionJsonQuery(this.rel, href, this.prompt, this.data);
    }

    public CollectionJsonQuery withPrompt(String prompt) {
        return this.prompt == prompt ? this : new CollectionJsonQuery(this.rel, this.href, prompt, this.data);
    }

    public CollectionJsonQuery withData(List<CollectionJsonData> data) {
        return this.data == data ? this : new CollectionJsonQuery(this.rel, this.href, this.prompt, data);
    }

    public String getRel() {
        return this.rel;
    }

    public String getHref() {
        return this.href;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public List<CollectionJsonData> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionJsonQuery that = (CollectionJsonQuery)o;
        return Objects.equals(this.rel, that.rel) && Objects.equals(this.href, that.href) && Objects.equals(this.prompt, that.prompt) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.rel, this.href, this.prompt, this.data);
    }

    public String toString() {
        return "CollectionJsonQuery(rel=" + this.rel + ", href=" + this.href + ", prompt=" + this.prompt + ", data=" + String.valueOf(this.data) + ")";
    }
}

