/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.util.Assert;

public class PagedModel<T>
extends CollectionModel<T> {
    public static PagedModel<?> NO_PAGE = new PagedModel();
    private final @Nullable PageMetadata metadata;
    private final @Nullable ResolvableType fallbackType;

    protected PagedModel() {
        this(new ArrayList(), null);
    }

    protected PagedModel(Collection<T> content, @Nullable PageMetadata metadata) {
        this(content, metadata, Links.NONE);
    }

    protected PagedModel(Collection<T> content, @Nullable PageMetadata metadata, Iterable<Link> links) {
        this(content, metadata, links, null);
    }

    protected PagedModel(Collection<T> content, @Nullable PageMetadata metadata, Iterable<Link> links, @Nullable ResolvableType fallbackType) {
        super(content, links, fallbackType);
        this.metadata = metadata;
        this.fallbackType = fallbackType;
    }

    public static <T> PagedModel<T> empty() {
        return PagedModel.empty(Collections.emptyList());
    }

    public static <T> PagedModel<T> empty(Class<T> fallbackElementType, Class<?> generics) {
        return PagedModel.empty(ResolvableType.forClassWithGenerics(fallbackElementType, (Class[])new Class[]{generics}));
    }

    public static <T> PagedModel<T> empty(ParameterizedTypeReference<T> fallbackElementType) {
        return PagedModel.empty(ResolvableType.forType(fallbackElementType));
    }

    public static <T> PagedModel<T> empty(ResolvableType fallbackElementType) {
        return new PagedModel(Collections.emptyList(), null, Collections.emptyList(), fallbackElementType);
    }

    public static <T> PagedModel<T> empty(Link ... links) {
        return PagedModel.empty((PageMetadata)null, links);
    }

    public static <T> PagedModel<T> empty(Iterable<Link> links) {
        return PagedModel.empty((PageMetadata)null, links);
    }

    public static <T> PagedModel<T> empty(@Nullable PageMetadata metadata) {
        return PagedModel.empty(metadata, Collections.emptyList());
    }

    public static <T> PagedModel<T> empty(@Nullable PageMetadata metadata, Class<?> fallbackType, Class<?> ... generics) {
        Assert.notNull(fallbackType, (String)"Fallback type must not be null!");
        Assert.notNull(generics, (String)"Generics must not be null!");
        return PagedModel.empty(metadata, ResolvableType.forClassWithGenerics(fallbackType, (Class[])generics));
    }

    public static <T> PagedModel<T> empty(@Nullable PageMetadata metadata, ParameterizedTypeReference<T> fallbackType) {
        Assert.notNull(fallbackType, (String)"Fallback type must not be null!");
        return PagedModel.empty(metadata, ResolvableType.forType(fallbackType));
    }

    public static <T> PagedModel<T> empty(@Nullable PageMetadata metadata, ResolvableType fallbackType) {
        Assert.notNull((Object)fallbackType, (String)"Fallback type must not be null!");
        return new PagedModel(Collections.emptyList(), metadata, Collections.emptyList(), fallbackType);
    }

    public static <T> PagedModel<T> empty(@Nullable PageMetadata metadata, Link ... links) {
        return PagedModel.empty(Arrays.asList(links));
    }

    public static <T> PagedModel<T> empty(@Nullable PageMetadata metadata, Iterable<Link> links) {
        return PagedModel.of(Collections.emptyList(), metadata, links);
    }

    public static <T> PagedModel<T> of(Collection<T> content, @Nullable PageMetadata metadata) {
        return new PagedModel<T>(content, metadata);
    }

    public static <T> PagedModel<T> of(Collection<T> content, @Nullable PageMetadata metadata, Link ... links) {
        return new PagedModel<T>(content, metadata, List.of(links));
    }

    public static <T> PagedModel<T> of(Collection<T> content, @Nullable PageMetadata metadata, Iterable<Link> links) {
        return new PagedModel<T>(content, metadata, links);
    }

    @JsonProperty(value="page")
    public @Nullable PageMetadata getMetadata() {
        return this.metadata;
    }

    public static <T extends EntityModel<S>, S> PagedModel<T> wrap(Iterable<S> content, PageMetadata metadata) {
        Assert.notNull(content, (String)"Content must not be null!");
        ArrayList<EntityModel<S>> resources = new ArrayList<EntityModel<S>>();
        for (S element : content) {
            resources.add(EntityModel.of(element));
        }
        return PagedModel.of(resources, metadata);
    }

    @JsonIgnore
    public Optional<Link> getNextLink() {
        return this.getLink(IanaLinkRelations.NEXT);
    }

    @JsonIgnore
    public Optional<Link> getPreviousLink() {
        return this.getLink(IanaLinkRelations.PREV);
    }

    @Override
    public PagedModel<T> withFallbackType(Class<? super T> type, Class<?> ... generics) {
        return this.withFallbackType(ResolvableType.forClassWithGenerics(type, (Class[])generics));
    }

    @Override
    public PagedModel<T> withFallbackType(ParameterizedTypeReference<?> type) {
        return this.withFallbackType(ResolvableType.forType(type));
    }

    @Override
    public PagedModel<T> withFallbackType(ResolvableType type) {
        return new PagedModel(this.getContent(), this.metadata, this.getLinks(), type);
    }

    @Override
    public String toString() {
        return String.format("PagedModel { content: %s, fallbackType: %s, metadata: %s, links: %s }", this.getContent(), this.fallbackType, this.metadata, this.getLinks());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        PagedModel that = (PagedModel)obj;
        return Objects.equals(this.metadata, that.metadata) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(this.metadata);
    }

    public static class PageMetadata {
        @JsonProperty
        private long size;
        @JsonProperty
        private long totalElements;
        @JsonProperty
        private long totalPages;
        @JsonProperty
        private long number;

        protected PageMetadata() {
        }

        public PageMetadata(long size, long number, long totalElements, long totalPages) {
            Assert.isTrue((size > -1L ? 1 : 0) != 0, (String)"Size must not be negative!");
            Assert.isTrue((number > -1L ? 1 : 0) != 0, (String)"Number must not be negative!");
            Assert.isTrue((totalElements > -1L ? 1 : 0) != 0, (String)"Total elements must not be negative!");
            Assert.isTrue((totalPages > -1L ? 1 : 0) != 0, (String)"Total pages must not be negative!");
            this.size = size;
            this.number = number;
            this.totalElements = totalElements;
            this.totalPages = totalPages;
        }

        public PageMetadata(long size, long number, long totalElements) {
            this(size, number, totalElements, size == 0L ? 0L : (long)Math.ceil((double)totalElements / (double)size));
        }

        public long getSize() {
            return this.size;
        }

        public long getTotalElements() {
            return this.totalElements;
        }

        public long getTotalPages() {
            return this.totalPages;
        }

        public long getNumber() {
            return this.number;
        }

        public String toString() {
            return String.format("Metadata { number: %d, total pages: %d, total elements: %d, size: %d }", this.number, this.totalPages, this.totalElements, this.size);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            PageMetadata that = (PageMetadata)obj;
            return this.number == that.number && this.size == that.size && this.totalElements == that.totalElements && this.totalPages == that.totalPages;
        }

        public int hashCode() {
            int result = 17;
            result += 31 * (int)(this.number ^ this.number >>> 32);
            result += 31 * (int)(this.size ^ this.size >>> 32);
            result += 31 * (int)(this.totalElements ^ this.totalElements >>> 32);
            return result += 31 * (int)(this.totalPages ^ this.totalPages >>> 32);
        }
    }
}

