/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;

public final class Affordance
implements Iterable<AffordanceModel> {
    private final Map<MediaType, AffordanceModel> models;

    public Affordance(Map<MediaType, AffordanceModel> models) {
        this.models = models;
    }

    @Nullable
    public <T extends AffordanceModel> T getAffordanceModel(MediaType mediaType) {
        return (T)this.models.get(mediaType);
    }

    @Override
    public Iterator<AffordanceModel> iterator() {
        return this.models.values().iterator();
    }

    Map<MediaType, AffordanceModel> getModels() {
        return this.models;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Affordance that = (Affordance)o;
        return Objects.equals(this.models, that.models);
    }

    public int hashCode() {
        return Objects.hash(this.models);
    }

    public String toString() {
        return "Affordance(models=" + this.models + ")";
    }
}

