/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.hateoas.server.core.LastInvocationAware;
import org.springframework.hateoas.server.core.MethodInvocation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class DummyInvocationUtils {
    private static final ThreadLocal<Map<CacheKey<?>, Object>> CACHE = ThreadLocal.withInitial(HashMap::new);

    public static <T> T methodOn(Class<T> type, Object ... parameters) {
        Assert.notNull(type, (String)"Given type must not be null!");
        return (T)CACHE.get().computeIfAbsent(CacheKey.of(type, parameters), it -> {
            InvocationRecordingMethodInterceptor interceptor = new InvocationRecordingMethodInterceptor(((CacheKey)it).type, ((CacheKey)it).arguments);
            return DummyInvocationUtils.getProxyWithInterceptor(((CacheKey)it).type, interceptor, type.getClassLoader());
        });
    }

    @Nullable
    public static LastInvocationAware getLastInvocationAware(Object source) {
        return (LastInvocationAware)((Advised)source).getAdvisors()[0].getAdvice();
    }

    private static <T> T getProxyWithInterceptor(Class<?> type, InvocationRecordingMethodInterceptor interceptor, ClassLoader classLoader) {
        ProxyFactory factory = new ProxyFactory();
        factory.addAdvice((Advice)interceptor);
        factory.addInterface(LastInvocationAware.class);
        if (type.isInterface()) {
            factory.addInterface(type);
        } else {
            factory.setTargetClass(type);
            factory.setProxyTargetClass(true);
        }
        return (T)factory.getProxy(classLoader);
    }

    private static final class SimpleMethodInvocation
    implements MethodInvocation {
        @NonNull
        private final Class<?> targetType;
        @NonNull
        private final Method method;
        @NonNull
        private final Object[] arguments;

        @Generated
        public SimpleMethodInvocation(@NonNull Class<?> targetType, @NonNull Method method, @NonNull Object[] arguments) {
            if (targetType == null) {
                throw new IllegalArgumentException("targetType is marked non-null but is null");
            }
            if (method == null) {
                throw new IllegalArgumentException("method is marked non-null but is null");
            }
            if (arguments == null) {
                throw new IllegalArgumentException("arguments is marked non-null but is null");
            }
            this.targetType = targetType;
            this.method = method;
            this.arguments = arguments;
        }

        @Override
        @NonNull
        @Generated
        public Class<?> getTargetType() {
            return this.targetType;
        }

        @Override
        @NonNull
        @Generated
        public Method getMethod() {
            return this.method;
        }

        @Override
        @NonNull
        @Generated
        public Object[] getArguments() {
            return this.arguments;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleMethodInvocation)) {
                return false;
            }
            SimpleMethodInvocation other = (SimpleMethodInvocation)o;
            Class<?> this$targetType = this.getTargetType();
            Class<?> other$targetType = other.getTargetType();
            if (this$targetType == null ? other$targetType != null : !this$targetType.equals(other$targetType)) {
                return false;
            }
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
                return false;
            }
            return Arrays.deepEquals(this.getArguments(), other.getArguments());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $targetType = this.getTargetType();
            result = result * 59 + ($targetType == null ? 43 : $targetType.hashCode());
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getArguments());
            return result;
        }

        @org.springframework.lang.NonNull
        @Generated
        public String toString() {
            return "DummyInvocationUtils.SimpleMethodInvocation(targetType=" + this.getTargetType() + ", method=" + this.getMethod() + ", arguments=" + Arrays.deepToString(this.getArguments()) + ")";
        }
    }

    private static final class CacheKey<T> {
        private final Class<T> type;
        private final Object[] arguments;

        @Generated
        private CacheKey(Class<T> type, Object[] arguments) {
            this.type = type;
            this.arguments = arguments;
        }

        @org.springframework.lang.NonNull
        @Generated
        public static <T> CacheKey<T> of(Class<T> type, Object[] arguments) {
            return new CacheKey<T>(type, arguments);
        }

        @Generated
        public Class<T> getType() {
            return this.type;
        }

        @Generated
        public Object[] getArguments() {
            return this.arguments;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            Class<T> this$type = this.getType();
            Class<T> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            return Arrays.deepEquals(this.getArguments(), other.getArguments());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<T> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getArguments());
            return result;
        }

        @org.springframework.lang.NonNull
        @Generated
        public String toString() {
            return "DummyInvocationUtils.CacheKey(type=" + this.getType() + ", arguments=" + Arrays.deepToString(this.getArguments()) + ")";
        }
    }

    private static class InvocationRecordingMethodInterceptor
    implements MethodInterceptor,
    LastInvocationAware {
        private final Class<?> targetType;
        private final Object[] objectParameters;
        private MethodInvocation invocation;

        InvocationRecordingMethodInterceptor(Class<?> targetType, Object ... parameters) {
            Assert.notNull(targetType, (String)"Target type must not be null!");
            Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
            this.targetType = targetType;
            this.objectParameters = (Object[])parameters.clone();
        }

        @Nullable
        public Object invoke(org.aopalliance.intercept.MethodInvocation invocation) {
            Method method = invocation.getMethod();
            if (ReflectionUtils.isObjectMethod((Method)method)) {
                return ReflectionUtils.invokeMethod((Method)method, (Object)invocation.getThis(), (Object[])invocation.getArguments());
            }
            this.invocation = new SimpleMethodInvocation(this.targetType, method, invocation.getArguments());
            Class<?> returnType = method.getReturnType();
            ClassLoader classLoader = method.getDeclaringClass().getClassLoader();
            return returnType.cast(DummyInvocationUtils.getProxyWithInterceptor(returnType, this, classLoader));
        }

        @Override
        public MethodInvocation getLastInvocation() {
            return this.invocation;
        }

        @Override
        public Iterator<Object> getObjectParameters() {
            return Arrays.asList(this.objectParameters).iterator();
        }
    }
}

