/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.HalLinkRelation;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.hateoas.server.core.EmbeddedWrapper;
import org.springframework.hateoas.server.core.EmbeddedWrappers;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class HalEmbeddedBuilder {
    private static final String INVALID_EMBEDDED_WRAPPER = "Embedded wrapper %s returned null for both the static rel and the rel target type! Make sure one of the two returns a non-null value!";
    private static final Function<String, String> NO_TRANSFORMER = Function.identity();
    private final Map<HalLinkRelation, Object> embeddeds = new HashMap<HalLinkRelation, Object>();
    private final LinkRelationProvider provider;
    private final CurieProvider curieProvider;
    private final EmbeddedWrappers wrappers;
    private final Function<String, String> relationTransformer;

    public HalEmbeddedBuilder(LinkRelationProvider provider, CurieProvider curieProvider, boolean preferCollectionRels) {
        Assert.notNull((Object)provider, (String)"LinkRelationProvider must not be null!");
        this.provider = provider;
        this.curieProvider = curieProvider;
        this.wrappers = new EmbeddedWrappers(preferCollectionRels);
        this.relationTransformer = NO_TRANSFORMER;
    }

    public void add(@Nullable Object source) {
        HalLinkRelation collectionRel;
        EmbeddedWrapper wrapper = this.wrappers.wrap(source);
        if (wrapper == null) {
            return;
        }
        HalLinkRelation collectionOrItemRel = collectionRel = this.getDefaultedRelFor(wrapper, true);
        if (!this.embeddeds.containsKey(collectionRel)) {
            collectionOrItemRel = this.getDefaultedRelFor(wrapper, wrapper.isCollectionValue());
        }
        Object currentValue = this.embeddeds.get(collectionOrItemRel);
        Object value = wrapper.getValue();
        if (currentValue == null && !wrapper.isCollectionValue()) {
            this.embeddeds.put(collectionOrItemRel, value);
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.asCollection(currentValue));
        list.addAll(this.asCollection(wrapper.getValue()));
        this.embeddeds.remove(collectionOrItemRel);
        this.embeddeds.put(collectionRel, list);
    }

    private Collection<Object> asCollection(@Nullable Object source) {
        return source instanceof Collection ? (Set<Object>)source : (source == null ? Collections.emptySet() : Collections.singleton(source));
    }

    private HalLinkRelation getDefaultedRelFor(EmbeddedWrapper wrapper, boolean forCollection) {
        return wrapper.getRel().map(HalLinkRelation::of).orElseGet(() -> {
            Class<?> type = wrapper.getRelTargetType();
            if (type == null) {
                throw new IllegalStateException(String.format(INVALID_EMBEDDED_WRAPPER, wrapper));
            }
            LinkRelation rel = forCollection ? this.provider.getCollectionResourceRelFor(type) : this.provider.getItemResourceRelFor(type);
            rel = this.relationTransformer == NO_TRANSFORMER ? rel : rel.map(this.relationTransformer);
            return this.curieProvider != CurieProvider.NONE ? this.curieProvider.getNamespacedRelFor(rel) : HalLinkRelation.of(rel);
        });
    }

    public Map<HalLinkRelation, Object> asMap() {
        return Collections.unmodifiableMap(this.embeddeds);
    }

    @Generated
    private HalEmbeddedBuilder(LinkRelationProvider provider, CurieProvider curieProvider, EmbeddedWrappers wrappers, Function<String, String> relationTransformer) {
        this.provider = provider;
        this.curieProvider = curieProvider;
        this.wrappers = wrappers;
        this.relationTransformer = relationTransformer;
    }

    @NonNull
    @Generated
    public HalEmbeddedBuilder withRelationTransformer(Function<String, String> relationTransformer) {
        return this.relationTransformer == relationTransformer ? this : new HalEmbeddedBuilder(this.provider, this.curieProvider, this.wrappers, relationTransformer);
    }
}

