/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.collectionjson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mediatype.PropertyUtils;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonData;
import org.springframework.lang.Nullable;

final class CollectionJsonItem<T> {
    @Nullable
    private final String href;
    private final List<CollectionJsonData> data;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Links links;
    @Nullable
    private final T rawData;
    private static final Set<Class<?>> PRIMITIVE_TYPES = Collections.singleton(String.class);

    @JsonCreator
    CollectionJsonItem(@JsonProperty(value="href") @Nullable String href, @JsonProperty(value="data") @Nullable List<CollectionJsonData> data, @JsonProperty(value="links") @Nullable Links links) {
        this.href = href;
        this.data = data == null ? Collections.emptyList() : data;
        this.links = links == null ? Links.NONE : links;
        this.rawData = null;
    }

    CollectionJsonItem() {
        this(null, null, null);
    }

    public List<CollectionJsonData> getData() {
        if (!this.data.isEmpty()) {
            return this.data;
        }
        if (this.rawData != null && PRIMITIVE_TYPES.contains(this.rawData.getClass())) {
            return Collections.singletonList(new CollectionJsonData().withValue(this.rawData));
        }
        return PropertyUtils.extractPropertyValues(this.rawData).entrySet().stream().map(entry -> new CollectionJsonData().withName((String)entry.getKey()).withValue(entry.getValue())).collect(Collectors.toList());
    }

    @Nullable
    public Object toRawData(JavaType javaType) {
        if (this.data.isEmpty()) {
            return null;
        }
        if (PRIMITIVE_TYPES.contains(javaType.getRawClass())) {
            return this.data.get(0).getValue();
        }
        return PropertyUtils.createObjectFromProperties(javaType.getRawClass(), this.data.stream().collect(Collectors.toMap(CollectionJsonData::getName, CollectionJsonData::getValue)));
    }

    public CollectionJsonItem<T> withLinks(Link ... links) {
        return new CollectionJsonItem<T>(this.href, this.data, Links.of(links), this.rawData);
    }

    public CollectionJsonItem<T> withLinks(Links links) {
        return new CollectionJsonItem<T>(this.href, this.data, links, this.rawData);
    }

    public CollectionJsonItem<T> withOwnSelfLink() {
        String href = this.href;
        if (href == null) {
            return this;
        }
        return this.withLinks(Links.of(new Link(href)).merge(Links.MergeMode.SKIP_BY_REL, this.links));
    }

    @Nullable
    @Generated
    public String getHref() {
        return this.href;
    }

    @Generated
    public Links getLinks() {
        return this.links;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionJsonItem)) {
            return false;
        }
        CollectionJsonItem other = (CollectionJsonItem)o;
        String this$href = this.getHref();
        String other$href = other.getHref();
        if (this$href == null ? other$href != null : !this$href.equals(other$href)) {
            return false;
        }
        List<CollectionJsonData> this$data = this.getData();
        List<CollectionJsonData> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        T this$rawData = this.getRawData();
        T other$rawData = other.getRawData();
        return !(this$rawData == null ? other$rawData != null : !this$rawData.equals(other$rawData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $href = this.getHref();
        result = result * 59 + ($href == null ? 43 : $href.hashCode());
        List<CollectionJsonData> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        T $rawData = this.getRawData();
        result = result * 59 + ($rawData == null ? 43 : $rawData.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CollectionJsonItem(href=" + this.getHref() + ", data=" + this.getData() + ", links=" + this.getLinks() + ", rawData=" + this.getRawData() + ")";
    }

    @Generated
    CollectionJsonItem<T> withHref(@Nullable String href) {
        return this.href == href ? this : new CollectionJsonItem<T>(href, this.data, this.links, this.rawData);
    }

    @Generated
    CollectionJsonItem<T> withData(List<CollectionJsonData> data) {
        return this.data == data ? this : new CollectionJsonItem<T>(this.href, data, this.links, this.rawData);
    }

    @Generated
    CollectionJsonItem<T> withRawData(@Nullable T rawData) {
        return this.rawData == rawData ? this : new CollectionJsonItem<T>(this.href, this.data, this.links, rawData);
    }

    @Generated
    CollectionJsonItem(@Nullable String href, List<CollectionJsonData> data, Links links, @Nullable T rawData) {
        this.href = href;
        this.data = data;
        this.links = links;
        this.rawData = rawData;
    }

    @JsonIgnore
    @Nullable
    @Generated
    private T getRawData() {
        return this.rawData;
    }
}

