/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.annotate.JsonValue;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.Assert;

@XmlRootElement(name="errors")
public class VndErrors
implements Iterable<VndError> {
    @XmlElement(name="error")
    private final List<VndError> vndErrors;

    public VndErrors(String logref, String message, Link ... links) {
        this(new VndError(logref, message, links), new VndError[0]);
    }

    public VndErrors(VndError error, VndError ... errors) {
        Assert.notNull((Object)error, (String)"Error must not be null");
        this.vndErrors = new ArrayList<VndError>(errors.length + 1);
        this.vndErrors.add(error);
        this.vndErrors.addAll(Arrays.asList(errors));
    }

    protected VndErrors() {
        this.vndErrors = new ArrayList<VndError>();
    }

    public VndErrors add(VndError error) {
        this.vndErrors.add(error);
        return this;
    }

    @com.fasterxml.jackson.annotation.JsonValue
    @JsonValue
    private List<VndError> getErrors() {
        return this.vndErrors;
    }

    @Override
    public Iterator<VndError> iterator() {
        return this.vndErrors.iterator();
    }

    @XmlType
    public static class VndError
    extends ResourceSupport {
        @JsonProperty
        @org.codehaus.jackson.annotate.JsonProperty
        @XmlAttribute
        private final String logref;
        @JsonProperty
        @org.codehaus.jackson.annotate.JsonProperty
        @XmlElement
        private final String message;

        public VndError(String logref, String message, Link ... links) {
            Assert.hasText((String)logref, (String)"Logref must not be null or empty!");
            Assert.hasText((String)message, (String)"Message must not be null or empty!");
            this.logref = logref;
            this.message = message;
            this.add(Arrays.asList(links));
        }

        protected VndError() {
            this.logref = null;
            this.message = null;
        }

        public String getLogref() {
            return this.logref;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

