/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.guice.module;

import com.google.inject.spi.ProvisionListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Provider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.OrderComparator;

public class BeanFactoryProvider
implements Provider<ConfigurableListableBeanFactory>,
Closeable {
    private Class<?>[] config;
    private String[] basePackages;
    private List<ApplicationContextInitializer<ConfigurableApplicationContext>> initializers = new ArrayList<ApplicationContextInitializer<ConfigurableApplicationContext>>();
    private PartiallyRefreshableApplicationContext context;

    public static BeanFactoryProvider from(String ... basePackages) {
        return new BeanFactoryProvider(null, basePackages);
    }

    public static BeanFactoryProvider from(Class<?> ... config) {
        return new BeanFactoryProvider(config, null);
    }

    public BeanFactoryProvider initializer(ApplicationContextInitializer<ConfigurableApplicationContext> ... initializers) {
        this.initializers.addAll(Arrays.asList(initializers));
        return this;
    }

    private BeanFactoryProvider(Class<?>[] config, String[] basePackages) {
        this.config = config;
        this.basePackages = basePackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.context != null) {
            BeanFactoryProvider beanFactoryProvider = this;
            synchronized (beanFactoryProvider) {
                if (this.context != null) {
                    this.context.close();
                    this.context = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurableListableBeanFactory get() {
        if (this.context == null) {
            BeanFactoryProvider beanFactoryProvider = this;
            synchronized (beanFactoryProvider) {
                if (this.context == null) {
                    PartiallyRefreshableApplicationContext context = new PartiallyRefreshableApplicationContext();
                    if (this.config != null && this.config.length > 0) {
                        context.register(this.config);
                    }
                    if (this.basePackages != null && this.basePackages.length > 0) {
                        context.scan(this.basePackages);
                    }
                    context.partialRefresh();
                    if (this.initializers != null && !this.initializers.isEmpty()) {
                        OrderComparator.sort(this.initializers);
                        for (ApplicationContextInitializer<ConfigurableApplicationContext> initializer : this.initializers) {
                            initializer.initialize((ConfigurableApplicationContext)context);
                        }
                    }
                    this.context = context;
                }
            }
        }
        return this.context.getBeanFactory();
    }

    private static final class ContextRefreshingProvisionListener
    implements ProvisionListener {
        private final PartiallyRefreshableApplicationContext context;
        private final AtomicBoolean initialized = new AtomicBoolean(false);

        private ContextRefreshingProvisionListener(PartiallyRefreshableApplicationContext context) {
            this.context = context;
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            if (!this.initialized.getAndSet(true) && !this.context.isActive()) {
                this.context.delayedRefresh();
            }
            provision.provision();
        }
    }

    private static final class PartiallyRefreshableApplicationContext
    extends AnnotationConfigApplicationContext {
        private final AtomicBoolean partiallyRefreshed = new AtomicBoolean(false);

        private PartiallyRefreshableApplicationContext() {
        }

        private void partialRefresh() {
            this.getBeanFactory().registerSingleton("refreshListener", (Object)new ContextRefreshingProvisionListener(this));
            this.invokeBeanFactoryPostProcessors(this.getBeanFactory());
        }

        private void delayedRefresh() throws BeansException, IllegalStateException {
            super.refresh();
        }

        public void refresh() {
        }

        protected void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory) {
            if (this.partiallyRefreshed.compareAndSet(false, true)) {
                super.invokeBeanFactoryPostProcessors(beanFactory);
            }
        }
    }
}

