/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.guice.annotation;

import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.name.Named;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementSource;
import com.google.inject.spi.Elements;
import com.google.inject.spi.PrivateElements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.guice.annotation.CreateInjectorSignalEvent;
import org.springframework.guice.annotation.GuiceFactoryBean;
import org.springframework.guice.annotation.InjectorFactory;
import org.springframework.guice.module.SpringModule;

@Configuration
@Order(value=-2147483648)
class ModuleRegistryConfiguration
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware,
ApplicationListener<CreateInjectorSignalEvent> {
    private static final String SPRING_GUICE_DEDUPE_BINDINGS_PROPERTY_NAME = "spring.guice.dedup";
    private ApplicationContext applicationContext;
    private List<Module> modules;
    private ConfigurableListableBeanFactory beanFactory;

    ModuleRegistryConfiguration() {
    }

    private void createInjector(List<Module> modules, ConfigurableListableBeanFactory beanFactory) {
        Injector injector = null;
        try {
            Map beansOfType = beanFactory.getBeansOfType(InjectorFactory.class);
            if (beansOfType.size() > 1) {
                throw new ApplicationContextException("Found multiple beans of type " + InjectorFactory.class.getName() + "  Please ensure that only one InjectorFactory bean is defined. InjectorFactory beans found: " + beansOfType.keySet());
            }
            if (beansOfType.size() == 1) {
                InjectorFactory injectorFactory = (InjectorFactory)beansOfType.values().iterator().next();
                injector = injectorFactory.createInjector(modules);
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (injector == null) {
            injector = Guice.createInjector(modules);
        }
        beanFactory.registerResolvableDependency(Injector.class, (Object)injector);
        beanFactory.registerSingleton("injector", (Object)injector);
    }

    private void mapBindings(Map<Key<?>, Binding<?>> bindings, BeanDefinitionRegistry registry) {
        for (Map.Entry<Key<?>, Binding<?>> entry : bindings.entrySet()) {
            if (entry.getKey().getTypeLiteral().getRawType().equals(Injector.class) || "spring-guice".equals(entry.getValue().getSource().toString())) continue;
            Binding<?> binding = entry.getValue();
            Key<?> key = entry.getKey();
            Object source = binding.getSource();
            RootBeanDefinition bean = new RootBeanDefinition(GuiceFactoryBean.class);
            ConstructorArgumentValues args = new ConstructorArgumentValues();
            args.addIndexedArgumentValue(0, (Object)key.getTypeLiteral().getRawType());
            args.addIndexedArgumentValue(1, key);
            bean.setConstructorArgumentValues(args);
            if (source != null && source instanceof ElementSource) {
                bean.setResourceDescription(((ElementSource)source).getDeclaringSource().toString());
            } else {
                bean.setResourceDescription("spring-guice");
            }
            bean.setAttribute("spring-guice", (Object)true);
            registry.registerBeanDefinition(this.extractName(key), (BeanDefinition)bean);
        }
    }

    private String extractName(Key<?> key) {
        if (key.getAnnotation() instanceof Named) {
            return ((Named)key.getAnnotation()).value();
        }
        return key.getTypeLiteral().getRawType().getSimpleName();
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.modules = new ArrayList(((ConfigurableListableBeanFactory)registry).getBeansOfType(Module.class).values());
        this.modules.add((Module)new SpringModule(this.applicationContext));
        HashMap bindings = new HashMap();
        List<Element> elements = Elements.getElements((Stage)Stage.TOOL, this.modules);
        if (((Boolean)this.applicationContext.getEnvironment().getProperty(SPRING_GUICE_DEDUPE_BINDINGS_PROPERTY_NAME, Boolean.class, (Object)false)).booleanValue()) {
            elements = this.removeDuplicates(elements);
            this.modules = Collections.singletonList(Elements.getModule(elements));
        }
        for (Element e : elements) {
            if (e instanceof Binding) {
                Binding binding = (Binding)e;
                bindings.put(binding.getKey(), binding);
                continue;
            }
            if (!(e instanceof PrivateElements)) continue;
            this.extractPrivateElements(bindings, (PrivateElements)e);
        }
        this.mapBindings(bindings, registry);
        this.applicationContext.publishEvent((ApplicationEvent)new CreateInjectorSignalEvent());
    }

    private void extractPrivateElements(Map<Key<?>, Binding<?>> bindings, PrivateElements privateElements) {
        List elements = privateElements.getElements();
        for (Element e : elements) {
            if (e instanceof Binding && privateElements.getExposedKeys().contains(((Binding)e).getKey())) {
                Binding binding = (Binding)e;
                bindings.put(binding.getKey(), binding);
                continue;
            }
            if (!(e instanceof PrivateElements)) continue;
            this.extractPrivateElements(bindings, (PrivateElements)e);
        }
    }

    protected List<Element> removeDuplicates(List<Element> elements) {
        List duplicateElements = elements.stream().filter(e -> e instanceof Binding).map(e -> (Binding)e).collect(Collectors.groupingBy(Binding::getKey)).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1 && ((List)e.getValue()).stream().anyMatch(binding -> binding.getSource() != null && binding.getSource().toString().contains("spring-guice"))).flatMap(e -> ((List)e.getValue()).stream()).filter(e -> e.getSource() != null && !e.getSource().toString().contains("spring-guice")).collect(Collectors.toList());
        List<Element> dedupedElements = elements.stream().filter(e -> {
            if (e instanceof Binding) {
                return !duplicateElements.contains(new SourceComparableBinding((Binding)e));
            }
            return true;
        }).collect(Collectors.toList());
        return dedupedElements;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(CreateInjectorSignalEvent event) {
        this.createInjector(this.modules, this.beanFactory);
    }

    private static class SourceComparableBinding {
        private Binding<?> binding;

        public SourceComparableBinding(Binding<?> binding) {
            this.binding = binding;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Binding) {
                Binding compareTo = (Binding)obj;
                if (compareTo.getSource() != null && this.binding != null) {
                    return this.binding.equals((Object)compareTo) && this.binding.getSource().equals(compareTo.getSource());
                }
                return this.binding.equals((Object)compareTo);
            }
            return false;
        }
    }
}

