/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.guice.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AspectJTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.guice.annotation.GuiceModule;
import org.springframework.guice.module.GuiceModuleMetadata;
import org.springframework.util.Assert;

class GuiceModuleRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware {
    private ResourceLoader resourceLoader = new DefaultResourceLoader();

    GuiceModuleRegistrar() {
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata annotation, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(GuiceModuleMetadataFactory.class);
        builder.addPropertyValue("includeFilters", this.parseFilters(annotation, "includeFilters"));
        builder.addPropertyValue("excludeFilters", this.parseFilters(annotation, "excludeFilters"));
        builder.addPropertyValue("includePatterns", this.parsePatterns(annotation, "includePatterns"));
        builder.addPropertyValue("excludePatterns", this.parsePatterns(annotation, "excludePatterns"));
        builder.addPropertyValue("includeNames", this.parseNames(annotation, "includeNames"));
        builder.addPropertyValue("excludeNames", this.parseNames(annotation, "excludeNames"));
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        String name = new DefaultBeanNameGenerator().generateBeanName((BeanDefinition)definition, registry);
        registry.registerBeanDefinition(name, (BeanDefinition)definition);
    }

    private Set<Pattern> parsePatterns(AnnotationMetadata annotation, String attributeName) {
        String[] filters;
        HashSet<Pattern> result = new HashSet<Pattern>();
        AnnotationAttributes attributes = new AnnotationAttributes(annotation.getAnnotationAttributes(GuiceModule.class.getName()));
        for (String filter : filters = attributes.getStringArray(attributeName)) {
            result.add(Pattern.compile(filter));
        }
        return result;
    }

    private Set<String> parseNames(AnnotationMetadata annotation, String attributeName) {
        String[] filters;
        HashSet<String> result = new HashSet<String>();
        AnnotationAttributes attributes = new AnnotationAttributes(annotation.getAnnotationAttributes(GuiceModule.class.getName()));
        for (String filter : filters = attributes.getStringArray(attributeName)) {
            result.add(filter);
        }
        return result;
    }

    private Set<TypeFilter> parseFilters(AnnotationMetadata annotation, String attributeName) {
        AnnotationAttributes[] filters;
        HashSet<TypeFilter> result = new HashSet<TypeFilter>();
        AnnotationAttributes attributes = new AnnotationAttributes(annotation.getAnnotationAttributes(GuiceModule.class.getName()));
        for (AnnotationAttributes filter : filters = attributes.getAnnotationArray(attributeName)) {
            result.addAll(this.typeFiltersFor(filter));
        }
        return result;
    }

    private List<TypeFilter> typeFiltersFor(AnnotationAttributes filterAttributes) {
        ArrayList<TypeFilter> typeFilters = new ArrayList<TypeFilter>();
        FilterType filterType = (FilterType)filterAttributes.getEnum("type");
        block5: for (Class filterClass : filterAttributes.getClassArray("value")) {
            switch (filterType) {
                case ANNOTATION: {
                    Assert.isAssignable(Annotation.class, (Class)filterClass, (String)"An error occured when processing a @ComponentScan ANNOTATION type filter: ");
                    Class annoClass = filterClass;
                    typeFilters.add((TypeFilter)new AnnotationTypeFilter(annoClass));
                    continue block5;
                }
                case ASSIGNABLE_TYPE: {
                    typeFilters.add((TypeFilter)new AssignableTypeFilter(filterClass));
                    continue block5;
                }
                case CUSTOM: {
                    Assert.isAssignable(TypeFilter.class, (Class)filterClass, (String)"An error occured when processing a @ComponentScan CUSTOM type filter: ");
                    typeFilters.add((TypeFilter)BeanUtils.instantiateClass((Class)filterClass, TypeFilter.class));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown filter type " + filterType);
                }
            }
        }
        for (String expression : this.getPatterns(filterAttributes)) {
            String rawName = filterType.toString();
            if ("REGEX".equals(rawName)) {
                typeFilters.add((TypeFilter)new RegexPatternTypeFilter(Pattern.compile(expression)));
                continue;
            }
            if ("ASPECTJ".equals(rawName)) {
                typeFilters.add((TypeFilter)new AspectJTypeFilter(expression, this.resourceLoader.getClassLoader()));
                continue;
            }
            throw new IllegalArgumentException("Unknown filter type " + filterType);
        }
        return typeFilters;
    }

    private String[] getPatterns(AnnotationAttributes filterAttributes) {
        try {
            return filterAttributes.getStringArray("pattern");
        }
        catch (IllegalArgumentException o_O) {
            return new String[0];
        }
    }

    protected static class GuiceModuleMetadataFactory
    implements FactoryBean<GuiceModuleMetadata> {
        private Collection<? extends TypeFilter> includeFilters;
        private Collection<? extends TypeFilter> excludeFilters;
        private Collection<Pattern> includePatterns;
        private Collection<Pattern> excludePatterns;
        private Collection<String> includeNames;
        private Collection<String> excludeNames;

        protected GuiceModuleMetadataFactory() {
        }

        public void setIncludeFilters(Collection<? extends TypeFilter> includeFilters) {
            this.includeFilters = includeFilters;
        }

        public void setExcludeFilters(Collection<? extends TypeFilter> excludeFilters) {
            this.excludeFilters = excludeFilters;
        }

        public void setIncludePatterns(Collection<Pattern> includePatterns) {
            this.includePatterns = includePatterns;
        }

        public void setExcludePatterns(Collection<Pattern> excludePatterns) {
            this.excludePatterns = excludePatterns;
        }

        public void setIncludeNames(Collection<String> includeNames) {
            this.includeNames = includeNames;
        }

        public void setExcludeNames(Collection<String> excludeNames) {
            this.excludeNames = excludeNames;
        }

        public GuiceModuleMetadata getObject() throws Exception {
            return new GuiceModuleMetadata().include(this.includeFilters.toArray(new TypeFilter[this.includeFilters.size()])).exclude(this.excludeFilters.toArray(new TypeFilter[this.excludeFilters.size()])).include(this.includePatterns.toArray(new Pattern[this.includePatterns.size()])).exclude(this.excludePatterns.toArray(new Pattern[this.excludePatterns.size()])).include(this.includeNames.toArray(new String[this.includeNames.size()])).exclude(this.excludeNames.toArray(new String[this.excludeNames.size()]));
        }

        public Class<?> getObjectType() {
            return GuiceModuleMetadata.class;
        }

        public boolean isSingleton() {
            return false;
        }
    }
}

