/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.guice.annotation;

import com.google.inject.Injector;
import com.google.inject.Key;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

class GuiceFactoryBean<T>
implements FactoryBean<T> {
    private final Key<T> key;
    private final Class<T> beanType;
    @Autowired
    private Injector injector;

    public GuiceFactoryBean(Class<T> beanType, Key<T> key) {
        this.beanType = beanType;
        this.key = key;
    }

    public T getObject() throws Exception {
        return (T)this.injector.getInstance(this.key);
    }

    public Class<?> getObjectType() {
        return this.beanType;
    }

    public boolean isSingleton() {
        return true;
    }
}

