/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.test;

import io.grpc.BindableService;
import io.grpc.ChannelCredentials;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import java.time.Duration;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.grpc.autoconfigure.client.ClientInterceptorsConfiguration;
import org.springframework.grpc.autoconfigure.client.GrpcClientAutoConfiguration;
import org.springframework.grpc.autoconfigure.server.GrpcServerFactoryAutoConfiguration;
import org.springframework.grpc.client.ClientInterceptorsConfigurer;
import org.springframework.grpc.client.InProcessGrpcChannelFactory;
import org.springframework.grpc.server.GrpcServerFactory;
import org.springframework.grpc.server.InProcessGrpcServerFactory;
import org.springframework.grpc.server.ServerBuilderCustomizer;
import org.springframework.grpc.server.ServerServiceDefinitionFilter;
import org.springframework.grpc.server.lifecycle.GrpcServerLifecycle;
import org.springframework.grpc.server.service.GrpcServiceConfigurer;
import org.springframework.grpc.server.service.GrpcServiceDiscoverer;
import org.springframework.lang.Nullable;

@AutoConfiguration(before={GrpcServerFactoryAutoConfiguration.class, GrpcClientAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.grpc.test.inprocess", name={"enabled"}, havingValue="true")
@ConditionalOnClass(value={BindableService.class})
@Import(value={ClientInterceptorsConfiguration.class})
public class InProcessTestAutoConfiguration {
    private final String address = InProcessServerBuilder.generateName();

    @Bean
    @ConditionalOnBean(value={BindableService.class})
    @Order(value=-2147483648)
    TestInProcessGrpcServerFactory testInProcessGrpcServerFactory(GrpcServiceDiscoverer serviceDiscoverer, GrpcServiceConfigurer serviceConfigurer, List<ServerBuilderCustomizer<InProcessServerBuilder>> customizers, @Nullable ServerServiceDefinitionFilter serviceFilter) {
        TestInProcessGrpcServerFactory factory = new TestInProcessGrpcServerFactory(this.address, customizers, serviceFilter);
        serviceDiscoverer.findServices().stream().map(serviceSpec -> serviceConfigurer.configure(serviceSpec, (GrpcServerFactory)factory)).forEach(arg_0 -> ((TestInProcessGrpcServerFactory)factory).addService(arg_0));
        return factory;
    }

    @Bean
    @Order(value=-2147483648)
    TestInProcessGrpcChannelFactory testInProcessGrpcChannelFactory(ClientInterceptorsConfigurer interceptorsConfigurer) {
        return new TestInProcessGrpcChannelFactory(this.address, interceptorsConfigurer);
    }

    @Bean(name={"inProcessGrpcServerLifecycle"})
    @ConditionalOnBean(value={InProcessGrpcServerFactory.class})
    @Order(value=-2147483648)
    GrpcServerLifecycle inProcessGrpcServerLifecycle(InProcessGrpcServerFactory factory, ApplicationEventPublisher eventPublisher) {
        return new GrpcServerLifecycle((GrpcServerFactory)factory, Duration.ofSeconds(30L), eventPublisher);
    }

    public static class TestInProcessGrpcServerFactory
    extends InProcessGrpcServerFactory {
        public TestInProcessGrpcServerFactory(String address, List<ServerBuilderCustomizer<InProcessServerBuilder>> serverBuilderCustomizers, @Nullable ServerServiceDefinitionFilter serviceFilter) {
            super(address, serverBuilderCustomizers);
            this.setServiceFilter(serviceFilter);
        }
    }

    public static class TestInProcessGrpcChannelFactory
    extends InProcessGrpcChannelFactory {
        TestInProcessGrpcChannelFactory(String address, ClientInterceptorsConfigurer interceptorsConfigurer) {
            super(List.of(), interceptorsConfigurer);
            this.setVirtualTargets(path -> address);
        }

        public boolean supports(String target) {
            return true;
        }

        protected InProcessChannelBuilder newChannelBuilder(String target, ChannelCredentials creds) {
            if (target.startsWith("in-process:")) {
                return super.newChannelBuilder(target, creds);
            }
            return InProcessChannelBuilder.forName((String)target);
        }
    }
}

