/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.language.FieldDefinition;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.idl.RuntimeWiring;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.core.MethodParameter;
import org.springframework.core.Nullness;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.graphql.execution.SchemaReport;
import org.springframework.graphql.execution.SelfDescribingDataFetcher;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class SchemaMappingInspector {
    private static final Log logger = LogFactory.getLog(SchemaMappingInspector.class);
    private static final Predicate<Method> recordLikePredicate = method -> !method.getDeclaringClass().equals(Object.class) && !method.getReturnType().equals(Void.class) && method.getParameterCount() == 0 && Modifier.isPublic(method.getModifiers());
    private final GraphQLSchema schema;
    private final Map<String, Map<String, DataFetcher>> dataFetchers;
    private final InterfaceUnionLookup interfaceUnionLookup;
    private final Set<String> inspectedTypes = new HashSet<String>();
    private final ReportBuilder reportBuilder = new ReportBuilder();
    private @Nullable SchemaReport report;

    private SchemaMappingInspector(GraphQLSchema schema, Map<String, Map<String, DataFetcher>> dataFetchers, InterfaceUnionLookup interfaceUnionLookup) {
        Assert.notNull((Object)schema, (String)"GraphQLSchema is required");
        Assert.notNull(dataFetchers, (String)"DataFetcher map is required");
        Assert.notNull((Object)interfaceUnionLookup, (String)"InterfaceUnionLookup is required");
        this.schema = schema;
        this.dataFetchers = dataFetchers;
        this.interfaceUnionLookup = interfaceUnionLookup;
    }

    public SchemaReport getOrCreateReport() {
        if (this.report == null) {
            this.checkSchemaFields();
            this.checkDataFetcherRegistrations();
            this.report = this.reportBuilder.build();
        }
        return this.report;
    }

    private void checkSchemaFields() {
        this.checkFieldsContainer((GraphQLFieldsContainer)this.schema.getQueryType(), null);
        if (this.schema.isSupportingMutations()) {
            this.checkFieldsContainer((GraphQLFieldsContainer)this.schema.getMutationType(), null);
        }
        if (this.schema.isSupportingSubscriptions()) {
            this.checkFieldsContainer((GraphQLFieldsContainer)this.schema.getSubscriptionType(), null);
        }
    }

    private void checkFieldsContainer(GraphQLFieldsContainer fieldContainer, @Nullable ResolvableType resolvableType) {
        if (!this.inspectedTypes.add(fieldContainer.getName())) {
            return;
        }
        String typeName = fieldContainer.getName();
        Map dataFetcherMap = this.dataFetchers.getOrDefault(typeName, Collections.emptyMap());
        for (GraphQLFieldDefinition field : fieldContainer.getFieldDefinitions()) {
            String fieldName = field.getName();
            DataFetcher dataFetcher = (DataFetcher)dataFetcherMap.get(fieldName);
            FieldCoordinates fieldCoordinates = FieldCoordinates.coordinates((String)typeName, (String)fieldName);
            Nullness schemaNullness = this.resolveNullness(field);
            if (dataFetcher != null) {
                if (dataFetcher instanceof SelfDescribingDataFetcher) {
                    SelfDescribingDataFetcher selfDescribing = (SelfDescribingDataFetcher)dataFetcher;
                    this.checkDataFetcherNullness(fieldCoordinates, selfDescribing, schemaNullness);
                    this.checkFieldArguments(field, selfDescribing);
                    this.checkFieldArgumentsNullness(field, selfDescribing);
                    this.checkField(fieldContainer, field, selfDescribing.getReturnType());
                    continue;
                }
                this.checkField(fieldContainer, field, ResolvableType.NONE);
                continue;
            }
            if (resolvableType != null) {
                PropertyDescriptor descriptor = this.getProperty(resolvableType, fieldName);
                if (descriptor != null) {
                    MethodParameter returnType = new MethodParameter(descriptor.getReadMethod(), -1);
                    this.checkReadMethodNullness(fieldCoordinates, resolvableType, descriptor, schemaNullness);
                    this.checkField(fieldContainer, field, ResolvableType.forMethodParameter((MethodParameter)returnType, (ResolvableType)resolvableType));
                    continue;
                }
                Field javaField = this.getField(resolvableType, fieldName);
                if (javaField != null) {
                    this.checkFieldNullNess(fieldCoordinates, javaField, schemaNullness);
                    this.checkField(fieldContainer, field, ResolvableType.forField((Field)javaField));
                    continue;
                }
                Method method = SchemaMappingInspector.getOtherAccessor(resolvableType, fieldName);
                if (method != null) {
                    MethodParameter returnType = new MethodParameter(method, -1);
                    this.checkField(fieldContainer, field, ResolvableType.forMethodParameter((MethodParameter)returnType, (ResolvableType)resolvableType));
                    continue;
                }
            }
            this.reportBuilder.unmappedField(fieldCoordinates);
        }
    }

    private void checkFieldNullNess(FieldCoordinates fieldCoordinates, Field javaField, Nullness schemaNullness) {
        Nullness applicationNullness = Nullness.forField((Field)javaField);
        if (this.isFieldNullnessError(schemaNullness, applicationNullness)) {
            DescribedAnnotatedElement annotatedElement = new DescribedAnnotatedElement(javaField, javaField.getDeclaringClass().getSimpleName() + "#" + javaField.getName());
            this.reportBuilder.fieldNullnessError(fieldCoordinates, new DefaultNullnessError(schemaNullness, applicationNullness, annotatedElement));
        }
    }

    private void checkDataFetcherNullness(FieldCoordinates fieldCoordinates, SelfDescribingDataFetcher dataFetcher, Nullness schemaNullness) {
        Method dataFetcherMethod = dataFetcher.asMethod();
        if (dataFetcherMethod != null) {
            Nullness applicationNullness = Nullness.forMethodReturnType((Method)dataFetcherMethod);
            ReactiveAdapter reactiveAdapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(dataFetcherMethod.getReturnType());
            if (reactiveAdapter != null) {
                logger.debug((Object)("Skip nullness check for data fetcher '" + dataFetcherMethod.getName() + "' because of Reactive return type."));
            } else if (dataFetcher.usesDataLoader() && Map.class.isAssignableFrom(dataFetcherMethod.getReturnType())) {
                logger.debug((Object)("Skip nullness check for data fetcher '" + dataFetcherMethod.getName() + "' because of batch loading."));
            } else if (this.isFieldNullnessError(schemaNullness, applicationNullness)) {
                DescribedAnnotatedElement annotatedElement = new DescribedAnnotatedElement(dataFetcherMethod, dataFetcher.getDescription());
                this.reportBuilder.fieldNullnessError(fieldCoordinates, new DefaultNullnessError(schemaNullness, applicationNullness, annotatedElement));
            }
        }
    }

    private void checkFieldArguments(GraphQLFieldDefinition field, SelfDescribingDataFetcher<?> dataFetcher) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (String name : dataFetcher.getArguments().keySet()) {
            if (field.getArgument(name) != null) continue;
            arguments.add(name);
        }
        if (!arguments.isEmpty()) {
            this.reportBuilder.unmappedArgument(dataFetcher, arguments);
        }
    }

    private void checkFieldArgumentsNullness(GraphQLFieldDefinition field, SelfDescribingDataFetcher<?> dataFetcher) {
        Method dataFetcherMethod = dataFetcher.asMethod();
        if (dataFetcherMethod != null) {
            ArrayList<SchemaReport.NullnessError> nullnessErrors = new ArrayList<SchemaReport.NullnessError>();
            for (Parameter parameter : dataFetcherMethod.getParameters()) {
                Nullness applicationNullness;
                Nullness schemaNullness;
                GraphQLArgument argument = field.getArgument(parameter.getName());
                if (argument == null || argument.getDefinition() == null || !this.isArgumentNullnessError(schemaNullness = this.resolveNullness(argument.getDefinition().getType()), applicationNullness = Nullness.forMethodParameter((MethodParameter)MethodParameter.forParameter((Parameter)parameter)))) continue;
                nullnessErrors.add(new DefaultNullnessError(schemaNullness, applicationNullness, parameter));
            }
            if (!nullnessErrors.isEmpty()) {
                this.reportBuilder.argumentsNullnessErrors(dataFetcher, nullnessErrors);
            }
        }
    }

    private void checkReadMethodNullness(FieldCoordinates fieldCoordinates, ResolvableType resolvableType, PropertyDescriptor descriptor, Nullness schemaNullness) {
        Nullness applicationNullness = Nullness.forMethodReturnType((Method)descriptor.getReadMethod());
        if (this.isFieldNullnessError(schemaNullness, applicationNullness)) {
            DescribedAnnotatedElement annotatedElement = new DescribedAnnotatedElement(descriptor.getReadMethod(), resolvableType.toClass().getSimpleName() + "#" + descriptor.getName());
            this.reportBuilder.fieldNullnessError(fieldCoordinates, new DefaultNullnessError(schemaNullness, applicationNullness, annotatedElement));
        }
    }

    private void checkField(GraphQLFieldsContainer parent, GraphQLFieldDefinition field, ResolvableType resolvableType) {
        TypePair typePair = TypePair.resolveTypePair((GraphQLType)parent, field, resolvableType, this.schema);
        LinkedMultiValueMap typePairs = new LinkedMultiValueMap();
        GraphQLType graphQLType = typePair.outputType();
        if (graphQLType instanceof GraphQLUnionType) {
            GraphQLUnionType unionType = (GraphQLUnionType)graphQLType;
            typePairs.putAll(this.interfaceUnionLookup.resolveUnion(unionType));
        } else {
            graphQLType = typePair.outputType();
            if (graphQLType instanceof GraphQLInterfaceType) {
                GraphQLInterfaceType interfaceType = (GraphQLInterfaceType)graphQLType;
                typePairs.putAll(this.interfaceUnionLookup.resolveInterface(interfaceType));
            }
        }
        if (typePairs.isEmpty()) {
            typePairs.add((Object)typePair.outputType(), (Object)typePair.resolvableType());
        }
        for (Map.Entry entry : typePairs.entrySet()) {
            GraphQLType graphQlType = (GraphQLType)entry.getKey();
            for (ResolvableType currentResolvableType : (List)entry.getValue()) {
                if (!(graphQlType instanceof GraphQLFieldsContainer)) {
                    if (!SchemaMappingInspector.isNotScalarOrEnumType(graphQlType)) continue;
                    this.reportBuilder.skippedType(graphQlType, parent, field, "Unsupported schema type", false);
                    continue;
                }
                GraphQLFieldsContainer fieldContainer = (GraphQLFieldsContainer)graphQlType;
                if (currentResolvableType.resolve(Object.class) == Object.class) {
                    boolean isDerived = !graphQlType.equals((Object)typePair.outputType());
                    this.reportBuilder.skippedType(graphQlType, parent, field, "No class information", isDerived);
                    continue;
                }
                this.checkFieldsContainer(fieldContainer, currentResolvableType);
            }
        }
    }

    private @Nullable PropertyDescriptor getProperty(ResolvableType resolvableType, String fieldName) {
        try {
            Class clazz = resolvableType.resolve();
            return clazz != null ? BeanUtils.getPropertyDescriptor((Class)clazz, (String)fieldName) : null;
        }
        catch (BeansException ex) {
            throw new IllegalStateException("Failed to get property on " + String.valueOf(resolvableType) + " for field '" + fieldName + "'", ex);
        }
    }

    private @Nullable Field getField(ResolvableType resolvableType, String fieldName) {
        try {
            Class clazz = resolvableType.resolve();
            return clazz != null ? clazz.getField(fieldName) : null;
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
    }

    private static @Nullable Method getOtherAccessor(ResolvableType resolvableType, String fieldName) {
        Class clazz = resolvableType.resolve();
        if (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (recordLikePredicate.test(method) && fieldName.equals(StringUtils.uncapitalize((String)method.getName()))) {
                    return method;
                }
                if (!method.getReturnType().equals(Boolean.class) || !method.getName().equals("is" + StringUtils.capitalize((String)fieldName))) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean isNotScalarOrEnumType(GraphQLType type) {
        return !(type instanceof GraphQLScalarType) && !(type instanceof GraphQLEnumType);
    }

    private void checkDataFetcherRegistrations() {
        this.dataFetchers.forEach((typeName, registrations) -> registrations.forEach((fieldName, dataFetcher) -> {
            FieldCoordinates coordinates = FieldCoordinates.coordinates((String)typeName, (String)fieldName);
            if (this.schema.getFieldDefinition(coordinates) == null) {
                this.reportBuilder.unmappedRegistration(coordinates, (DataFetcher<?>)dataFetcher);
            }
        }));
    }

    private Nullness resolveNullness(GraphQLFieldDefinition fieldDefinition) {
        FieldDefinition definition = fieldDefinition.getDefinition();
        if (definition != null) {
            return this.resolveNullness(definition.getType());
        }
        return Nullness.UNSPECIFIED;
    }

    private Nullness resolveNullness(Type type) {
        if (type instanceof NonNullType) {
            return Nullness.NON_NULL;
        }
        return Nullness.NULLABLE;
    }

    private boolean isFieldNullnessError(Nullness schemaNullness, Nullness applicationNullness) {
        return schemaNullness == Nullness.NON_NULL && applicationNullness == Nullness.NULLABLE;
    }

    private boolean isArgumentNullnessError(Nullness schemaNullness, Nullness applicationNullness) {
        return schemaNullness == Nullness.NULLABLE && applicationNullness == Nullness.NON_NULL;
    }

    public static SchemaReport inspect(GraphQLSchema schema, RuntimeWiring runtimeWiring) {
        return SchemaMappingInspector.inspect(schema, runtimeWiring.getDataFetchers());
    }

    public static SchemaReport inspect(GraphQLSchema schema, Map<String, Map<String, DataFetcher>> fetchers) {
        return SchemaMappingInspector.initializer().inspect(schema, fetchers);
    }

    public static Initializer initializer() {
        return new DefaultInitializer();
    }

    private final class ReportBuilder {
        private final List<FieldCoordinates> unmappedFields = new ArrayList<FieldCoordinates>();
        private final Map<FieldCoordinates, DataFetcher<?>> unmappedRegistrations = new LinkedHashMap();
        private final MultiValueMap<DataFetcher<?>, String> unmappedArguments = new LinkedMultiValueMap();
        private final Map<FieldCoordinates, SchemaReport.NullnessError> fieldNullnessErrors = new LinkedHashMap<FieldCoordinates, SchemaReport.NullnessError>();
        private final MultiValueMap<DataFetcher<?>, SchemaReport.NullnessError> argumentsNullnessErrors = new LinkedMultiValueMap();
        private final List<DefaultSkippedType> skippedTypes = new ArrayList<DefaultSkippedType>();
        private final List<DefaultSkippedType> candidateSkippedTypes = new ArrayList<DefaultSkippedType>();

        private ReportBuilder() {
        }

        void unmappedField(FieldCoordinates coordinates) {
            this.unmappedFields.add(coordinates);
        }

        void unmappedRegistration(FieldCoordinates coordinates, DataFetcher<?> dataFetcher) {
            this.unmappedRegistrations.put(coordinates, dataFetcher);
        }

        void unmappedArgument(DataFetcher<?> dataFetcher, List<String> arguments) {
            this.unmappedArguments.put(dataFetcher, arguments);
        }

        void fieldNullnessError(FieldCoordinates coordinates, SchemaReport.NullnessError nullnessError) {
            this.fieldNullnessErrors.put(coordinates, nullnessError);
        }

        void argumentsNullnessErrors(DataFetcher<?> dataFetcher, List<SchemaReport.NullnessError> nullnessErrors) {
            this.argumentsNullnessErrors.put(dataFetcher, nullnessErrors);
        }

        void skippedType(GraphQLType type, GraphQLFieldsContainer parent, GraphQLFieldDefinition field, String reason, boolean isDerivedType) {
            DefaultSkippedType skippedType = DefaultSkippedType.create(type, parent, field, reason);
            if (!isDerivedType) {
                this.skippedType(skippedType);
                return;
            }
            this.candidateSkippedTypes.add(skippedType);
        }

        private void skippedType(DefaultSkippedType skippedType) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skipping '" + String.valueOf(skippedType) + "': " + skippedType.reason()));
            }
            this.skippedTypes.add(skippedType);
        }

        SchemaReport build() {
            this.candidateSkippedTypes.forEach(skippedType -> {
                GraphQLFieldsContainer fieldsContainer;
                GraphQLType patt0$temp = skippedType.type();
                if (patt0$temp instanceof GraphQLFieldsContainer && SchemaMappingInspector.this.inspectedTypes.contains((fieldsContainer = (GraphQLFieldsContainer)patt0$temp).getName())) {
                    return;
                }
                this.skippedType((DefaultSkippedType)skippedType);
            });
            return new DefaultSchemaReport(this.unmappedFields, this.unmappedRegistrations, this.unmappedArguments, this.fieldNullnessErrors, this.argumentsNullnessErrors, this.skippedTypes);
        }
    }

    private static final class InterfaceUnionLookup {
        private static final LinkedMultiValueMap<GraphQLType, ResolvableType> EMPTY_MAP = new LinkedMultiValueMap(0);
        private final Map<String, MultiValueMap<GraphQLType, ResolvableType>> mappings;

        private InterfaceUnionLookup(Map<String, MultiValueMap<GraphQLType, ResolvableType>> mappings) {
            this.mappings = mappings;
        }

        MultiValueMap<GraphQLType, ResolvableType> resolveInterface(GraphQLInterfaceType interfaceType) {
            return (MultiValueMap)this.mappings.getOrDefault(interfaceType.getName(), (MultiValueMap<GraphQLType, ResolvableType>)EMPTY_MAP);
        }

        MultiValueMap<GraphQLType, ResolvableType> resolveUnion(GraphQLUnionType unionType) {
            return (MultiValueMap)this.mappings.getOrDefault(unionType.getName(), (MultiValueMap<GraphQLType, ResolvableType>)EMPTY_MAP);
        }

        public static InterfaceUnionLookup create(GraphQLSchema schema, List<ClassResolver> classResolvers) {
            LinkedHashMap<String, MultiValueMap<GraphQLType, ResolvableType>> mappings = new LinkedHashMap<String, MultiValueMap<GraphQLType, ResolvableType>>();
            for (GraphQLNamedType type : schema.getAllTypesAsList()) {
                if (type instanceof GraphQLUnionType) {
                    GraphQLUnionType union = (GraphQLUnionType)type;
                    for (GraphQLNamedOutputType member : union.getTypes()) {
                        InterfaceUnionLookup.addTypeMapping((GraphQLNamedOutputType)union, (GraphQLObjectType)member, classResolvers, mappings);
                    }
                    continue;
                }
                if (!(type instanceof GraphQLObjectType)) continue;
                GraphQLObjectType objectType = (GraphQLObjectType)type;
                for (GraphQLNamedOutputType interfaceType : objectType.getInterfaces()) {
                    InterfaceUnionLookup.addTypeMapping(interfaceType, objectType, classResolvers, mappings);
                }
            }
            return new InterfaceUnionLookup(mappings);
        }

        private static void addTypeMapping(GraphQLNamedOutputType interfaceOrUnionType, GraphQLObjectType objectType, List<ClassResolver> classResolvers, Map<String, MultiValueMap<GraphQLType, ResolvableType>> mappings) {
            ArrayList<ResolvableType> resolvableTypes = new ArrayList<ResolvableType>();
            for (ClassResolver resolver : classResolvers) {
                List<Class<?>> classes = resolver.resolveClass(objectType, interfaceOrUnionType);
                if (classes.isEmpty()) continue;
                for (Class<?> clazz : classes) {
                    ResolvableType resolvableType = ResolvableType.forClass(clazz);
                    resolvableTypes.add(resolvableType);
                }
            }
            if (resolvableTypes.isEmpty()) {
                resolvableTypes.add(ResolvableType.NONE);
            }
            for (ResolvableType resolvableType : resolvableTypes) {
                String name = interfaceOrUnionType.getName();
                mappings.computeIfAbsent(name, n -> new LinkedMultiValueMap()).add((Object)objectType, (Object)resolvableType);
            }
        }
    }

    private record DescribedAnnotatedElement(AnnotatedElement delegate, String description) implements AnnotatedElement
    {
        @Override
        public String toString() {
            return this.description;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.delegate.getAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.delegate.getAnnotations();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.delegate.getDeclaredAnnotations();
        }
    }

    private record DefaultNullnessError(Nullness schemaNullness, Nullness applicationNullness, AnnotatedElement annotatedElement) implements SchemaReport.NullnessError
    {
    }

    private record TypePair(GraphQLType outputType, ResolvableType resolvableType) {
        private static final ReactiveAdapterRegistry adapterRegistry = ReactiveAdapterRegistry.getSharedInstance();

        public static TypePair resolveTypePair(GraphQLType parent, GraphQLFieldDefinition field, DataFetcher<?> fetcher, GraphQLSchema schema) {
            ResolvableType resolvableType;
            if (fetcher instanceof SelfDescribingDataFetcher) {
                SelfDescribingDataFetcher sd = (SelfDescribingDataFetcher)fetcher;
                resolvableType = sd.getReturnType();
            } else {
                resolvableType = ResolvableType.NONE;
            }
            return TypePair.resolveTypePair(parent, field, resolvableType, schema);
        }

        public static TypePair resolveTypePair(GraphQLType parent, GraphQLFieldDefinition field, ResolvableType resolvableType, GraphQLSchema schema) {
            GraphQLType outputType = TypePair.unwrapIfNonNull((GraphQLType)field.getType());
            GraphQLType paginatedType = TypePair.getPaginatedType(outputType);
            if (paginatedType != null) {
                outputType = paginatedType;
                resolvableType = TypePair.nestForConnection(resolvableType);
            } else if (outputType instanceof GraphQLList) {
                GraphQLList listType = (GraphQLList)outputType;
                outputType = TypePair.unwrapIfNonNull(listType.getWrappedType());
                resolvableType = TypePair.nestForList(resolvableType, parent == schema.getSubscriptionType());
            } else {
                resolvableType = TypePair.nestIfWrappedType(resolvableType);
            }
            return new TypePair(outputType, resolvableType);
        }

        private static GraphQLType unwrapIfNonNull(GraphQLType type) {
            GraphQLType graphQLType;
            if (type instanceof GraphQLNonNull) {
                GraphQLNonNull graphQLNonNull = (GraphQLNonNull)type;
                graphQLType = graphQLNonNull.getWrappedType();
            } else {
                graphQLType = type;
            }
            return graphQLType;
        }

        private static @Nullable GraphQLType getPaginatedType(GraphQLType type) {
            GraphQLObjectType cot;
            if (!(type instanceof GraphQLObjectType) || !(cot = (GraphQLObjectType)type).getName().endsWith("Connection")) {
                return null;
            }
            GraphQLFieldDefinition edges = cot.getField("edges");
            if (edges == null) {
                return null;
            }
            GraphQLType graphQLType = TypePair.unwrapIfNonNull((GraphQLType)edges.getType());
            if (!(graphQLType instanceof GraphQLList)) {
                return null;
            }
            GraphQLList lt = (GraphQLList)graphQLType;
            GraphQLType graphQLType2 = lt.getWrappedType();
            if (!(graphQLType2 instanceof GraphQLObjectType)) {
                return null;
            }
            GraphQLObjectType eot = (GraphQLObjectType)graphQLType2;
            GraphQLFieldDefinition node = eot.getField("node");
            if (node == null) {
                return null;
            }
            return TypePair.unwrapIfNonNull((GraphQLType)node.getType());
        }

        private static ResolvableType nestForConnection(ResolvableType type) {
            if (type == ResolvableType.NONE) {
                return type;
            }
            type = TypePair.nestIfWrappedType(type);
            if (logger.isDebugEnabled() && type.getGenerics().length != 1) {
                logger.debug((Object)("Expected Connection type to have a generic parameter: " + String.valueOf(type)));
            }
            return type.getNested(2);
        }

        private static ResolvableType nestIfWrappedType(ResolvableType type) {
            Class clazz = type.resolve(Object.class);
            if (Optional.class.isAssignableFrom(clazz)) {
                if (logger.isDebugEnabled() && type.getGeneric(new int[]{0}).resolve() == null) {
                    logger.debug((Object)("Expected Optional type to have a generic parameter: " + String.valueOf(type)));
                }
                return type.getNested(2);
            }
            ReactiveAdapter adapter = adapterRegistry.getAdapter(clazz);
            if (adapter != null) {
                if (logger.isDebugEnabled() && adapter.isNoValue()) {
                    logger.debug((Object)("Expected reactive/async return type that can produce value(s): " + String.valueOf(type)));
                }
                return type.getNested(2);
            }
            return type;
        }

        private static ResolvableType nestForList(ResolvableType type, boolean subscription) {
            if (type == ResolvableType.NONE) {
                return type;
            }
            ReactiveAdapter adapter = adapterRegistry.getAdapter(type.resolve(Object.class));
            if (adapter != null) {
                if (logger.isDebugEnabled() && adapter.isNoValue()) {
                    logger.debug((Object)("Expected List compatible type: " + String.valueOf(type)));
                }
                type = type.getNested(2);
                if (adapter.isMultiValue() && !subscription) {
                    return type;
                }
            }
            if (logger.isDebugEnabled() && !type.isArray() && type.getGenerics().length != 1) {
                logger.debug((Object)("Expected List compatible type: " + String.valueOf(type)));
            }
            return type.getNested(2);
        }
    }

    public static interface Initializer {
        public Initializer classMapping(String var1, Class<?> ... var2);

        public Initializer classNameFunction(Function<GraphQLObjectType, String> var1);

        public Initializer classResolver(ClassResolver var1);

        public SchemaReport inspect(GraphQLSchema var1, Map<String, Map<String, DataFetcher>> var2);
    }

    private static final class DefaultInitializer
    implements Initializer {
        private Function<GraphQLObjectType, String> classNameFunction = GraphQLObjectType::getName;
        private final List<ClassResolver> classResolvers = new ArrayList<ClassResolver>();
        private final MultiValueMap<String, Class<?>> classMappings = new LinkedMultiValueMap();

        private DefaultInitializer() {
        }

        @Override
        public Initializer classNameFunction(Function<GraphQLObjectType, String> function) {
            this.classNameFunction = function;
            return this;
        }

        @Override
        public Initializer classResolver(ClassResolver resolver) {
            this.classResolvers.add(resolver);
            return this;
        }

        @Override
        public Initializer classMapping(String graphQlTypeName, Class<?> ... classes) {
            for (Class<?> aClass : classes) {
                this.classMappings.add((Object)graphQlTypeName, aClass);
            }
            return this;
        }

        @Override
        public SchemaReport inspect(GraphQLSchema schema, Map<String, Map<String, DataFetcher>> fetchers) {
            ArrayList<ClassResolver> resolvers = new ArrayList<ClassResolver>(this.classResolvers);
            resolvers.add(new MappingClassResolver(this.classMappings));
            resolvers.add(ReflectionClassResolver.create(schema, fetchers, this.classNameFunction));
            InterfaceUnionLookup lookup = InterfaceUnionLookup.create(schema, resolvers);
            SchemaMappingInspector inspector = new SchemaMappingInspector(schema, fetchers, lookup);
            return inspector.getOrCreateReport();
        }
    }

    private record DefaultSkippedType(GraphQLType type, FieldCoordinates fieldCoordinates, String reason) implements SchemaReport.SkippedType
    {
        @Override
        public String toString() {
            String string;
            GraphQLType graphQLType = this.type;
            if (graphQLType instanceof GraphQLNamedType) {
                GraphQLNamedType named = (GraphQLNamedType)graphQLType;
                string = named.getName();
            } else {
                string = this.type.toString();
            }
            return string;
        }

        public static DefaultSkippedType create(GraphQLType type, GraphQLFieldsContainer parent, GraphQLFieldDefinition field, String reason) {
            return new DefaultSkippedType(type, FieldCoordinates.coordinates((GraphQLFieldsContainer)parent, (GraphQLFieldDefinition)field), reason);
        }
    }

    private final class DefaultSchemaReport
    implements SchemaReport {
        private final List<FieldCoordinates> unmappedFields;
        private final Map<FieldCoordinates, DataFetcher<?>> unmappedRegistrations;
        private final MultiValueMap<DataFetcher<?>, String> unmappedArguments;
        private final Map<FieldCoordinates, SchemaReport.NullnessError> fieldNullnessErrors;
        private final MultiValueMap<DataFetcher<?>, SchemaReport.NullnessError> argumentNullnessErrors;
        private final List<SchemaReport.SkippedType> skippedTypes;

        DefaultSchemaReport(List<FieldCoordinates> unmappedFields, Map<FieldCoordinates, DataFetcher<?>> unmappedRegistrations, MultiValueMap<DataFetcher<?>, String> unmappedArguments, Map<FieldCoordinates, SchemaReport.NullnessError> fieldNullnessErrors, MultiValueMap<DataFetcher<?>, SchemaReport.NullnessError> argumentNullnessErrors, List<DefaultSkippedType> skippedTypes) {
            this.unmappedFields = Collections.unmodifiableList(unmappedFields);
            this.unmappedRegistrations = Collections.unmodifiableMap(unmappedRegistrations);
            this.unmappedArguments = CollectionUtils.unmodifiableMultiValueMap(unmappedArguments);
            this.fieldNullnessErrors = Collections.unmodifiableMap(fieldNullnessErrors);
            this.argumentNullnessErrors = CollectionUtils.unmodifiableMultiValueMap(argumentNullnessErrors);
            this.skippedTypes = Collections.unmodifiableList(skippedTypes);
        }

        @Override
        public List<FieldCoordinates> unmappedFields() {
            return this.unmappedFields;
        }

        @Override
        public Map<FieldCoordinates, DataFetcher<?>> unmappedRegistrations() {
            return this.unmappedRegistrations;
        }

        @Override
        public MultiValueMap<DataFetcher<?>, String> unmappedArguments() {
            return this.unmappedArguments;
        }

        @Override
        public Map<FieldCoordinates, SchemaReport.NullnessError> fieldNullnessErrors() {
            return this.fieldNullnessErrors;
        }

        @Override
        public MultiValueMap<DataFetcher<?>, SchemaReport.NullnessError> argumentNullnessErrors() {
            return this.argumentNullnessErrors;
        }

        @Override
        public List<SchemaReport.SkippedType> skippedTypes() {
            return this.skippedTypes;
        }

        @Override
        public GraphQLSchema schema() {
            return SchemaMappingInspector.this.schema;
        }

        @Override
        public @Nullable DataFetcher<?> dataFetcher(FieldCoordinates coordinates) {
            return (DataFetcher)SchemaMappingInspector.this.dataFetchers.getOrDefault(coordinates.getTypeName(), Collections.emptyMap()).get(coordinates.getFieldName());
        }

        public String toString() {
            return "GraphQL schema inspection:\n\tUnmapped fields: " + this.formatUnmappedFields() + "\n\tUnmapped registrations: " + String.valueOf(this.unmappedRegistrations) + "\n\tUnmapped arguments: " + String.valueOf(this.unmappedArguments) + "\n\tField nullness errors: " + this.formatFieldNullnessErrors() + "\n\tArgument nullness errors: " + this.formatArgumentNullnessErrors() + "\n\tSkipped types: " + String.valueOf(this.skippedTypes);
        }

        private String formatUnmappedFields() {
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            this.unmappedFields.forEach(arg_0 -> DefaultSchemaReport.lambda$formatUnmappedFields$0((MultiValueMap)map, arg_0));
            return map.toString();
        }

        private String formatFieldNullnessErrors() {
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            this.fieldNullnessErrors.forEach((arg_0, arg_1) -> DefaultSchemaReport.lambda$formatFieldNullnessErrors$0((MultiValueMap)map, arg_0, arg_1));
            return map.toString();
        }

        private String formatArgumentNullnessErrors() {
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            this.argumentNullnessErrors.forEach((arg_0, arg_1) -> DefaultSchemaReport.lambda$formatArgumentNullnessErrors$0((MultiValueMap)map, arg_0, arg_1));
            return map.toString();
        }

        private static /* synthetic */ void lambda$formatArgumentNullnessErrors$0(MultiValueMap map, DataFetcher dataFetcher, List nullnessErrors) {
            List<String> arguments = nullnessErrors.stream().map(nullnessError -> String.format("%s should be %s", nullnessError.annotatedElement(), nullnessError.schemaNullness())).toList();
            map.put((Object)dataFetcher.toString(), arguments);
        }

        private static /* synthetic */ void lambda$formatFieldNullnessErrors$0(MultiValueMap map, FieldCoordinates coordinates, SchemaReport.NullnessError nullnessError) {
            List fields = (List)map.computeIfAbsent((Object)coordinates.getTypeName(), s -> new ArrayList());
            fields.add(String.format("%s is %s -> '%s' is %s", coordinates.getFieldName(), nullnessError.schemaNullness(), nullnessError.annotatedElement(), nullnessError.applicationNullness()));
        }

        private static /* synthetic */ void lambda$formatUnmappedFields$0(MultiValueMap map, FieldCoordinates coordinates) {
            List fields = (List)map.computeIfAbsent((Object)coordinates.getTypeName(), s -> new ArrayList());
            fields.add(coordinates.getFieldName());
        }
    }

    private static final class ReflectionClassResolver
    implements ClassResolver {
        private static final Predicate<String> PACKAGE_PREDICATE = name -> !name.startsWith("java.");
        private final Function<GraphQLObjectType, String> classNameFunction;
        private final MultiValueMap<String, String> classPrefixes;

        private ReflectionClassResolver(Function<GraphQLObjectType, String> nameFunction, MultiValueMap<String, String> prefixes) {
            this.classNameFunction = nameFunction;
            this.classPrefixes = prefixes;
        }

        @Override
        public List<Class<?>> resolveClass(GraphQLObjectType objectType, GraphQLNamedOutputType interfaceOrUnion) {
            String className = this.classNameFunction.apply(objectType);
            for (String prefix : (List)this.classPrefixes.getOrDefault((Object)interfaceOrUnion.getName(), Collections.emptyList())) {
                try {
                    Class<?> clazz = Class.forName(prefix + className);
                    return Collections.singletonList(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            return Collections.emptyList();
        }

        public static ReflectionClassResolver create(GraphQLSchema schema, Map<String, Map<String, DataFetcher>> dataFetchers, Function<GraphQLObjectType, String> classNameFunction) {
            LinkedMultiValueMap classPrefixes = new LinkedMultiValueMap();
            for (Map.Entry<String, Map<String, DataFetcher>> typeEntry : dataFetchers.entrySet()) {
                String typeName = typeEntry.getKey();
                GraphQLType parentType = schema.getType(typeName);
                if (parentType == null) continue;
                for (Map.Entry<String, DataFetcher> fieldEntry : typeEntry.getValue().entrySet()) {
                    SelfDescribingDataFetcher selfDescribing;
                    Object object;
                    DataFetcher dataFetcher;
                    TypePair pair;
                    GraphQLType outputType;
                    FieldCoordinates coordinates = FieldCoordinates.coordinates((String)typeName, (String)fieldEntry.getKey());
                    GraphQLFieldDefinition field = schema.getFieldDefinition(coordinates);
                    if (field == null || !((outputType = (pair = TypePair.resolveTypePair(parentType, field, dataFetcher = fieldEntry.getValue(), schema)).outputType()) instanceof GraphQLUnionType) && !(outputType instanceof GraphQLInterfaceType)) continue;
                    String outputTypeName = ((GraphQLNamedOutputType)outputType).getName();
                    Class clazz = pair.resolvableType().resolve(Object.class);
                    if (PACKAGE_PREDICATE.test(clazz.getPackageName())) {
                        ReflectionClassResolver.addClassPrefix(outputTypeName, clazz, (MultiValueMap<String, String>)classPrefixes);
                    }
                    if (!(dataFetcher instanceof SelfDescribingDataFetcher) || !((object = (selfDescribing = (SelfDescribingDataFetcher)dataFetcher).getReturnType().getSource()) instanceof MethodParameter)) continue;
                    MethodParameter param = (MethodParameter)object;
                    ReflectionClassResolver.addClassPrefix(outputTypeName, param.getDeclaringClass(), (MultiValueMap<String, String>)classPrefixes);
                }
            }
            return new ReflectionClassResolver(classNameFunction, (MultiValueMap<String, String>)classPrefixes);
        }

        private static void addClassPrefix(String unionOrInterfaceType, Class<?> aClass, MultiValueMap<String, String> classPrefixes) {
            int index = aClass.getName().indexOf(aClass.getSimpleName());
            classPrefixes.add((Object)unionOrInterfaceType, (Object)aClass.getName().substring(0, index));
        }
    }

    private static final class MappingClassResolver
    implements ClassResolver {
        private final MultiValueMap<String, Class<?>> mappings = new LinkedMultiValueMap();

        MappingClassResolver(MultiValueMap<String, Class<?>> mappings) {
            this.mappings.putAll(mappings);
        }

        @Override
        public List<Class<?>> resolveClass(GraphQLObjectType objectType, GraphQLNamedOutputType interfaceOrUnionType) {
            return (List)this.mappings.getOrDefault((Object)objectType.getName(), Collections.emptyList());
        }
    }

    public static interface ClassResolver {
        public List<Class<?>> resolveClass(GraphQLObjectType var1, GraphQLNamedOutputType var2);
    }
}

