/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.TypeResolutionEnvironment;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.TypeResolver;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public class ClassNameTypeResolver
implements TypeResolver {
    private Function<Class<?>, String> classNameExtractor = Class::getSimpleName;
    private final Map<Class<?>, String> mappings = new LinkedHashMap();

    public void setClassNameExtractor(Function<Class<?>, String> classNameExtractor) {
        Assert.notNull(classNameExtractor, (String)"'classNameExtractor' is required");
        this.classNameExtractor = classNameExtractor;
    }

    public void addMapping(Class<?> clazz, String graphQlTypeName) {
        this.mappings.put(clazz, graphQlTypeName);
    }

    public Map<Class<?>, String> getMappings() {
        return this.mappings;
    }

    public @Nullable GraphQLObjectType getType(TypeResolutionEnvironment environment) {
        Class<?> clazz = environment.getObject().getClass();
        GraphQLSchema schema = environment.getSchema();
        return this.getTypeForClass(clazz, schema);
    }

    private @Nullable GraphQLObjectType getTypeForClass(Class<?> clazz, GraphQLSchema schema) {
        if (clazz.getName().startsWith("java.")) {
            return null;
        }
        String name = this.getMapping(clazz);
        if (name != null) {
            GraphQLObjectType objectType = schema.getObjectType(name);
            if (objectType == null) {
                throw new IllegalStateException("Invalid mapping for " + clazz.getName() + ". No GraphQL Object type with name '" + name + "'.");
            }
            return objectType;
        }
        name = this.classNameExtractor.apply(clazz);
        GraphQLType type = schema.getType(name);
        if (type instanceof GraphQLObjectType) {
            GraphQLObjectType objectType = (GraphQLObjectType)type;
            return objectType;
        }
        for (Class<?> interfaceType : clazz.getInterfaces()) {
            GraphQLObjectType objectType = this.getTypeForClass(interfaceType, schema);
            if (objectType == null) continue;
            return objectType;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != Object.class && superclass != null) {
            return this.getTypeForClass(superclass, schema);
        }
        return null;
    }

    private @Nullable String getMapping(Class<?> targetClass) {
        for (Map.Entry<Class<?>, String> entry : this.mappings.entrySet()) {
            if (!entry.getKey().isAssignableFrom(targetClass)) continue;
            return entry.getValue();
        }
        return null;
    }
}

