/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.SelectedField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.springframework.data.core.PropertyPath;
import org.springframework.data.core.TypeInformation;
import org.springframework.util.CollectionUtils;

final class PropertySelection {
    private final List<PropertyPath> propertyPaths;

    private PropertySelection(List<PropertyPath> propertyPaths) {
        this.propertyPaths = propertyPaths;
    }

    List<String> toList() {
        return this.propertyPaths.stream().map(PropertyPath::toDotPath).toList();
    }

    static PropertySelection create(TypeInformation<?> typeInfo, DataFetchingFieldSelectionSet selectionSet) {
        DataFetchingFieldSelection selection = new DataFetchingFieldSelection(selectionSet);
        List<PropertyPath> paths = PropertySelection.getPropertyPaths(typeInfo, selection, path -> PropertyPath.from((String)path, (TypeInformation)typeInfo));
        return new PropertySelection(paths);
    }

    private static List<PropertyPath> getPropertyPaths(TypeInformation<?> typeInfo, FieldSelection selection, Function<String, PropertyPath> pathFactory) {
        ArrayList<PropertyPath> result = new ArrayList<PropertyPath>();
        for (SelectedField selectedField : selection) {
            String propertyName = selectedField.getName();
            TypeInformation propertyTypeInfo = typeInfo.getProperty(propertyName);
            if (propertyTypeInfo == null) {
                if (PropertySelection.isConnectionEdges(selectedField)) {
                    PropertySelection.getConnectionPropertyPaths(typeInfo, selection, pathFactory, selectedField, result);
                    continue;
                }
                if (!PropertySelection.isConnectionEdgeNode(selectedField)) continue;
                PropertySelection.getConnectionPropertyPaths(typeInfo, selection, pathFactory, selectedField, result);
                continue;
            }
            PropertyPath propertyPath = pathFactory.apply(propertyName);
            List<PropertyPath> nestedPaths = null;
            FieldSelection nestedSelection = selection.select(selectedField);
            if (!nestedSelection.isEmpty() && propertyTypeInfo.getActualType() != null) {
                TypeInformation actualType = propertyTypeInfo.getRequiredActualType();
                nestedPaths = PropertySelection.getPropertyPaths(actualType, nestedSelection, arg_0 -> ((PropertyPath)propertyPath).nested(arg_0));
            }
            result.addAll(CollectionUtils.isEmpty(nestedPaths) ? Collections.singletonList(propertyPath) : nestedPaths);
        }
        return result;
    }

    private static boolean isConnectionEdges(SelectedField selectedField) {
        if (selectedField.getName().equals("edges")) {
            GraphQLOutputType fieldType = selectedField.getParentField().getType();
            if (fieldType instanceof GraphQLNonNull) {
                GraphQLNonNull nonNullType = (GraphQLNonNull)fieldType;
                fieldType = nonNullType.getWrappedType();
            }
            if (fieldType instanceof GraphQLNamedOutputType) {
                GraphQLNamedOutputType namedType = (GraphQLNamedOutputType)fieldType;
                return namedType.getName().endsWith("Connection");
            }
        }
        return false;
    }

    private static boolean isConnectionEdgeNode(SelectedField selectedField) {
        return selectedField.getName().equals("node") && PropertySelection.isConnectionEdges(selectedField.getParentField());
    }

    private static void getConnectionPropertyPaths(TypeInformation<?> typeInfo, FieldSelection selection, Function<String, PropertyPath> pathFactory, SelectedField selectedField, List<PropertyPath> result) {
        TypeInformation actualType;
        List<PropertyPath> paths;
        FieldSelection nestedSelection = selection.select(selectedField);
        if (!nestedSelection.isEmpty() && !CollectionUtils.isEmpty(paths = PropertySelection.getPropertyPaths(actualType = typeInfo.getRequiredActualType(), nestedSelection, pathFactory))) {
            result.addAll(paths);
        }
    }

    private static class DataFetchingFieldSelection
    implements FieldSelection {
        private final List<SelectedField> selectedFields;
        private final List<SelectedField> allFields;

        DataFetchingFieldSelection(DataFetchingFieldSelectionSet selectionSet) {
            this.selectedFields = selectionSet.getImmediateFields();
            this.allFields = selectionSet.getFields();
        }

        private DataFetchingFieldSelection(List<SelectedField> selectedFields, List<SelectedField> allFields) {
            this.selectedFields = selectedFields;
            this.allFields = allFields;
        }

        @Override
        public boolean isEmpty() {
            return this.selectedFields.isEmpty();
        }

        @Override
        public FieldSelection select(SelectedField field) {
            ArrayList<SelectedField> selectedFields = null;
            for (SelectedField selectedField : this.allFields) {
                if (!field.equals((Object)selectedField.getParentField())) continue;
                selectedFields = selectedFields != null ? selectedFields : new ArrayList<SelectedField>();
                selectedFields.add(selectedField);
            }
            return selectedFields != null ? new DataFetchingFieldSelection(selectedFields, this.allFields) : EmptyFieldSelection.INSTANCE;
        }

        @Override
        public Iterator<SelectedField> iterator() {
            return this.selectedFields.iterator();
        }
    }

    static interface FieldSelection
    extends Iterable<SelectedField> {
        public boolean isEmpty();

        public FieldSelection select(SelectedField var1);
    }

    static enum EmptyFieldSelection implements FieldSelection
    {
        INSTANCE;


        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public FieldSelection select(SelectedField field) {
            return INSTANCE;
        }

        @Override
        public Iterator<SelectedField> iterator() {
            return Collections.emptyIterator();
        }
    }
}

