/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.pagination;

import graphql.TrivialDataFetcher;
import graphql.execution.DataFetcherResult;
import graphql.language.NonNullType;
import graphql.relay.Connection;
import graphql.relay.ConnectionCursor;
import graphql.relay.DefaultConnection;
import graphql.relay.DefaultConnectionCursor;
import graphql.relay.DefaultEdge;
import graphql.relay.DefaultPageInfo;
import graphql.relay.Edge;
import graphql.relay.PageInfo;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.graphql.data.pagination.ConnectionAdapter;
import org.springframework.graphql.execution.TypeVisitorHelper;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class ConnectionFieldTypeVisitor
extends GraphQLTypeVisitorStub {
    private static final Log logger = LogFactory.getLog(ConnectionFieldTypeVisitor.class);
    private final ConnectionAdapter adapter;

    private ConnectionFieldTypeVisitor(ConnectionAdapter adapter) {
        Assert.notNull((Object)adapter, (String)"ConnectionAdapter is required");
        this.adapter = adapter;
    }

    public TraversalControl visitGraphQLFieldDefinition(GraphQLFieldDefinition fieldDefinition, TraverserContext<GraphQLSchemaElement> context) {
        TypeVisitorHelper visitorHelper = (TypeVisitorHelper)context.getVarFromParents(TypeVisitorHelper.class);
        GraphQLCodeRegistry.Builder codeRegistry = (GraphQLCodeRegistry.Builder)context.getVarFromParents(GraphQLCodeRegistry.Builder.class);
        GraphQLFieldsContainer parent = (GraphQLFieldsContainer)context.getParentNode();
        FieldCoordinates fieldCoordinates = FieldCoordinates.coordinates((GraphQLFieldsContainer)parent, (GraphQLFieldDefinition)fieldDefinition);
        DataFetcher dataFetcher = codeRegistry.getDataFetcher(fieldCoordinates, fieldDefinition);
        if (visitorHelper != null && ConnectionFieldTypeVisitor.isUnderSubscriptionOperation(visitorHelper, context)) {
            return TraversalControl.CONTINUE;
        }
        if (ConnectionFieldTypeVisitor.isConnectionField(fieldDefinition)) {
            if (dataFetcher instanceof TrivialDataFetcher) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Skipping connection field '" + parent.getName() + ":" + fieldDefinition.getName() + "' because it is mapped to trivial data fetcher: " + dataFetcher.getClass().getName()));
                }
            } else {
                dataFetcher = new ConnectionDataFetcher(dataFetcher, this.adapter, fieldDefinition);
                codeRegistry.dataFetcher(fieldCoordinates, dataFetcher);
            }
        }
        return TraversalControl.CONTINUE;
    }

    private static boolean isUnderSubscriptionOperation(TypeVisitorHelper visitorHelper, TraverserContext<GraphQLSchemaElement> context) {
        return context.getBreadcrumbs().stream().filter(GraphQLFieldsContainer.class::isInstance).map(GraphQLFieldsContainer.class::cast).anyMatch(visitorHelper::isSubscriptionType);
    }

    private static boolean isConnectionField(GraphQLFieldDefinition field) {
        GraphQLObjectType type = ConnectionFieldTypeVisitor.getAsObjectType(field);
        if (type == null || !type.getName().endsWith("Connection")) {
            return false;
        }
        GraphQLObjectType edgeType = ConnectionFieldTypeVisitor.getEdgeType(type.getField("edges"));
        if (edgeType == null || !edgeType.getName().endsWith("Edge")) {
            return false;
        }
        if (edgeType.getField("node") == null || edgeType.getField("cursor") == null) {
            return false;
        }
        GraphQLObjectType pageInfoType = ConnectionFieldTypeVisitor.getAsObjectType(type.getField("pageInfo"));
        if (pageInfoType == null || !pageInfoType.getName().equals("PageInfo")) {
            return false;
        }
        return pageInfoType.getField("hasPreviousPage") != null && pageInfoType.getField("hasNextPage") != null && pageInfoType.getField("startCursor") != null && pageInfoType.getField("endCursor") != null;
    }

    private static @Nullable GraphQLObjectType getAsObjectType(@Nullable GraphQLFieldDefinition field) {
        GraphQLObjectType type;
        GraphQLType graphQLType = ConnectionFieldTypeVisitor.getType(field);
        return graphQLType instanceof GraphQLObjectType ? (type = (GraphQLObjectType)graphQLType) : null;
    }

    private static @Nullable GraphQLObjectType getEdgeType(@Nullable GraphQLFieldDefinition field) {
        GraphQLList listType;
        GraphQLType graphQLType;
        GraphQLType graphQLType2 = ConnectionFieldTypeVisitor.getType(field);
        if (graphQLType2 instanceof GraphQLList && (graphQLType = ConnectionFieldTypeVisitor.unwrapNonNullType((listType = (GraphQLList)graphQLType2).getWrappedType())) instanceof GraphQLObjectType) {
            GraphQLObjectType type = (GraphQLObjectType)graphQLType;
            return type;
        }
        return null;
    }

    private static @Nullable GraphQLType getType(@Nullable GraphQLFieldDefinition field) {
        if (field == null) {
            return null;
        }
        return ConnectionFieldTypeVisitor.unwrapNonNullType((GraphQLType)field.getType());
    }

    private static @Nullable GraphQLType unwrapNonNullType(@Nullable GraphQLType type) {
        GraphQLType graphQLType;
        if (type == null) {
            return null;
        }
        if (type instanceof GraphQLNonNull) {
            GraphQLNonNull nonNullType = (GraphQLNonNull)type;
            graphQLType = nonNullType.getWrappedType();
        } else {
            graphQLType = type;
        }
        return graphQLType;
    }

    public static ConnectionFieldTypeVisitor create(List<ConnectionAdapter> adapters) {
        Assert.notEmpty(adapters, (String)"Expected at least one ConnectionAdapter");
        return ConnectionFieldTypeVisitor.create(ConnectionAdapter.from(adapters));
    }

    public static ConnectionFieldTypeVisitor create(ConnectionAdapter adapter) {
        return new ConnectionFieldTypeVisitor(adapter);
    }

    record ConnectionDataFetcher(DataFetcher<?> delegate, ConnectionAdapter adapter, GraphQLFieldDefinition connectionFieldDefinition) implements DataFetcher<Object>
    {
        private static final Connection<?> EMPTY_CONNECTION = new DefaultConnection(Collections.emptyList(), (PageInfo)new DefaultPageInfo(null, null, false, false));

        ConnectionDataFetcher {
            Assert.notNull(delegate, (String)"DataFetcher delegate is required");
            Assert.notNull((Object)adapter, (String)"ConnectionAdapter is required");
            Assert.notNull((Object)connectionFieldDefinition, (String)"GraphQLFieldDefinition is required");
        }

        public Object get(DataFetchingEnvironment environment) throws Exception {
            Object result = this.delegate.get(environment);
            if (result instanceof Mono) {
                Mono mono = (Mono)result;
                return mono.map(this::adaptDataFetcherResult);
            }
            if (result instanceof CompletionStage) {
                CompletionStage stage = (CompletionStage)result;
                return stage.thenApply(this::adaptDataFetcherResult);
            }
            return this.adaptDataFetcherResult(result);
        }

        private Object adaptDataFetcherResult(Object value) {
            if (value instanceof DataFetcherResult) {
                DataFetcherResult dataFetcherResult = (DataFetcherResult)value;
                Object adapted = this.adaptDataContainer(dataFetcherResult.getData());
                return DataFetcherResult.newResult().data(adapted).errors(dataFetcherResult.getErrors()).localContext(dataFetcherResult.getLocalContext()).build();
            }
            return this.adaptDataContainer(value);
        }

        @Contract(value="!null -> !null")
        private <T> @Nullable Object adaptDataContainer(@Nullable Object container) {
            if (container == null) {
                return this.isConnectionTypeNullable() ? null : EMPTY_CONNECTION;
            }
            if (container instanceof Connection) {
                return container;
            }
            if (!this.adapter.supports(container.getClass())) {
                if (container.getClass().getName().endsWith("Connection")) {
                    return container;
                }
                throw new IllegalStateException("No ConnectionAdapter for: " + container.getClass().getName());
            }
            Collection nodes = this.adapter.getContent(container);
            if (nodes.isEmpty()) {
                return EMPTY_CONNECTION;
            }
            int index = 0;
            ArrayList edges = new ArrayList(nodes.size());
            for (Object node : nodes) {
                String cursor = this.adapter.cursorAt(container, index++);
                edges.add(new DefaultEdge(node, (ConnectionCursor)new DefaultConnectionCursor(cursor)));
            }
            DefaultPageInfo pageInfo = new DefaultPageInfo(((Edge)edges.get(0)).getCursor(), ((Edge)edges.get(edges.size() - 1)).getCursor(), this.adapter.hasPrevious(container), this.adapter.hasNext(container));
            return this.adapter.createConnection(container, edges, (PageInfo)pageInfo);
        }

        private boolean isConnectionTypeNullable() {
            if (this.connectionFieldDefinition.getDefinition() != null) {
                return !(this.connectionFieldDefinition.getDefinition().getType() instanceof NonNullType);
            }
            return true;
        }
    }
}

