/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.support;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class DefaultGraphQlRequest
implements GraphQlRequest {
    protected static final String QUERY_KEY = "query";
    protected static final String OPERATION_NAME_KEY = "operationName";
    protected static final String VARIABLES_KEY = "variables";
    protected static final String EXTENSIONS_KEY = "extensions";
    private final String document;
    @Nullable
    private final String operationName;
    private final Map<String, Object> variables;
    private final Map<String, Object> extensions;

    public DefaultGraphQlRequest(String document) {
        this(document, null, null, null);
    }

    public DefaultGraphQlRequest(String document, @Nullable String operationName, @Nullable Map<String, Object> variables, @Nullable Map<String, Object> extensions) {
        Assert.notNull((Object)document, (String)"'document' is required");
        this.document = document;
        this.operationName = operationName;
        this.variables = variables != null ? variables : Collections.emptyMap();
        this.extensions = extensions != null ? extensions : Collections.emptyMap();
    }

    @Override
    public String getDocument() {
        return this.document;
    }

    @Override
    @Nullable
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Override
    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(3);
        map.put(QUERY_KEY, this.getDocument());
        if (this.getOperationName() != null) {
            map.put(OPERATION_NAME_KEY, this.getOperationName());
        }
        if (!CollectionUtils.isEmpty(this.getVariables())) {
            map.put(VARIABLES_KEY, new LinkedHashMap<String, Object>(this.getVariables()));
        }
        if (!CollectionUtils.isEmpty(this.getExtensions())) {
            map.put(EXTENSIONS_KEY, new LinkedHashMap<String, Object>(this.getExtensions()));
        }
        return map;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultGraphQlRequest)) {
            return false;
        }
        DefaultGraphQlRequest other = (DefaultGraphQlRequest)o;
        return this.getDocument().equals(other.getDocument()) && ObjectUtils.nullSafeEquals((Object)this.getOperationName(), (Object)other.getOperationName()) && ObjectUtils.nullSafeEquals(this.getVariables(), other.getVariables()) && ObjectUtils.nullSafeEquals(this.getExtensions(), other.getExtensions());
    }

    public int hashCode() {
        return this.document.hashCode() + 31 * ObjectUtils.nullSafeHashCode((Object)this.operationName) + 31 * this.variables.hashCode() + 31 * this.extensions.hashCode();
    }

    public String toString() {
        return "document='" + this.getDocument() + "'" + (String)(this.getOperationName() != null ? ", operationName='" + this.getOperationName() + "'" : "") + (!CollectionUtils.isEmpty(this.getVariables()) ? ", variables=" + String.valueOf(this.getVariables()) : (String)(!CollectionUtils.isEmpty(this.getExtensions()) ? ", extensions=" + String.valueOf(this.getExtensions()) : ""));
    }
}

