/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webmvc;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.graphql.server.webmvc.AbstractGraphQlHttpHandler;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import reactor.core.publisher.Mono;

public class GraphQlHttpHandler
extends AbstractGraphQlHttpHandler {
    private static final List<MediaType> SUPPORTED_MEDIA_TYPES = List.of(MediaType.APPLICATION_GRAPHQL_RESPONSE, MediaType.APPLICATION_JSON, MediaType.APPLICATION_GRAPHQL);

    public GraphQlHttpHandler(WebGraphQlHandler graphQlHandler) {
        super(graphQlHandler, null);
    }

    public GraphQlHttpHandler(WebGraphQlHandler graphQlHandler, @Nullable HttpMessageConverter<?> converter) {
        super(graphQlHandler, converter);
    }

    @Override
    protected ServerResponse prepareResponse(ServerRequest request, Mono<WebGraphQlResponse> responseMono) {
        CompletableFuture future = responseMono.map(response -> {
            MediaType contentType = GraphQlHttpHandler.selectResponseMediaType(request);
            ServerResponse.BodyBuilder builder = ServerResponse.ok();
            builder.headers(headers -> headers.putAll((Map)response.getResponseHeaders()));
            builder.contentType(contentType);
            Map<String, Object> resultMap = response.toMap();
            ServerResponse.HeadersBuilder.WriteFunction writer = this.getWriteFunction(resultMap, contentType);
            return writer != null ? builder.build(writer) : builder.body(resultMap);
        }).toFuture();
        if (future.isDone() && !future.isCancelled() && !future.isCompletedExceptionally()) {
            try {
                return (ServerResponse)future.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        return ServerResponse.async((Object)future);
    }

    private static MediaType selectResponseMediaType(ServerRequest request) {
        List acceptedMediaTypes;
        ServerRequest.Headers headers = request.headers();
        try {
            acceptedMediaTypes = headers.accept();
        }
        catch (InvalidMediaTypeException ex) {
            throw new NotAcceptableStatusException("Could not parse Accept header [" + headers.firstHeader("Accept") + "]: " + ex.getMessage());
        }
        for (MediaType mediaType : acceptedMediaTypes) {
            if (!SUPPORTED_MEDIA_TYPES.contains(mediaType)) continue;
            return mediaType;
        }
        return MediaType.APPLICATION_JSON;
    }
}

