/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.GraphQLError;
import graphql.execution.DataFetcherResult;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.dataloader.DataLoader;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.expression.BeanResolver;
import org.springframework.graphql.data.ArgumentValue;
import org.springframework.graphql.data.GraphQlArgumentBinder;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolverComposite;
import org.springframework.graphql.data.method.annotation.Argument;
import org.springframework.graphql.data.method.annotation.BatchMapping;
import org.springframework.graphql.data.method.annotation.SchemaMapping;
import org.springframework.graphql.data.method.annotation.support.AnnotatedControllerDetectionSupport;
import org.springframework.graphql.data.method.annotation.support.ArgumentMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ArgumentsMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.AuthenticationPrincipalArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.BatchLoaderHandlerMethod;
import org.springframework.graphql.data.method.annotation.support.ContextValueMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ContinuationHandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.DataFetcherHandlerMethod;
import org.springframework.graphql.data.method.annotation.support.DataFetcherMappingInfo;
import org.springframework.graphql.data.method.annotation.support.DataFetchingEnvironmentMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.DataLoaderMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.HandlerDataFetcherExceptionResolver;
import org.springframework.graphql.data.method.annotation.support.LocalContextValueMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.PrincipalMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ProjectedPayloadMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ScrollSubrangeMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.SortMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.SourceMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.SubrangeMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ValidationHelper;
import org.springframework.graphql.data.pagination.CursorStrategy;
import org.springframework.graphql.data.query.SortStrategy;
import org.springframework.graphql.execution.BatchLoaderRegistry;
import org.springframework.graphql.execution.ReactiveAdapterRegistryHelper;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.graphql.execution.SelfDescribingDataFetcher;
import org.springframework.graphql.execution.SubscriptionPublisherException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AnnotatedControllerConfigurer
extends AnnotatedControllerDetectionSupport<DataFetcherMappingInfo>
implements RuntimeWiringConfigurer {
    private static final ClassLoader classLoader = AnnotatedControllerConfigurer.class.getClassLoader();
    private static final boolean springDataPresent = ClassUtils.isPresent((String)"org.springframework.data.projection.SpelAwareProxyProjectionFactory", (ClassLoader)classLoader);
    private static final boolean springSecurityPresent = ClassUtils.isPresent((String)"org.springframework.security.core.context.SecurityContext", (ClassLoader)classLoader);
    private static final boolean beanValidationPresent = ClassUtils.isPresent((String)"jakarta.validation.executable.ExecutableValidator", (ClassLoader)classLoader);
    private final List<HandlerMethodArgumentResolver> customArgumentResolvers = new ArrayList<HandlerMethodArgumentResolver>(8);
    private final InterfaceMappingHelper interfaceMappingHelper = new InterfaceMappingHelper();
    @Nullable
    private ValidationHelper validationHelper;

    public void addCustomArgumentResolver(HandlerMethodArgumentResolver resolver) {
        this.customArgumentResolvers.add(resolver);
    }

    @Override
    public void setTypeDefinitionRegistry(TypeDefinitionRegistry registry) {
        this.interfaceMappingHelper.setTypeDefinitionRegistry(registry);
    }

    @Deprecated(since="1.1.0", forRemoval=true)
    public void setDataBinderInitializer(@Nullable Consumer<DataBinder> consumer) {
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (beanValidationPresent) {
            this.validationHelper = ValidationHelper.createIfValidatorPresent(this.obtainApplicationContext());
        }
    }

    @Override
    protected HandlerMethodArgumentResolverComposite initArgumentResolvers() {
        HandlerMethodArgumentResolverComposite resolvers = new HandlerMethodArgumentResolverComposite();
        if (springDataPresent) {
            resolvers.addResolver(new ProjectedPayloadMethodArgumentResolver(this.obtainApplicationContext()));
        }
        GraphQlArgumentBinder argumentBinder = new GraphQlArgumentBinder((ConversionService)this.getConversionService(), this.isFallBackOnDirectFieldAccess());
        resolvers.addResolver(new ArgumentMethodArgumentResolver(argumentBinder));
        resolvers.addResolver(new ArgumentsMethodArgumentResolver(argumentBinder));
        resolvers.addResolver(new ContextValueMethodArgumentResolver());
        resolvers.addResolver(new LocalContextValueMethodArgumentResolver());
        if (springSecurityPresent) {
            ApplicationContext context = this.obtainApplicationContext();
            resolvers.addResolver(new AuthenticationPrincipalArgumentResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)context)));
        }
        resolvers.addResolver(new DataFetchingEnvironmentMethodArgumentResolver());
        resolvers.addResolver(new DataLoaderMethodArgumentResolver());
        this.addSubrangeMethodArgumentResolver(resolvers);
        this.addSortMethodArgumentResolver(resolvers);
        if (springSecurityPresent) {
            resolvers.addResolver(new PrincipalMethodArgumentResolver());
        }
        if (KotlinDetector.isKotlinPresent()) {
            resolvers.addResolver(new ContinuationHandlerMethodArgumentResolver());
        }
        this.customArgumentResolvers.forEach(resolvers::addResolver);
        resolvers.addResolver(new SourceMethodArgumentResolver());
        return resolvers;
    }

    private void addSubrangeMethodArgumentResolver(HandlerMethodArgumentResolverComposite resolvers) {
        try {
            CursorStrategy strategy = (CursorStrategy)this.obtainApplicationContext().getBean(CursorStrategy.class);
            if (springDataPresent && strategy.supports(ScrollPosition.class)) {
                CursorStrategy strategyToUse = strategy;
                resolvers.addResolver(new ScrollSubrangeMethodArgumentResolver(strategyToUse));
                return;
            }
            resolvers.addResolver(new SubrangeMethodArgumentResolver(strategy));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    private void addSortMethodArgumentResolver(HandlerMethodArgumentResolverComposite resolvers) {
        if (springDataPresent) {
            try {
                SortStrategy strategy = (SortStrategy)this.obtainApplicationContext().getBean(SortStrategy.class);
                resolvers.addResolver(new SortMethodArgumentResolver(strategy));
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
    }

    @Override
    public void configure(RuntimeWiring.Builder runtimeWiringBuilder) {
        Set<DataFetcherMappingInfo> allInfos = this.detectHandlerMethods();
        Set<DataFetcherMappingInfo> subTypeInfos = this.interfaceMappingHelper.removeInterfaceMappings(allInfos);
        allInfos.forEach(info -> this.registerDataFetcher((DataFetcherMappingInfo)info, runtimeWiringBuilder));
        RuntimeWiring wiring = runtimeWiringBuilder.build();
        subTypeInfos = this.interfaceMappingHelper.removeExplicitMappings(subTypeInfos, wiring.getDataFetchers());
        subTypeInfos.forEach(info -> this.registerDataFetcher((DataFetcherMappingInfo)info, runtimeWiringBuilder));
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Controller method registrations:" + AnnotatedControllerConfigurer.formatRegistrations(runtimeWiringBuilder)));
        }
    }

    @Override
    protected DataFetcherMappingInfo getMappingInfo(Method method, Object handler, Class<?> handlerType) {
        String field;
        String typeName;
        SchemaMapping mapping;
        Set annotations = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, new LinkedHashSet<Class>(Arrays.asList(BatchMapping.class, SchemaMapping.class)));
        if (annotations.isEmpty()) {
            return null;
        }
        if (annotations.size() != 1) {
            throw new IllegalArgumentException("Expected either @BatchMapping or @SchemaMapping, not both: " + method.toGenericString());
        }
        boolean batchMapping = false;
        int batchSize = -1;
        HandlerMethod handlerMethod = this.createHandlerMethod(method, handler, handlerType);
        Annotation annotation = (Annotation)annotations.iterator().next();
        if (annotation instanceof SchemaMapping) {
            mapping = (SchemaMapping)annotation;
            typeName = mapping.typeName();
            field = StringUtils.hasText((String)mapping.field()) ? mapping.field() : method.getName();
        } else {
            BatchMapping mapping2 = (BatchMapping)annotation;
            typeName = mapping2.typeName();
            field = StringUtils.hasText((String)mapping2.field()) ? mapping2.field() : method.getName();
            batchMapping = true;
            batchSize = mapping2.maxBatchSize();
        }
        if (!StringUtils.hasText((String)typeName) && (mapping = (SchemaMapping)AnnotatedElementUtils.findMergedAnnotation(handlerType, SchemaMapping.class)) != null) {
            typeName = mapping.typeName();
        }
        if (!StringUtils.hasText((String)typeName)) {
            for (MethodParameter parameter : handlerMethod.getMethodParameters()) {
                if (!batchMapping) {
                    HandlerMethodArgumentResolver resolver = this.getArgumentResolvers().getArgumentResolver(parameter);
                    if (!(resolver instanceof SourceMethodArgumentResolver)) continue;
                    typeName = parameter.getParameterType().getSimpleName();
                    break;
                }
                if (!Collection.class.isAssignableFrom(parameter.getParameterType())) continue;
                Class type = parameter.nested().getNestedParameterType();
                if (Object.class.equals((Object)type)) {
                    type = ResolvableType.forMethodParameter((MethodParameter)parameter).getNested(2).resolve(Object.class);
                }
                if (Object.class.equals((Object)type)) break;
                typeName = type.getSimpleName();
                break;
            }
        }
        Assert.hasText((String)typeName, (String)("No parentType specified, and a source/parent method argument was also not found: " + handlerMethod.getShortLogMessage()));
        return new DataFetcherMappingInfo(typeName, field, batchMapping, batchSize, handlerMethod);
    }

    @Override
    protected HandlerMethod getHandlerMethod(DataFetcherMappingInfo mappingInfo) {
        return mappingInfo.getHandlerMethod();
    }

    private void registerDataFetcher(DataFetcherMappingInfo info, RuntimeWiring.Builder runtimeWiringBuilder) {
        SchemaMappingDataFetcher dataFetcher = !info.isBatchMapping() ? new SchemaMappingDataFetcher(info, this.getArgumentResolvers(), this.validationHelper, this.getExceptionResolver(), this.getExecutor(), this.shouldInvokeAsync(info.getHandlerMethod())) : this.registerBatchLoader(info);
        FieldCoordinates coordinates = info.getCoordinates();
        runtimeWiringBuilder.type(coordinates.getTypeName(), typeBuilder -> typeBuilder.dataFetcher(coordinates.getFieldName(), dataFetcher));
    }

    private DataFetcher<Object> registerBatchLoader(DataFetcherMappingInfo info) {
        ReactiveAdapter adapter;
        Class clazz;
        MethodParameter returnType;
        BatchLoaderHandlerMethod invocable;
        HandlerMethod handlerMethod;
        BatchLoaderRegistry.RegistrationSpec registration;
        String dataLoaderKey;
        block9: {
            block8: {
                if (!info.isBatchMapping()) {
                    throw new IllegalArgumentException("Not a @BatchMapping method: " + String.valueOf(info));
                }
                dataLoaderKey = info.getCoordinates().toString();
                BatchLoaderRegistry registry = (BatchLoaderRegistry)this.obtainApplicationContext().getBean(BatchLoaderRegistry.class);
                registration = registry.forName(dataLoaderKey);
                if (info.getMaxBatchSize() > 0) {
                    registration.withOptions(options -> options.setMaxBatchSize(info.getMaxBatchSize()));
                }
                handlerMethod = info.getHandlerMethod();
                invocable = new BatchLoaderHandlerMethod(handlerMethod, this.getExecutor(), this.shouldInvokeAsync(handlerMethod));
                returnType = handlerMethod.getReturnType();
                clazz = returnType.getParameterType();
                Method method = handlerMethod.getMethod();
                if (clazz.equals(Callable.class)) {
                    returnType = returnType.nested();
                    clazz = returnType.getNestedParameterType();
                }
                adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(clazz);
                if (Collection.class.isAssignableFrom(clazz)) break block8;
                if (adapter == null || !adapter.isMultiValue()) break block9;
            }
            registration.registerBatchLoader(invocable::invokeForIterable);
            ResolvableType valueType = ResolvableType.forMethodParameter((MethodParameter)returnType.nested());
            return new BatchMappingDataFetcher(info, valueType, dataLoaderKey);
        }
        if (adapter != null) {
            returnType = returnType.nested();
            clazz = returnType.getNestedParameterType();
        }
        if (Map.class.isAssignableFrom(clazz)) {
            registration.registerMappedBatchLoader(invocable::invokeForMap);
            ResolvableType valueType = ResolvableType.forMethodParameter((MethodParameter)returnType.nested(Integer.valueOf(1)));
            return new BatchMappingDataFetcher(info, valueType, dataLoaderKey);
        }
        throw new IllegalStateException("@BatchMapping method is expected to return Mono<Map<K, V>>, Map<K, V>, Flux<V>, or Collection<V>: " + String.valueOf(handlerMethod));
    }

    protected static String formatRegistrations(RuntimeWiring.Builder wiringBuilder) {
        return wiringBuilder.build().getDataFetchers().entrySet().stream().map(typeEntry -> (String)typeEntry.getKey() + ":\n" + ((Map)typeEntry.getValue()).entrySet().stream().map(fieldEntry -> (String)fieldEntry.getKey() + " -> " + String.valueOf(fieldEntry.getValue())).collect(Collectors.joining("\n\t", "\t", ""))).collect(Collectors.joining("\n", "\n", "\n"));
    }

    public void configure(GraphQLCodeRegistry.Builder codeRegistryBuilder) {
        RuntimeWiring.Builder wiringBuilder = RuntimeWiring.newRuntimeWiring();
        this.configure(wiringBuilder);
        RuntimeWiring runtimeWiring = wiringBuilder.build();
        runtimeWiring.getDataFetchers().forEach((typeName, dataFetcherMap) -> dataFetcherMap.forEach((key, value) -> {
            FieldCoordinates coordinates = FieldCoordinates.coordinates((String)typeName, (String)key);
            codeRegistryBuilder.dataFetcher(coordinates, value);
        }));
    }

    private static final class InterfaceMappingHelper {
        private final MultiValueMap<String, String> interfaceMappings = new LinkedMultiValueMap();

        private InterfaceMappingHelper() {
        }

        void setTypeDefinitionRegistry(TypeDefinitionRegistry registry) {
            for (TypeDefinition definition : registry.types().values()) {
                if (!(definition instanceof ObjectTypeDefinition)) continue;
                ObjectTypeDefinition objectDefinition = (ObjectTypeDefinition)definition;
                for (Type type : objectDefinition.getImplements()) {
                    this.interfaceMappings.add((Object)((TypeName)type).getName(), (Object)objectDefinition.getName());
                }
            }
        }

        Set<DataFetcherMappingInfo> removeInterfaceMappings(Set<DataFetcherMappingInfo> infos) {
            LinkedHashSet<DataFetcherMappingInfo> subTypeMappings = new LinkedHashSet<DataFetcherMappingInfo>();
            Iterator<DataFetcherMappingInfo> it = infos.iterator();
            while (it.hasNext()) {
                DataFetcherMappingInfo info = it.next();
                List names = (List)this.interfaceMappings.get((Object)info.getTypeName());
                if (names == null) continue;
                for (String name : names) {
                    subTypeMappings.add(new DataFetcherMappingInfo(name, info));
                }
                it.remove();
            }
            return subTypeMappings;
        }

        Set<DataFetcherMappingInfo> removeExplicitMappings(Set<DataFetcherMappingInfo> infos, Map<String, Map<String, DataFetcher>> dataFetchers) {
            return infos.stream().filter(info -> {
                Map registrations = (Map)dataFetchers.get(info.getTypeName());
                return registrations == null || !registrations.containsKey(info.getFieldName());
            }).collect(Collectors.toSet());
        }
    }

    static class SchemaMappingDataFetcher
    implements SelfDescribingDataFetcher<Object> {
        private static final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
        private final DataFetcherMappingInfo mappingInfo;
        private final HandlerMethodArgumentResolverComposite argumentResolvers;
        @Nullable
        private final BiConsumer<Object, Object[]> methodValidationHelper;
        private final HandlerDataFetcherExceptionResolver exceptionResolver;
        @Nullable
        private final Executor executor;
        private final boolean invokeAsync;
        private final boolean subscription;

        SchemaMappingDataFetcher(DataFetcherMappingInfo info, HandlerMethodArgumentResolverComposite argumentResolvers, @Nullable ValidationHelper helper, HandlerDataFetcherExceptionResolver exceptionResolver, @Nullable Executor executor, boolean invokeAsync) {
            this.mappingInfo = info;
            this.argumentResolvers = argumentResolvers;
            this.methodValidationHelper = helper != null ? helper.getValidationHelperFor(info.getHandlerMethod()) : null;
            this.exceptionResolver = exceptionResolver;
            this.executor = executor;
            this.invokeAsync = invokeAsync;
            this.subscription = this.mappingInfo.getCoordinates().getTypeName().equalsIgnoreCase("Subscription");
        }

        @Override
        public String getDescription() {
            return this.mappingInfo.getHandlerMethod().getShortLogMessage();
        }

        @Override
        public ResolvableType getReturnType() {
            return ResolvableType.forMethodReturnType((Method)this.mappingInfo.getHandlerMethod().getMethod());
        }

        @Override
        public Map<String, ResolvableType> getArguments() {
            Predicate<MethodParameter> argumentPredicate = p -> p.getParameterAnnotation(Argument.class) != null || p.getParameterType() == ArgumentValue.class;
            return Arrays.stream(this.mappingInfo.getHandlerMethod().getMethodParameters()).filter(argumentPredicate).peek(p -> p.initParameterNameDiscovery(parameterNameDiscoverer)).collect(Collectors.toMap(ArgumentMethodArgumentResolver::getArgumentName, ResolvableType::forMethodParameter));
        }

        HandlerMethod getHandlerMethod() {
            return this.mappingInfo.getHandlerMethod();
        }

        public Object get(DataFetchingEnvironment environment) throws Exception {
            DataFetcherHandlerMethod handlerMethod = new DataFetcherHandlerMethod(this.getHandlerMethod(), this.argumentResolvers, this.methodValidationHelper, this.executor, this.invokeAsync, this.subscription);
            try {
                Object result = handlerMethod.invoke(environment);
                return this.applyExceptionHandling(environment, handlerMethod, result);
            }
            catch (Throwable ex) {
                return this.handleException(ex, environment, handlerMethod);
            }
        }

        @Nullable
        private <T> Object applyExceptionHandling(DataFetchingEnvironment env, DataFetcherHandlerMethod handlerMethod, Object result) {
            if (this.subscription) {
                return ReactiveAdapterRegistryHelper.toSubscriptionFlux(result).onErrorResume(ex -> this.handleSubscriptionError((Throwable)ex, env, handlerMethod));
            }
            if ((result = ReactiveAdapterRegistryHelper.toMonoOrFluxIfReactive(result)) instanceof Mono) {
                result = ((Mono)result).onErrorResume(ex -> this.handleException((Throwable)ex, env, handlerMethod));
            } else if (result instanceof Flux) {
                result = ((Flux)result).onErrorResume(ex -> this.handleException((Throwable)ex, env, handlerMethod));
            }
            return result;
        }

        private Mono<DataFetcherResult<Object>> handleException(Throwable ex, DataFetchingEnvironment env, DataFetcherHandlerMethod handlerMethod) {
            return this.exceptionResolver.resolveException(ex, env, handlerMethod.getBean()).map(errors -> DataFetcherResult.newResult().errors(errors).build()).switchIfEmpty(Mono.error((Throwable)ex));
        }

        private <T> Publisher<T> handleSubscriptionError(Throwable ex, DataFetchingEnvironment env, DataFetcherHandlerMethod handlerMethod) {
            return this.exceptionResolver.resolveException(ex, env, handlerMethod.getBean()).flatMap(errors -> Mono.error((Throwable)((Object)new SubscriptionPublisherException((List<GraphQLError>)errors, ex)))).switchIfEmpty(Mono.error((Throwable)ex));
        }

        public String toString() {
            return this.getDescription();
        }
    }

    static class BatchMappingDataFetcher
    implements DataFetcher<Object>,
    SelfDescribingDataFetcher<Object> {
        private final DataFetcherMappingInfo mappingInfo;
        private final ResolvableType returnType;
        private final String dataLoaderKey;

        BatchMappingDataFetcher(DataFetcherMappingInfo info, ResolvableType valueType, String dataLoaderKey) {
            this.mappingInfo = info;
            this.returnType = ResolvableType.forClassWithGenerics(CompletableFuture.class, (ResolvableType[])new ResolvableType[]{valueType});
            this.dataLoaderKey = dataLoaderKey;
        }

        @Override
        public String getDescription() {
            return "@BatchMapping " + this.mappingInfo.getHandlerMethod().getShortLogMessage();
        }

        @Override
        public ResolvableType getReturnType() {
            return this.returnType;
        }

        public Object get(DataFetchingEnvironment env) {
            DataLoader dataLoader = env.getDataLoaderRegistry().getDataLoader(this.dataLoaderKey);
            Assert.state((dataLoader != null ? 1 : 0) != 0, (String)("No DataLoader for key '" + this.dataLoaderKey + "'"));
            return env.getLocalContext() != null ? dataLoader.load(env.getSource(), env.getLocalContext()) : dataLoader.load(env.getSource());
        }

        public String toString() {
            return this.getDescription();
        }
    }
}

