/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.ExecutionId;
import graphql.schema.DataFetchingEnvironment;
import io.micrometer.context.ContextSnapshot;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.graphql.execution.ContextSnapshotFactoryHelper;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.graphql.execution.ErrorType;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ExceptionResolversExceptionHandler
implements DataFetcherExceptionHandler {
    private static final Log logger = LogFactory.getLog(ExceptionResolversExceptionHandler.class);
    private final List<DataFetcherExceptionResolver> resolvers;

    ExceptionResolversExceptionHandler(List<DataFetcherExceptionResolver> resolvers) {
        Assert.notNull(resolvers, (String)"'resolvers' is required");
        this.resolvers = new ArrayList<DataFetcherExceptionResolver>(resolvers);
    }

    public CompletableFuture<DataFetcherExceptionHandlerResult> handleException(DataFetcherExceptionHandlerParameters handlerParameters) {
        Throwable exception = this.unwrapException(handlerParameters);
        DataFetchingEnvironment env = handlerParameters.getDataFetchingEnvironment();
        ContextSnapshot snapshot = ContextSnapshotFactoryHelper.captureFrom(env.getGraphQlContext());
        try {
            return Flux.fromIterable(this.resolvers).flatMap(resolver -> resolver.resolveException(exception, env)).map(errors -> DataFetcherExceptionHandlerResult.newResult().errors(errors).build()).next().doOnNext(result -> this.logResolvedException(exception, (DataFetcherExceptionHandlerResult)result)).onErrorResume(resolverEx -> Mono.just((Object)this.handleResolverError((Throwable)resolverEx, exception, env))).switchIfEmpty(Mono.fromCallable(() -> this.createInternalError(exception, env))).contextWrite(arg_0 -> ((ContextSnapshot)snapshot).updateContext(arg_0)).toFuture();
        }
        catch (Exception resolverEx2) {
            return CompletableFuture.completedFuture(this.handleResolverError(resolverEx2, exception, env));
        }
    }

    private Throwable unwrapException(DataFetcherExceptionHandlerParameters params) {
        Throwable ex = params.getException();
        return ex instanceof CompletionException ? ex.getCause() : ex;
    }

    private void logResolvedException(Throwable ex, DataFetcherExceptionHandlerResult result) {
        if (logger.isDebugEnabled()) {
            String name = ex.getClass().getSimpleName();
            logger.debug((Object)("Resolved " + name + " to GraphQL error(s): " + String.valueOf(result.getErrors())), ex);
        }
    }

    private DataFetcherExceptionHandlerResult handleResolverError(Throwable resolverException, Throwable originalException, DataFetchingEnvironment env) {
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Failure while resolving " + originalException.getMessage()), resolverException);
        }
        return this.createInternalError(originalException, env);
    }

    private DataFetcherExceptionHandlerResult createInternalError(Throwable ex, DataFetchingEnvironment env) {
        ExecutionId executionId = env.getExecutionId();
        if (logger.isErrorEnabled()) {
            logger.error((Object)("Unresolved " + ex.getClass().getSimpleName() + " for executionId " + String.valueOf(executionId)), ex);
        }
        return DataFetcherExceptionHandlerResult.newResult((GraphQLError)GraphqlErrorBuilder.newError((DataFetchingEnvironment)env).errorType((ErrorClassification)ErrorType.INTERNAL_ERROR).message(String.valueOf((Object)ErrorType.INTERNAL_ERROR) + " for " + String.valueOf(executionId), new Object[0]).build()).build();
    }
}

