/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.dataloader.DataLoader;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DataLoaderMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().equals(DataLoader.class);
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) {
        DataLoader dataLoader = null;
        Class<?> valueType = this.getValueType(parameter);
        if (valueType != null) {
            dataLoader = environment.getDataLoader(valueType.getName());
        }
        String parameterName = null;
        if (dataLoader == null && (parameterName = parameter.getParameterName()) != null) {
            dataLoader = environment.getDataLoader(parameterName);
        }
        if (dataLoader == null) {
            String message = this.getErrorMessage(parameter, environment, valueType, parameterName);
            throw new IllegalArgumentException(message);
        }
        return dataLoader;
    }

    @Nullable
    private Class<?> getValueType(MethodParameter param) {
        ParameterizedType parameterizedType;
        Assert.isAssignable(DataLoader.class, (Class)param.getParameterType());
        Type genericType = param.getGenericParameterType();
        if (genericType instanceof ParameterizedType && (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments().length == 2) {
            Type valueType = parameterizedType.getActualTypeArguments()[1];
            return valueType instanceof Class ? (Class)valueType : ResolvableType.forType((Type)valueType).resolve();
        }
        return null;
    }

    private String getErrorMessage(MethodParameter parameter, DataFetchingEnvironment environment, @Nullable Class<?> valueType, @Nullable String parameterName) {
        String message = "Cannot resolve DataLoader for parameter" + (parameterName != null ? " '" + parameterName + "'" : "[" + parameter.getParameterIndex() + "]") + " in method " + parameter.getMethod().toGenericString() + ". ";
        message = valueType == null ? message + "If the batch loader was registered without a name, then declaring the DataLoader argument with generic types should help to look up the DataLoader based on the value type name." : (parameterName == null ? message + "If the batch loader was registered with a name, then compiling with \"-parameters\" should help to look up the DataLoader based on the parameter name." : message + "Neither the name of the declared value type '" + String.valueOf(valueType) + "' nor the method parameter name '" + parameterName + "' match to any DataLoader. The DataLoaderRegistry contains: " + String.valueOf(environment.getDataLoaderRegistry().getKeys()));
        return message;
    }
}

