/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQLError;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collections;
import java.util.List;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.graphql.execution.SecurityExceptionResolverUtils;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import reactor.core.publisher.Mono;

public class ReactiveSecurityDataFetcherExceptionResolver
implements DataFetcherExceptionResolver {
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();

    public void setAuthenticationTrustResolver(AuthenticationTrustResolver trustResolver) {
        this.trustResolver = trustResolver;
    }

    @Override
    public Mono<List<GraphQLError>> resolveException(Throwable ex, DataFetchingEnvironment environment) {
        if (ex instanceof AuthenticationException) {
            GraphQLError error = SecurityExceptionResolverUtils.resolveUnauthorized(environment);
            return Mono.just(Collections.singletonList(error));
        }
        if (ex instanceof AccessDeniedException) {
            return ReactiveSecurityContextHolder.getContext().map(context -> Collections.singletonList(SecurityExceptionResolverUtils.resolveAccessDenied(environment, this.trustResolver, context))).switchIfEmpty(Mono.fromCallable(() -> Collections.singletonList(SecurityExceptionResolverUtils.resolveUnauthorized(environment))));
        }
        return Mono.empty();
    }
}

