/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.aop.SpringProxy;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.projection.TargetAware;
import org.springframework.graphql.data.ArgumentValue;
import org.springframework.graphql.data.federation.EntityMapping;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolverComposite;
import org.springframework.graphql.data.method.annotation.BatchMapping;
import org.springframework.graphql.data.method.annotation.GraphQlExceptionHandler;
import org.springframework.graphql.data.method.annotation.SchemaMapping;
import org.springframework.graphql.data.method.annotation.support.AnnotatedControllerConfigurer;
import org.springframework.graphql.data.method.annotation.support.ArgumentMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ArgumentsMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.DataLoaderMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ProjectedPayloadMethodArgumentResolver;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;

class SchemaMappingBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    private static final boolean springDataPresent = ClassUtils.isPresent((String)"org.springframework.data.projection.SpelAwareProxyProjectionFactory", (ClassLoader)SchemaMappingBeanFactoryInitializationAotProcessor.class.getClassLoader());

    SchemaMappingBeanFactoryInitializationAotProcessor() {
    }

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        ArrayList controllers = new ArrayList();
        ArrayList controllerAdvices = new ArrayList();
        Arrays.stream(beanFactory.getBeanDefinitionNames()).map(beanName -> RegisteredBean.of((ConfigurableListableBeanFactory)beanFactory, (String)beanName).getBeanClass()).forEach(beanClass -> {
            if (this.isController((AnnotatedElement)beanClass)) {
                controllers.add((Class<?>)beanClass);
            } else if (this.isControllerAdvice((AnnotatedElement)beanClass)) {
                controllerAdvices.add((Class<?>)beanClass);
            }
        });
        return new SchemaMappingBeanFactoryInitializationAotContribution(controllers, controllerAdvices);
    }

    private boolean isController(AnnotatedElement element) {
        return MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).isPresent(Controller.class);
    }

    private boolean isControllerAdvice(AnnotatedElement element) {
        return MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).isPresent(ControllerAdvice.class);
    }

    private static class SchemaMappingBeanFactoryInitializationAotContribution
    implements BeanFactoryInitializationAotContribution {
        private final List<Class<?>> controllers;
        private final List<Class<?>> controllerAdvices;
        private final HandlerMethodArgumentResolverComposite argumentResolvers;

        SchemaMappingBeanFactoryInitializationAotContribution(List<Class<?>> controllers, List<Class<?>> controllerAdvices) {
            this.controllers = controllers;
            this.controllerAdvices = controllerAdvices;
            this.argumentResolvers = this.createArgumentResolvers();
        }

        private HandlerMethodArgumentResolverComposite createArgumentResolvers() {
            AnnotatedControllerConfigurer configurer = new AnnotatedControllerConfigurer();
            configurer.setApplicationContext((ApplicationContext)new StaticApplicationContext());
            configurer.afterPropertiesSet();
            return configurer.getArgumentResolvers();
        }

        public void applyTo(GenerationContext context, BeanFactoryInitializationCode initializationCode) {
            RuntimeHints runtimeHints = context.getRuntimeHints();
            this.registerSpringDataSpelSupport(runtimeHints);
            this.controllers.forEach(controller -> {
                runtimeHints.reflection().registerType(controller, new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_METHODS});
                ReflectionUtils.doWithMethods((Class)controller, method -> this.processSchemaMappingMethod(runtimeHints, method), this::isGraphQlHandlerMethod);
                ReflectionUtils.doWithMethods((Class)controller, method -> this.processExceptionHandlerMethod(runtimeHints, method), this::isExceptionHandlerMethod);
            });
            this.controllerAdvices.forEach(controllerAdvice -> {
                runtimeHints.reflection().registerType(controllerAdvice, new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_METHODS});
                ReflectionUtils.doWithMethods((Class)controllerAdvice, method -> this.processExceptionHandlerMethod(runtimeHints, method), this::isExceptionHandlerMethod);
            });
        }

        private void registerSpringDataSpelSupport(RuntimeHints runtimeHints) {
            if (springDataPresent) {
                runtimeHints.reflection().registerType(SpelAwareProxyProjectionFactory.class, new MemberCategory[0]).registerType(TypeReference.of((String)"org.springframework.data.projection.SpelEvaluatingMethodInterceptor$TargetWrapper"), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS}));
            }
        }

        private boolean isGraphQlHandlerMethod(AnnotatedElement element) {
            MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
            return annotations.isPresent(SchemaMapping.class) || annotations.isPresent(BatchMapping.class) || annotations.isPresent(EntityMapping.class);
        }

        private boolean isExceptionHandlerMethod(AnnotatedElement element) {
            return MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).isPresent(GraphQlExceptionHandler.class);
        }

        private void processSchemaMappingMethod(RuntimeHints runtimeHints, Method method) {
            runtimeHints.reflection().registerMethod(method, ExecutableMode.INVOKE);
            for (Parameter parameter : method.getParameters()) {
                this.processMethodParameter(runtimeHints, MethodParameter.forParameter((Parameter)parameter));
            }
            this.processReturnType(runtimeHints, MethodParameter.forExecutable((Executable)method, (int)-1));
        }

        private void processExceptionHandlerMethod(RuntimeHints runtimeHints, Method method) {
            runtimeHints.reflection().registerMethod(method, ExecutableMode.INVOKE);
        }

        private void processMethodParameter(RuntimeHints hints, MethodParameter parameter) {
            MethodParameterRuntimeHintsRegistrar.fromMethodParameter(this.argumentResolvers, parameter).apply(hints);
        }

        private void processReturnType(RuntimeHints hints, MethodParameter parameter) {
            new ArgumentBindingHints(parameter).apply(hints);
        }
    }

    private static class ProjectedPayloadHints
    implements MethodParameterRuntimeHintsRegistrar {
        private final MethodParameter methodParameter;

        ProjectedPayloadHints(MethodParameter methodParameter) {
            this.methodParameter = methodParameter;
        }

        @Override
        public void apply(RuntimeHints hints) {
            Class parameterType = this.methodParameter.nestedIfOptional().getNestedParameterType();
            hints.reflection().registerType(parameterType, new MemberCategory[0]);
            hints.proxies().registerJdkProxy(new Class[]{parameterType, TargetAware.class, SpringProxy.class, DecoratingProxy.class});
        }
    }

    private static class DataLoaderHints
    implements MethodParameterRuntimeHintsRegistrar {
        private final MethodParameter methodParameter;

        DataLoaderHints(MethodParameter methodParameter) {
            this.methodParameter = methodParameter;
        }

        @Override
        public void apply(RuntimeHints hints) {
            bindingRegistrar.registerReflectionHints(hints.reflection(), new Type[]{this.methodParameter.nested().getNestedGenericParameterType()});
        }
    }

    private static class ArgumentBindingHints
    implements MethodParameterRuntimeHintsRegistrar {
        private final MethodParameter methodParameter;

        ArgumentBindingHints(MethodParameter methodParameter) {
            this.methodParameter = methodParameter;
        }

        @Override
        public void apply(RuntimeHints runtimeHints) {
            Type parameterType = this.methodParameter.getGenericParameterType();
            if (ArgumentValue.class.isAssignableFrom(this.methodParameter.getParameterType())) {
                parameterType = this.methodParameter.nested().getNestedGenericParameterType();
            }
            bindingRegistrar.registerReflectionHints(runtimeHints.reflection(), new Type[]{parameterType});
        }
    }

    private static final class NoHintsRequired
    implements MethodParameterRuntimeHintsRegistrar {
        private NoHintsRequired() {
        }

        @Override
        public void apply(RuntimeHints runtimeHints) {
        }
    }

    @FunctionalInterface
    private static interface MethodParameterRuntimeHintsRegistrar {
        public static final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

        public void apply(RuntimeHints var1);

        public static MethodParameterRuntimeHintsRegistrar fromMethodParameter(HandlerMethodArgumentResolverComposite resolvers, MethodParameter parameter) {
            HandlerMethodArgumentResolver resolver = resolvers.getArgumentResolver(parameter);
            if (resolver instanceof ArgumentMethodArgumentResolver || resolver instanceof ArgumentsMethodArgumentResolver) {
                return new ArgumentBindingHints(parameter);
            }
            if (resolver instanceof DataLoaderMethodArgumentResolver) {
                return new DataLoaderHints(parameter);
            }
            if (springDataPresent && resolver instanceof ProjectedPayloadMethodArgumentResolver) {
                return new ProjectedPayloadHints(parameter);
            }
            return new NoHintsRequired();
        }
    }
}

