/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.graphql.support.DocumentSource;
import org.springframework.util.FileCopyUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ResourceDocumentSource
implements DocumentSource {
    public static final List<String> FILE_EXTENSIONS = Arrays.asList(".graphql", ".gql");
    private final List<Resource> locations;
    private final List<String> extensions;

    public ResourceDocumentSource() {
        this(Collections.singletonList(new ClassPathResource("graphql/")), FILE_EXTENSIONS);
    }

    public ResourceDocumentSource(List<Resource> locations, List<String> extensions) {
        this.locations = Collections.unmodifiableList(new ArrayList<Resource>(locations));
        this.extensions = Collections.unmodifiableList(new ArrayList<String>(extensions));
    }

    public List<Resource> getLocations() {
        return this.locations;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public Mono<String> getDocument(String name) {
        return Flux.fromIterable(this.locations).flatMapIterable(location -> this.getCandidateResources(name, (Resource)location)).filter(Resource::exists).next().map(this::resourceToString).switchIfEmpty(Mono.fromRunnable(() -> {
            throw new IllegalStateException("Failed to find document, name='" + name + "', under location(s)=" + this.locations.stream().map(Object::toString).toList());
        })).subscribeOn(Schedulers.boundedElastic());
    }

    private List<Resource> getCandidateResources(String name, Resource location) {
        return this.extensions.stream().map(ext -> {
            try {
                return location.createRelative(name + ext);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }).collect(Collectors.toList());
    }

    private String resourceToString(Resource resource) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)outputStream);
            return outputStream.toString(StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Found resource: " + resource.getDescription() + " but failed to read it", ex);
        }
    }
}

