/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQLContext;
import io.micrometer.context.ContextSnapshot;
import io.micrometer.context.ContextSnapshotFactory;
import org.springframework.lang.Nullable;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public abstract class ContextSnapshotFactoryHelper {
    private static final ContextSnapshotFactory sharedInstance = ContextSnapshotFactory.builder().build();
    private static final String CONTEXT_SNAPSHOT_FACTORY_KEY = ContextSnapshotFactoryHelper.class.getName() + ".KEY";

    public static ContextSnapshotFactory selectInstance(@Nullable ContextSnapshotFactory factory) {
        if (factory != null) {
            return factory;
        }
        return sharedInstance;
    }

    public static Context saveInstance(ContextSnapshotFactory factory, Context context) {
        return context.put((Object)CONTEXT_SNAPSHOT_FACTORY_KEY, (Object)factory);
    }

    public static void saveInstance(ContextSnapshotFactory factory, GraphQLContext context) {
        context.put((Object)CONTEXT_SNAPSHOT_FACTORY_KEY, (Object)factory);
    }

    public static ContextSnapshotFactory getInstance(ContextView contextView) {
        ContextSnapshotFactory factory = (ContextSnapshotFactory)contextView.getOrDefault((Object)CONTEXT_SNAPSHOT_FACTORY_KEY, null);
        return ContextSnapshotFactoryHelper.selectInstance(factory);
    }

    public static ContextSnapshotFactory getInstance(GraphQLContext context) {
        ContextSnapshotFactory factory = (ContextSnapshotFactory)context.get((Object)CONTEXT_SNAPSHOT_FACTORY_KEY);
        return ContextSnapshotFactoryHelper.selectInstance(factory);
    }

    public static ContextSnapshot captureFrom(ContextView contextView) {
        ContextSnapshotFactory factory = ContextSnapshotFactoryHelper.getInstance(contextView);
        return ContextSnapshotFactoryHelper.selectInstance(factory).captureFrom(new Object[]{contextView});
    }

    public static ContextSnapshot captureFrom(GraphQLContext context) {
        ContextSnapshotFactory factory = ContextSnapshotFactoryHelper.getInstance(context);
        return ContextSnapshotFactoryHelper.selectInstance(factory).captureFrom(new Object[]{context});
    }
}

