/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.GraphQLContext;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.dataloader.BatchLoaderEnvironment;
import org.springframework.core.CollectionFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.graphql.data.method.InvocableHandlerMethodSupport;
import org.springframework.graphql.data.method.annotation.ContextValue;
import org.springframework.graphql.data.method.annotation.support.AnnotatedControllerConfigurer;
import org.springframework.graphql.data.method.annotation.support.ContextValueMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.PrincipalMethodArgumentResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BatchLoaderHandlerMethod
extends InvocableHandlerMethodSupport {
    private static final boolean springSecurityPresent = ClassUtils.isPresent((String)"org.springframework.security.core.context.SecurityContext", (ClassLoader)AnnotatedControllerConfigurer.class.getClassLoader());
    private final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();

    @Deprecated(since="1.3.0", forRemoval=true)
    public BatchLoaderHandlerMethod(HandlerMethod handlerMethod, @Nullable Executor executor) {
        this(handlerMethod, executor, false);
    }

    public BatchLoaderHandlerMethod(HandlerMethod handlerMethod, @Nullable Executor executor, boolean invokeAsync) {
        super(handlerMethod, executor, invokeAsync);
    }

    @Nullable
    public <K, V> Mono<Map<K, V>> invokeForMap(Collection<K> keys, BatchLoaderEnvironment environment) {
        Object[] args = this.getMethodArgumentValues(keys, environment);
        if (this.doesNotHaveAsyncArgs(args)) {
            Object result = this.doInvoke((GraphQLContext)environment.getContext(), args);
            return BatchLoaderHandlerMethod.toMonoMap(result);
        }
        return this.toArgsMono(args).flatMap(argValues -> {
            Object result = this.doInvoke((GraphQLContext)environment.getContext(), argValues);
            return BatchLoaderHandlerMethod.toMonoMap(result);
        });
    }

    public <V> Flux<V> invokeForIterable(Collection<?> keys, BatchLoaderEnvironment environment) {
        Object[] args = this.getMethodArgumentValues(keys, environment);
        if (this.doesNotHaveAsyncArgs(args)) {
            Object result = this.doInvoke((GraphQLContext)environment.getContext(), args);
            return BatchLoaderHandlerMethod.toFlux(result);
        }
        return this.toArgsMono(args).flatMapMany(resolvedArgs -> {
            Object result = this.doInvoke((GraphQLContext)environment.getContext(), resolvedArgs);
            return BatchLoaderHandlerMethod.toFlux(result);
        });
    }

    private <K> Object[] getMethodArgumentValues(Collection<K> keys, BatchLoaderEnvironment environment) {
        Object[] args = new Object[this.getMethodParameters().length];
        for (int i = 0; i < this.getMethodParameters().length; ++i) {
            args[i] = this.resolveArgument(this.getMethodParameters()[i], keys, environment);
        }
        return args;
    }

    @Nullable
    private <K> Object resolveArgument(MethodParameter parameter, Collection<K> keys, BatchLoaderEnvironment environment) {
        parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
        Class parameterType = parameter.getParameterType();
        if (Collection.class.isAssignableFrom(parameterType)) {
            if (parameterType.isInstance(keys)) {
                return keys;
            }
            Class elementType = parameter.nested().getNestedParameterType();
            Collection collection = CollectionFactory.createCollection((Class)parameterType, (Class)elementType, (int)keys.size());
            collection.addAll(keys);
            return collection;
        }
        if (parameter.hasParameterAnnotation(ContextValue.class)) {
            return this.resolveContextValueArgument(parameter, environment);
        }
        if (parameterType.equals(GraphQLContext.class)) {
            return environment.getContext();
        }
        if (parameterType.isInstance(environment)) {
            return environment;
        }
        if ("kotlin.coroutines.Continuation".equals(parameterType.getName())) {
            return null;
        }
        if (springSecurityPresent && Principal.class.isAssignableFrom(parameter.getParameterType())) {
            return PrincipalMethodArgumentResolver.resolveAuthentication(parameter);
        }
        throw new IllegalStateException(BatchLoaderHandlerMethod.formatArgumentError(parameter, "Unexpected argument type."));
    }

    @Nullable
    private Object resolveContextValueArgument(MethodParameter parameter, BatchLoaderEnvironment environment) {
        ContextValue annotation = (ContextValue)parameter.getParameterAnnotation(ContextValue.class);
        Assert.state((annotation != null ? 1 : 0) != 0, (String)"Expected @ContextValue annotation");
        String name = ContextValueMethodArgumentResolver.getContextValueName(parameter, annotation.name(), annotation);
        return ContextValueMethodArgumentResolver.resolveContextValue(name, annotation.required(), parameter, (GraphQLContext)environment.getContext());
    }

    private boolean doesNotHaveAsyncArgs(Object[] args) {
        return Arrays.stream(args).noneMatch(arg -> arg instanceof Mono);
    }

    private static <K, V> Mono<Map<K, V>> toMonoMap(@Nullable Object result) {
        if (result instanceof Map) {
            return Mono.just((Object)((Map)result));
        }
        if (result instanceof Mono) {
            return (Mono)result;
        }
        if (result instanceof CompletableFuture) {
            return Mono.fromFuture((CompletableFuture)((CompletableFuture)result));
        }
        return Mono.error((Throwable)new IllegalStateException("Unexpected return value: " + result));
    }

    private static <V> Flux<V> toFlux(@Nullable Object result) {
        if (result instanceof Collection) {
            return Flux.fromIterable((Iterable)((Collection)result));
        }
        if (result instanceof Flux) {
            return (Flux)result;
        }
        if (result instanceof CompletableFuture) {
            return Mono.fromFuture((CompletableFuture)((CompletableFuture)result)).flatMapIterable(Function.identity());
        }
        return Flux.error((Throwable)new IllegalStateException("Unexpected return value: " + result));
    }
}

