/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webmvc;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.support.SerializableGraphQlRequest;
import org.springframework.http.HttpCookie;
import org.springframework.http.MediaType;
import org.springframework.util.AlternativeJdkIdGenerator;
import org.springframework.util.Assert;
import org.springframework.util.IdGenerator;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

public class GraphQlHttpHandler {
    private static final Log logger = LogFactory.getLog(GraphQlHttpHandler.class);
    private static final ParameterizedTypeReference<Map<String, Object>> MAP_PARAMETERIZED_TYPE_REF = new ParameterizedTypeReference<Map<String, Object>>(){};
    private static final MediaType APPLICATION_GRAPHQL_RESPONSE = new MediaType("application", "graphql-response+json");
    private static final List<MediaType> SUPPORTED_MEDIA_TYPES = Arrays.asList(APPLICATION_GRAPHQL_RESPONSE, MediaType.APPLICATION_JSON, MediaType.APPLICATION_GRAPHQL);
    private final IdGenerator idGenerator = new AlternativeJdkIdGenerator();
    private final WebGraphQlHandler graphQlHandler;

    public GraphQlHttpHandler(WebGraphQlHandler graphQlHandler) {
        Assert.notNull((Object)graphQlHandler, (String)"WebGraphQlHandler is required");
        this.graphQlHandler = graphQlHandler;
    }

    public ServerResponse handleRequest(ServerRequest serverRequest) throws ServletException {
        CompletableFuture future;
        WebGraphQlRequest graphQlRequest = new WebGraphQlRequest(serverRequest.uri(), serverRequest.headers().asHttpHeaders(), GraphQlHttpHandler.initCookies(serverRequest), (Map<String, Object>)serverRequest.attributes(), GraphQlHttpHandler.readBody(serverRequest), this.idGenerator.generateId().toString(), LocaleContextHolder.getLocale());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing: " + graphQlRequest));
        }
        if ((future = this.graphQlHandler.handleRequest(graphQlRequest).map(response -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Execution complete");
            }
            ServerResponse.BodyBuilder builder = ServerResponse.ok();
            builder.headers(headers -> headers.putAll((Map)response.getResponseHeaders()));
            builder.contentType(GraphQlHttpHandler.selectResponseMediaType(serverRequest));
            return builder.body(response.toMap());
        }).toFuture()).isDone()) {
            try {
                return (ServerResponse)future.get();
            }
            catch (ExecutionException ex) {
                throw new ServletException(ex.getCause());
            }
            catch (InterruptedException ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        return ServerResponse.async((Object)future);
    }

    private static MultiValueMap<String, HttpCookie> initCookies(ServerRequest serverRequest) {
        MultiValueMap source = serverRequest.cookies();
        LinkedMultiValueMap target = new LinkedMultiValueMap(source.size());
        source.values().forEach(arg_0 -> GraphQlHttpHandler.lambda$initCookies$3((MultiValueMap)target, arg_0));
        return target;
    }

    private static GraphQlRequest readBody(ServerRequest request) throws ServletException {
        try {
            return (GraphQlRequest)request.body(SerializableGraphQlRequest.class);
        }
        catch (IOException ex) {
            throw new ServerWebInputException("I/O error while reading request body", null, (Throwable)ex);
        }
        catch (HttpMediaTypeNotSupportedException ex) {
            return GraphQlHttpHandler.applyApplicationGraphQlFallback(request, ex);
        }
    }

    private static SerializableGraphQlRequest applyApplicationGraphQlFallback(ServerRequest request, HttpMediaTypeNotSupportedException ex) throws HttpMediaTypeNotSupportedException {
        String contentTypeHeader = request.headers().firstHeader("Content-Type");
        if (StringUtils.hasText((String)contentTypeHeader)) {
            MediaType contentType = MediaType.parseMediaType((String)contentTypeHeader);
            MediaType applicationGraphQl = MediaType.parseMediaType((String)"application/graphql");
            if (applicationGraphQl.includes(contentType)) {
                try {
                    request = ServerRequest.from((ServerRequest)request).headers(headers -> headers.setContentType(MediaType.APPLICATION_JSON)).body((byte[])request.body(byte[].class)).build();
                    return (SerializableGraphQlRequest)request.body(SerializableGraphQlRequest.class);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        throw ex;
    }

    private static MediaType selectResponseMediaType(ServerRequest serverRequest) {
        for (MediaType accepted : serverRequest.headers().accept()) {
            if (!SUPPORTED_MEDIA_TYPES.contains(accepted)) continue;
            return accepted;
        }
        return MediaType.APPLICATION_JSON;
    }

    private static /* synthetic */ void lambda$initCookies$3(MultiValueMap target, List cookieList) {
        cookieList.forEach(cookie -> {
            HttpCookie httpCookie = new HttpCookie(cookie.getName(), cookie.getValue());
            target.add((Object)cookie.getName(), (Object)httpCookie);
        });
    }
}

