/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webflux;

import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.graphql.execution.ErrorType;
import org.springframework.graphql.execution.SubscriptionPublisherException;
import org.springframework.graphql.server.support.GraphQlWebSocketMessage;
import org.springframework.http.MediaType;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;

final class CodecDelegate {
    private static final ResolvableType MESSAGE_TYPE = ResolvableType.forClass(GraphQlWebSocketMessage.class);
    private final Decoder<?> decoder;
    private final Encoder<?> encoder;

    CodecDelegate(CodecConfigurer codecConfigurer) {
        Assert.notNull((Object)codecConfigurer, (String)"CodecConfigurer is required");
        this.decoder = CodecDelegate.findJsonDecoder(codecConfigurer);
        this.encoder = CodecDelegate.findJsonEncoder(codecConfigurer);
    }

    private static Decoder<?> findJsonDecoder(CodecConfigurer configurer) {
        return configurer.getReaders().stream().filter(reader -> reader.canRead(MESSAGE_TYPE, MediaType.APPLICATION_JSON)).map(reader -> ((DecoderHttpMessageReader)reader).getDecoder()).findFirst().orElseThrow(() -> new IllegalArgumentException("No JSON Decoder"));
    }

    private static Encoder<?> findJsonEncoder(CodecConfigurer configurer) {
        return configurer.getWriters().stream().filter(writer -> writer.canWrite(MESSAGE_TYPE, MediaType.APPLICATION_JSON)).map(writer -> ((EncoderHttpMessageWriter)writer).getEncoder()).findFirst().orElseThrow(() -> new IllegalArgumentException("No JSON Encoder"));
    }

    <T> WebSocketMessage encode(WebSocketSession session, GraphQlWebSocketMessage message) {
        DataBuffer buffer = this.encoder.encodeValue((Object)message, session.bufferFactory(), MESSAGE_TYPE, MimeTypeUtils.APPLICATION_JSON, null);
        return new WebSocketMessage(WebSocketMessage.Type.TEXT, buffer);
    }

    GraphQlWebSocketMessage decode(WebSocketMessage webSocketMessage) {
        DataBuffer buffer = DataBufferUtils.retain((DataBuffer)webSocketMessage.getPayload());
        return (GraphQlWebSocketMessage)this.decoder.decode(buffer, MESSAGE_TYPE, null, null);
    }

    WebSocketMessage encodeConnectionAck(WebSocketSession session, Object ackPayload) {
        return this.encode(session, GraphQlWebSocketMessage.connectionAck(ackPayload));
    }

    WebSocketMessage encodeNext(WebSocketSession session, String id, Map<String, Object> responseMap) {
        return this.encode(session, GraphQlWebSocketMessage.next(id, responseMap));
    }

    WebSocketMessage encodeError(WebSocketSession session, String id, Throwable ex) {
        List<GraphQLError> errors = ex instanceof SubscriptionPublisherException ? ((SubscriptionPublisherException)((Object)ex)).getErrors() : Collections.singletonList(GraphqlErrorBuilder.newError().message("Subscription error", new Object[0]).errorType((ErrorClassification)ErrorType.INTERNAL_ERROR).build());
        return this.encode(session, GraphQlWebSocketMessage.error(id, errors));
    }

    WebSocketMessage encodeComplete(WebSocketSession session, String id) {
        return this.encode(session, GraphQlWebSocketMessage.complete(id));
    }
}

