/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQLError;
import graphql.schema.DataFetchingEnvironment;
import io.micrometer.context.ContextSnapshot;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

public abstract class DataFetcherExceptionResolverAdapter
implements DataFetcherExceptionResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean threadLocalContextAware;

    protected DataFetcherExceptionResolverAdapter() {
    }

    public void setThreadLocalContextAware(boolean threadLocalContextAware) {
        this.threadLocalContextAware = threadLocalContextAware;
    }

    public boolean isThreadLocalContextAware() {
        return this.threadLocalContextAware;
    }

    @Override
    public final Mono<List<GraphQLError>> resolveException(Throwable ex, DataFetchingEnvironment env) {
        return Mono.defer(() -> Mono.justOrEmpty(this.resolveInternal(ex, env)));
    }

    @Nullable
    private List<GraphQLError> resolveInternal(Throwable exception, DataFetchingEnvironment env) {
        try {
            return this.threadLocalContextAware ? (List)ContextSnapshot.captureFrom((Object)env.getGraphQlContext()).wrap(() -> this.resolveToMultipleErrors(exception, env)).call() : this.resolveToMultipleErrors(exception, env);
        }
        catch (Exception ex2) {
            this.logger.warn((Object)("Failure while resolving " + exception.getMessage()), (Throwable)ex2);
            return null;
        }
    }

    @Nullable
    protected List<GraphQLError> resolveToMultipleErrors(Throwable ex, DataFetchingEnvironment env) {
        GraphQLError error = this.resolveToSingleError(ex, env);
        return error != null ? Collections.singletonList(error) : null;
    }

    @Nullable
    protected GraphQLError resolveToSingleError(Throwable ex, DataFetchingEnvironment env) {
        return null;
    }

    @Deprecated(since="1.0.1", forRemoval=true)
    public static DataFetcherExceptionResolverAdapter from(final BiFunction<Throwable, DataFetchingEnvironment, GraphQLError> resolver) {
        return new DataFetcherExceptionResolverAdapter(){

            @Override
            protected GraphQLError resolveToSingleError(Throwable ex, DataFetchingEnvironment env) {
                return (GraphQLError)resolver.apply(ex, env);
            }
        };
    }
}

