/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.GraphQLError;
import graphql.schema.DataFetchingEnvironment;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ExceptionDepthComparator;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolverComposite;
import org.springframework.graphql.data.method.annotation.GraphQlExceptionHandler;
import org.springframework.graphql.data.method.annotation.support.DataFetcherHandlerMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.ControllerAdviceBean;
import reactor.core.publisher.Mono;

final class AnnotatedControllerExceptionResolver {
    private static final Log logger = LogFactory.getLog(AnnotatedControllerExceptionResolver.class);
    private final HandlerMethodArgumentResolverComposite argumentResolvers;
    private final Map<Class<?>, MethodResolver> controllerCache = new ConcurrentHashMap(64);
    private final Map<ControllerAdviceBean, MethodResolver> controllerAdviceCache = new ConcurrentHashMap<ControllerAdviceBean, MethodResolver>(64);

    AnnotatedControllerExceptionResolver(HandlerMethodArgumentResolverComposite resolvers) {
        Assert.notNull((Object)resolvers, (String)"'resolvers' are required");
        this.argumentResolvers = resolvers;
    }

    public void registerController(Class<?> controllerType) {
        this.controllerCache.computeIfAbsent(controllerType, type -> new MethodResolver(AnnotatedControllerExceptionResolver.findExceptionHandlers(controllerType)));
    }

    public void registerControllerAdvice(ApplicationContext context) {
        for (ControllerAdviceBean bean : ControllerAdviceBean.findAnnotatedBeans((ApplicationContext)context)) {
            Map<Class<? extends Throwable>, Method> methods;
            Class beanType = bean.getBeanType();
            if (beanType == null || (methods = AnnotatedControllerExceptionResolver.findExceptionHandlers(beanType)).isEmpty()) continue;
            this.controllerAdviceCache.put(bean, new MethodResolver(methods));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("@GraphQlException methods in ControllerAdvice beans: " + (Serializable)(this.controllerAdviceCache.size() == 0 ? "none" : Integer.valueOf(this.controllerAdviceCache.size()))));
        }
    }

    private static Map<Class<? extends Throwable>, Method> findExceptionHandlers(Class<?> handlerType) {
        Map handlerMap = MethodIntrospector.selectMethods(handlerType, method -> (GraphQlExceptionHandler)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, GraphQlExceptionHandler.class));
        HashMap<Class<? extends Throwable>, Method> mappings = new HashMap<Class<? extends Throwable>, Method>(handlerMap.size());
        handlerMap.forEach((method, annotation) -> {
            ArrayList exceptionTypes = new ArrayList();
            if (!ObjectUtils.isEmpty((Object[])annotation.value())) {
                exceptionTypes.addAll(Arrays.asList(annotation.value()));
            } else {
                for (Class<?> parameterType : method.getParameterTypes()) {
                    if (!Throwable.class.isAssignableFrom(parameterType)) continue;
                    exceptionTypes.add(parameterType);
                }
            }
            Assert.state((!exceptionTypes.isEmpty() ? 1 : 0) != 0, () -> "No exception types for " + method);
            for (Class clazz : exceptionTypes) {
                Method oldMethod = mappings.put(clazz, (Method)method);
                Assert.state((oldMethod == null || oldMethod.equals(method) ? 1 : 0) != 0, () -> "Ambiguous @GraphQlExceptionHandler for [" + type + "]: {" + oldMethod + ", " + method + "}");
            }
        });
        return mappings;
    }

    public Mono<List<GraphQLError>> resolveException(Throwable ex, DataFetchingEnvironment environment, @Nullable Object controller) {
        Object controllerOrAdvice = null;
        MethodHolder methodHolder = null;
        Class controllerType = null;
        if (controller != null) {
            controllerType = ClassUtils.getUserClass(controller.getClass());
            MethodResolver methodResolver = this.controllerCache.get(controllerType);
            if (methodResolver != null) {
                controllerOrAdvice = controller;
                methodHolder = methodResolver.resolveMethod(ex);
            } else if (logger.isWarnEnabled()) {
                logger.warn((Object)("No registration for controller type: " + controllerType.getName()));
            }
        }
        if (methodHolder == null) {
            for (Map.Entry<ControllerAdviceBean, MethodResolver> entry : this.controllerAdviceCache.entrySet()) {
                ControllerAdviceBean advice = entry.getKey();
                if (controller != null && !advice.isApplicableToBeanType(controllerType) || (methodHolder = entry.getValue().resolveMethod(ex)) == null) continue;
                controllerOrAdvice = advice.resolveBean();
                break;
            }
        }
        if (methodHolder == null) {
            return Mono.empty();
        }
        return this.invokeExceptionHandler(ex, environment, controllerOrAdvice, methodHolder);
    }

    private Mono<List<GraphQLError>> invokeExceptionHandler(Throwable exception, DataFetchingEnvironment env, Object controllerOrAdvice, MethodHolder methodHolder) {
        DataFetcherHandlerMethod exceptionHandler = new DataFetcherHandlerMethod(new HandlerMethod(controllerOrAdvice, methodHolder.getMethod()), this.argumentResolvers, null, null, false);
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Handling exception with " + exceptionHandler));
            }
            Throwable exToExpose = exception;
            while (exToExpose != null) {
                exceptions.add(exToExpose);
                Throwable cause = exToExpose.getCause();
                exToExpose = cause != exToExpose ? cause : null;
            }
            Object[] arguments = new Object[exceptions.size() + 1];
            exceptions.toArray(arguments);
            arguments[arguments.length - 1] = exceptionHandler;
            Object result = exceptionHandler.invoke(env, arguments);
            return methodHolder.adapt(result, exception);
        }
        catch (Throwable invocationEx) {
            if (!exceptions.contains(invocationEx) && logger.isWarnEnabled()) {
                logger.warn((Object)("Failure while handling exception with " + exceptionHandler), invocationEx);
            }
            return Mono.error((Throwable)exception);
        }
    }

    private static final class MethodResolver {
        private static final MethodHolder NO_MATCH = new MethodHolder(ReflectionUtils.findMethod(MethodResolver.class, (String)"noMatch"));
        private final Map<Class<? extends Throwable>, MethodHolder> exceptionMappings = new HashMap<Class<? extends Throwable>, MethodHolder>(16);
        private final Map<Class<? extends Throwable>, MethodHolder> resolvedExceptionCache = new ConcurrentReferenceHashMap(16);

        MethodResolver(Map<Class<? extends Throwable>, Method> methodMap) {
            methodMap.forEach((exceptionType, method) -> this.exceptionMappings.put((Class<? extends Throwable>)exceptionType, new MethodHolder((Method)method)));
        }

        @Nullable
        public MethodHolder resolveMethod(Throwable exception) {
            Throwable cause;
            MethodHolder method = this.resolveMethodByExceptionType(exception.getClass());
            if (method == null && (cause = exception.getCause()) != null) {
                method = this.resolveMethod(cause);
            }
            return method;
        }

        @Nullable
        private MethodHolder resolveMethodByExceptionType(Class<? extends Throwable> exceptionType) {
            MethodHolder method = this.resolvedExceptionCache.get(exceptionType);
            if (method == null) {
                method = this.getMappedMethod(exceptionType);
                this.resolvedExceptionCache.put(exceptionType, method);
            }
            return method != NO_MATCH ? method : null;
        }

        private MethodHolder getMappedMethod(Class<? extends Throwable> exceptionType) {
            ArrayList<Class<? extends Throwable>> matches = new ArrayList<Class<? extends Throwable>>();
            for (Class<? extends Throwable> mappedException : this.exceptionMappings.keySet()) {
                if (!mappedException.isAssignableFrom(exceptionType)) continue;
                matches.add(mappedException);
            }
            if (!matches.isEmpty()) {
                if (matches.size() > 1) {
                    matches.sort((Comparator<Class<? extends Throwable>>)new ExceptionDepthComparator(exceptionType));
                }
                return this.exceptionMappings.get(matches.get(0));
            }
            return NO_MATCH;
        }

        private void noMatch() {
        }
    }

    private static class MethodHolder {
        private final Method method;
        private final MethodParameter returnType;
        private final ReturnValueAdapter adapter;

        MethodHolder(Method method) {
            Assert.notNull((Object)method, (String)"Method is required");
            this.method = method;
            this.returnType = new MethodParameter(method, -1);
            this.adapter = ReturnValueAdapter.createFor(this.returnType);
        }

        public Method getMethod() {
            return this.method;
        }

        public Mono<List<GraphQLError>> adapt(@Nullable Object result, Throwable ex) {
            return this.adapter.adapt(result, this.returnType, ex);
        }
    }

    private static interface ReturnValueAdapter {
        public static final ReturnValueAdapter forVoid = (result, returnType, ex) -> Mono.just(Collections.emptyList());
        public static final ReturnValueAdapter forSingleError = (result, returnType, ex) -> result == null ? Mono.empty() : Mono.just(Collections.singletonList((GraphQLError)result));
        public static final ReturnValueAdapter forCollection = (result, returnType, ex) -> result == null ? Mono.empty() : Mono.just((Object)(result instanceof List ? (List)result : new ArrayList((Collection)result)));
        public static final ReturnValueAdapter forObject = (result, returnType, ex) -> {
            if (result == null) {
                return Mono.empty();
            }
            if (result instanceof GraphQLError) {
                return forSingleError.adapt(result, returnType, ex);
            }
            if (result instanceof Collection) {
                return forCollection.adapt(result, returnType, ex);
            }
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Unexpected return value of type " + result.getClass().getName() + " from method " + returnType));
            }
            return Mono.error((Throwable)ex);
        };
        public static final ReturnValueAdapter forMonoVoid = (result, returnType, ex) -> result == null ? Mono.empty() : Mono.just(Collections.emptyList());
        public static final ReturnValueAdapter forMono = (result, returnType, ex) -> result == null ? Mono.empty() : ((Mono)result).flatMap(o -> forObject.adapt(o, returnType, ex)).switchIfEmpty(Mono.error((Throwable)ex));

        public Mono<List<GraphQLError>> adapt(@Nullable Object var1, MethodParameter var2, Throwable var3);

        public static ReturnValueAdapter createFor(MethodParameter returnType) {
            Class parameterType = returnType.getParameterType();
            Method method = returnType.getMethod();
            if (method != null && KotlinDetector.isSuspendingFunction((Method)method)) {
                return ReturnValueAdapter.createForMono(returnType);
            }
            if (parameterType == Void.TYPE) {
                return forVoid;
            }
            if (parameterType.equals(GraphQLError.class)) {
                return forSingleError;
            }
            if (Collection.class.isAssignableFrom(parameterType)) {
                if (returnType.nested().getNestedParameterType().equals(GraphQLError.class)) {
                    return forCollection;
                }
            } else {
                if (Mono.class.isAssignableFrom(parameterType)) {
                    return ReturnValueAdapter.createForMono(returnType.nested());
                }
                if (parameterType.equals(Object.class)) {
                    return forObject;
                }
            }
            throw new IllegalStateException("Invalid return type for @GraphQlExceptionHandler method: " + returnType);
        }

        private static ReturnValueAdapter createForMono(MethodParameter returnType) {
            Class nestedType = returnType.getNestedParameterType();
            if (nestedType == Void.class) {
                return forMonoVoid;
            }
            if (Collection.class.isAssignableFrom(nestedType)) {
                returnType = returnType.nested();
                nestedType = returnType.getNestedParameterType();
            }
            if (nestedType.equals(GraphQLError.class) || nestedType.equals(Object.class)) {
                return forMono;
            }
            throw new IllegalStateException("Invalid return type for @GraphQlExceptionHandler method: " + returnType);
        }
    }
}

