/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.schema.DataFetchingEnvironment;
import org.springframework.graphql.execution.ErrorType;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.core.context.SecurityContext;

class SecurityExceptionResolverUtils {
    SecurityExceptionResolverUtils() {
    }

    static GraphQLError resolveUnauthorized(DataFetchingEnvironment environment) {
        return GraphqlErrorBuilder.newError((DataFetchingEnvironment)environment).errorType((ErrorClassification)ErrorType.UNAUTHORIZED).message("Unauthorized", new Object[0]).build();
    }

    static GraphQLError resolveAccessDenied(DataFetchingEnvironment env, AuthenticationTrustResolver resolver, SecurityContext securityContext) {
        return resolver.isAnonymous(securityContext.getAuthentication()) ? SecurityExceptionResolverUtils.resolveUnauthorized(env) : GraphqlErrorBuilder.newError((DataFetchingEnvironment)env).errorType((ErrorClassification)ErrorType.FORBIDDEN).message("Forbidden", new Object[0]).build();
    }
}

