/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.graphql.data.pagination.Subrange;
import org.springframework.lang.Nullable;

public final class ScrollSubrange
extends Subrange<ScrollPosition> {
    public ScrollSubrange(@Nullable ScrollPosition pos, @Nullable Integer count, boolean forward) {
        super(ScrollSubrange.initPosition(pos, count, forward), count, pos instanceof OffsetScrollPosition || forward);
    }

    @Nullable
    private static ScrollPosition initPosition(@Nullable ScrollPosition pos, @Nullable Integer count, boolean forward) {
        if (!forward) {
            if (pos instanceof OffsetScrollPosition) {
                OffsetScrollPosition offsetPosition = (OffsetScrollPosition)pos;
                if (count != null) {
                    return offsetPosition.advanceBy((long)(-count.intValue()));
                }
            }
            if (pos instanceof KeysetScrollPosition) {
                KeysetScrollPosition keysetPosition = (KeysetScrollPosition)pos;
                pos = keysetPosition.backward();
            }
        }
        return pos;
    }
}

