/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method;

import graphql.GraphQLContext;
import io.micrometer.context.ContextSnapshot;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.springframework.core.CoroutinesUtils;
import org.springframework.core.KotlinDetector;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public abstract class InvocableHandlerMethodSupport
extends HandlerMethod {
    private static final Object NO_VALUE = new Object();
    private final boolean hasCallableReturnValue = this.getReturnType().getParameterType().equals(Callable.class);
    @Nullable
    private final Executor executor;

    protected InvocableHandlerMethodSupport(HandlerMethod handlerMethod, @Nullable Executor executor) {
        super(handlerMethod.createWithResolvedBean());
        this.executor = executor;
        Assert.isTrue((!this.hasCallableReturnValue || this.executor != null ? 1 : 0) != 0, (String)("Controller method declared with Callable return value, but no Executor configured: " + handlerMethod.getBridgedMethod().toGenericString()));
    }

    @Nullable
    protected Object doInvoke(GraphQLContext graphQLContext, Object ... argValues) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Arguments: " + Arrays.toString(argValues)));
        }
        Method method = this.getBridgedMethod();
        try {
            if (KotlinDetector.isSuspendingFunction((Method)method)) {
                return CoroutinesUtils.invokeSuspendingFunction((Method)method, (Object)this.getBean(), (Object[])argValues);
            }
            Object result = method.invoke(this.getBean(), argValues);
            return this.handleReturnValue(graphQLContext, result);
        }
        catch (IllegalArgumentException ex) {
            this.assertTargetBean(method, this.getBean(), argValues);
            String text = ex.getMessage() != null ? ex.getMessage() : "Illegal argument";
            return Mono.error((Throwable)new IllegalStateException(this.formatInvokeError(text, argValues), ex));
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof Error || targetException instanceof Exception) {
                return Mono.error((Throwable)targetException);
            }
            return Mono.error((Throwable)new IllegalStateException(this.formatInvokeError("Invocation failure", argValues), targetException));
        }
        catch (Throwable ex) {
            return Mono.error((Throwable)ex);
        }
    }

    @Nullable
    private Object handleReturnValue(GraphQLContext graphQLContext, @Nullable Object result) {
        if (this.hasCallableReturnValue && result != null) {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return ContextSnapshot.captureFrom((Object)graphQLContext).wrap((Callable)result).call();
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failure in Callable returned from " + this.getBridgedMethod().toGenericString(), ex);
                }
            }, this.executor);
        }
        return result;
    }

    protected Mono<Object[]> toArgsMono(Object[] args) {
        ArrayList<Mono> monoList = new ArrayList<Mono>();
        for (Object arg : args) {
            Mono argMono = arg instanceof Mono ? (Mono)arg : Mono.justOrEmpty((Object)arg);
            monoList.add(argMono.defaultIfEmpty(NO_VALUE));
        }
        return Mono.zip(monoList, values -> {
            for (int i = 0; i < ((Object[])values).length; ++i) {
                if (values[i] != NO_VALUE) continue;
                values[i] = null;
            }
            return values;
        });
    }
}

