/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQL;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.SchemaTransformer;
import graphql.schema.SchemaTraverser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.graphql.execution.ContextDataFetcherDecorator;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.execution.SubscriptionExceptionResolver;

abstract class AbstractGraphQlSourceBuilder<B extends GraphQlSource.Builder<B>>
implements GraphQlSource.Builder<B> {
    private final List<DataFetcherExceptionResolver> exceptionResolvers = new ArrayList<DataFetcherExceptionResolver>();
    private final List<SubscriptionExceptionResolver> subscriptionExceptionResolvers = new ArrayList<SubscriptionExceptionResolver>();
    private final List<GraphQLTypeVisitor> typeVisitors = new ArrayList<GraphQLTypeVisitor>();
    private final List<GraphQLTypeVisitor> typeVisitorsToTransformSchema = new ArrayList<GraphQLTypeVisitor>();
    private final List<Instrumentation> instrumentations = new ArrayList<Instrumentation>();
    private Consumer<GraphQL.Builder> graphQlConfigurers = builder -> {};

    AbstractGraphQlSourceBuilder() {
    }

    @Override
    public B exceptionResolvers(List<DataFetcherExceptionResolver> resolvers) {
        this.exceptionResolvers.addAll(resolvers);
        return (B)this.self();
    }

    @Override
    public B subscriptionExceptionResolvers(List<SubscriptionExceptionResolver> resolvers) {
        this.subscriptionExceptionResolvers.addAll(resolvers);
        return (B)this.self();
    }

    @Override
    public B typeVisitors(List<GraphQLTypeVisitor> typeVisitors) {
        this.typeVisitors.addAll(typeVisitors);
        return (B)this.self();
    }

    @Override
    public B typeVisitorsToTransformSchema(List<GraphQLTypeVisitor> typeVisitorsToTransformSchema) {
        this.typeVisitorsToTransformSchema.addAll(typeVisitorsToTransformSchema);
        return (B)this.self();
    }

    @Override
    public B instrumentation(List<Instrumentation> instrumentations) {
        this.instrumentations.addAll(instrumentations);
        return (B)this.self();
    }

    @Override
    public B configureGraphQl(Consumer<GraphQL.Builder> configurer) {
        this.graphQlConfigurers = this.graphQlConfigurers.andThen(configurer);
        return (B)this.self();
    }

    private <T extends B> T self() {
        return (T)this;
    }

    @Override
    public GraphQlSource build() {
        GraphQLSchema schema = this.initGraphQlSchema();
        schema = this.applyTypeVisitorsToTransformSchema(schema);
        schema = this.applyTypeVisitors(schema);
        GraphQL.Builder builder = GraphQL.newGraphQL((GraphQLSchema)schema);
        builder.defaultDataFetcherExceptionHandler(DataFetcherExceptionResolver.createExceptionHandler(this.exceptionResolvers));
        if (!this.instrumentations.isEmpty()) {
            builder = builder.instrumentation((Instrumentation)new ChainedInstrumentation(this.instrumentations));
        }
        this.graphQlConfigurers.accept(builder);
        return new FixedGraphQlSource(builder.build(), schema);
    }

    protected abstract GraphQLSchema initGraphQlSchema();

    private GraphQLSchema applyTypeVisitorsToTransformSchema(GraphQLSchema schema) {
        SchemaTransformer transformer = new SchemaTransformer();
        for (GraphQLTypeVisitor visitor : this.typeVisitorsToTransformSchema) {
            schema = transformer.transform(schema, visitor);
        }
        return schema;
    }

    private GraphQLSchema applyTypeVisitors(GraphQLSchema schema) {
        GraphQLTypeVisitor visitor = ContextDataFetcherDecorator.createVisitor(schema, this.subscriptionExceptionResolvers);
        ArrayList<GraphQLTypeVisitor> visitors = new ArrayList<GraphQLTypeVisitor>(this.typeVisitors);
        visitors.add(visitor);
        GraphQLCodeRegistry.Builder codeRegistry = GraphQLCodeRegistry.newCodeRegistry((GraphQLCodeRegistry)schema.getCodeRegistry());
        Map<Class<GraphQLCodeRegistry.Builder>, GraphQLCodeRegistry.Builder> vars = Collections.singletonMap(GraphQLCodeRegistry.Builder.class, codeRegistry);
        SchemaTraverser traverser = new SchemaTraverser();
        traverser.depthFirstFullSchema(visitors, schema, vars);
        return schema.transformWithoutTypes(builder -> builder.codeRegistry(codeRegistry));
    }

    private record FixedGraphQlSource(GraphQL graphQl, GraphQLSchema schema) implements GraphQlSource
    {
    }
}

