/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.observation;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import org.springframework.graphql.observation.ExecutionRequestObservationContext;
import org.springframework.graphql.observation.ExecutionRequestObservationConvention;
import org.springframework.graphql.observation.GraphQlObservationDocumentation;

public class DefaultExecutionRequestObservationConvention
implements ExecutionRequestObservationConvention {
    private static final String DEFAULT_NAME = "graphql.request";
    private static final String BASE_CONTEXTUAL_NAME = "graphql ";
    private static final KeyValue OUTCOME_SUCCESS = KeyValue.of((KeyName)GraphQlObservationDocumentation.ExecutionRequestLowCardinalityKeyNames.OUTCOME, (String)"SUCCESS");
    private static final KeyValue OUTCOME_REQUEST_ERROR = KeyValue.of((KeyName)GraphQlObservationDocumentation.ExecutionRequestLowCardinalityKeyNames.OUTCOME, (String)"REQUEST_ERROR");
    private static final KeyValue OUTCOME_INTERNAL_ERROR = KeyValue.of((KeyName)GraphQlObservationDocumentation.ExecutionRequestLowCardinalityKeyNames.OUTCOME, (String)"INTERNAL_ERROR");
    private static final KeyValue OPERATION_QUERY = KeyValue.of((KeyName)GraphQlObservationDocumentation.ExecutionRequestLowCardinalityKeyNames.OPERATION, (String)"query");
    private final String name;

    public DefaultExecutionRequestObservationConvention() {
        this(DEFAULT_NAME);
    }

    public DefaultExecutionRequestObservationConvention(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getContextualName(ExecutionRequestObservationContext context) {
        String operationName = ((ExecutionInput)context.getCarrier()).getOperationName() != null ? ((ExecutionInput)context.getCarrier()).getOperationName() : "query";
        return BASE_CONTEXTUAL_NAME + operationName;
    }

    public KeyValues getLowCardinalityKeyValues(ExecutionRequestObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.outcome(context), this.operation(context)});
    }

    protected KeyValue outcome(ExecutionRequestObservationContext context) {
        if (context.getError() != null || context.getResponse() == null) {
            return OUTCOME_INTERNAL_ERROR;
        }
        if (((ExecutionResult)context.getResponse()).getErrors().size() > 0) {
            return OUTCOME_REQUEST_ERROR;
        }
        return OUTCOME_SUCCESS;
    }

    protected KeyValue operation(ExecutionRequestObservationContext context) {
        String operationName = ((ExecutionInput)context.getCarrier()).getOperationName();
        if (operationName != null) {
            return KeyValue.of((KeyName)GraphQlObservationDocumentation.ExecutionRequestLowCardinalityKeyNames.OPERATION, (String)operationName);
        }
        return OPERATION_QUERY;
    }

    public KeyValues getHighCardinalityKeyValues(ExecutionRequestObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.executionId(context)});
    }

    protected KeyValue executionId(ExecutionRequestObservationContext context) {
        return KeyValue.of((KeyName)GraphQlObservationDocumentation.ExecutionRequestHighCardinalityKeyNames.EXECUTION_ID, (String)((ExecutionInput)context.getCarrier()).getExecutionId().toString());
    }
}

