/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import graphql.language.FieldDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.idl.FieldWiringEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.WiringFactory;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class AutoRegistrationRuntimeWiringConfigurer
implements RuntimeWiringConfigurer {
    private static final Log logger = LogFactory.getLog(AutoRegistrationRuntimeWiringConfigurer.class);
    private final Map<String, Function<Boolean, DataFetcher<?>>> dataFetcherFactories;

    AutoRegistrationRuntimeWiringConfigurer(Map<String, Function<Boolean, DataFetcher<?>>> dataFetcherFactories) {
        this.dataFetcherFactories = dataFetcherFactories;
    }

    @Override
    public void configure(RuntimeWiring.Builder builder) {
    }

    @Override
    public void configure(RuntimeWiring.Builder builder, List<WiringFactory> container) {
        container.add(new AutoRegistrationWiringFactory(builder));
    }

    private class AutoRegistrationWiringFactory
    implements WiringFactory {
        private final RuntimeWiring.Builder builder;
        @Nullable
        private Predicate<String> existingQueryDataFetcherPredicate;

        AutoRegistrationWiringFactory(RuntimeWiring.Builder builder) {
            this.builder = builder;
        }

        public boolean providesDataFetcher(FieldWiringEnvironment environment) {
            boolean result;
            if (AutoRegistrationRuntimeWiringConfigurer.this.dataFetcherFactories.isEmpty()) {
                return false;
            }
            if (!environment.getParentType().getName().equals("Query")) {
                return false;
            }
            String outputTypeName = this.getOutputTypeName(environment);
            boolean bl = result = outputTypeName != null && AutoRegistrationRuntimeWiringConfigurer.this.dataFetcherFactories.containsKey(outputTypeName) && !this.hasDataFetcherFor(environment.getFieldDefinition());
            if (!result) {
                this.logTraceMessage(environment, outputTypeName, false);
            }
            return result;
        }

        @Nullable
        private String getOutputTypeName(FieldWiringEnvironment environment) {
            GraphQLOutputType outputType;
            Object object = outputType = environment.getFieldType() instanceof GraphQLList ? ((GraphQLList)environment.getFieldType()).getWrappedType() : environment.getFieldType();
            if (outputType instanceof GraphQLNonNull) {
                outputType = ((GraphQLNonNull)outputType).getWrappedType();
            }
            return outputType instanceof GraphQLNamedOutputType ? ((GraphQLNamedOutputType)outputType).getName() : null;
        }

        private boolean hasDataFetcherFor(FieldDefinition fieldDefinition) {
            if (this.existingQueryDataFetcherPredicate == null) {
                Map map = this.builder.build().getDataFetcherForType("Query");
                this.existingQueryDataFetcherPredicate = fieldName -> map.get(fieldName) != null;
            }
            return this.existingQueryDataFetcherPredicate.test(fieldDefinition.getName());
        }

        private void logTraceMessage(FieldWiringEnvironment environment, @Nullable String outputTypeName, boolean match) {
            if (logger.isTraceEnabled()) {
                String query = environment.getFieldDefinition().getName();
                logger.trace((Object)((match ? "Matched" : "Skipped") + " output typeName " + (String)(outputTypeName != null ? "'" + outputTypeName + "'" : "null") + " for query '" + query + "'"));
            }
        }

        public DataFetcher<?> getDataFetcher(FieldWiringEnvironment environment) {
            String outputTypeName = this.getOutputTypeName(environment);
            this.logTraceMessage(environment, outputTypeName, true);
            Function<Boolean, DataFetcher<?>> factory = AutoRegistrationRuntimeWiringConfigurer.this.dataFetcherFactories.get(outputTypeName);
            Assert.notNull(factory, (String)("Expected DataFetcher factory for typeName '" + outputTypeName + "'"));
            boolean single = !(environment.getFieldType() instanceof GraphQLList);
            return factory.apply(single);
        }
    }
}

