/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server;

import java.net.URI;
import java.util.Locale;
import java.util.Map;
import org.springframework.graphql.ExecutionGraphQlRequest;
import org.springframework.graphql.support.DefaultExecutionGraphQlRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class WebGraphQlRequest
extends DefaultExecutionGraphQlRequest
implements ExecutionGraphQlRequest {
    private final UriComponents uri;
    private final HttpHeaders headers;

    public WebGraphQlRequest(URI uri, HttpHeaders headers, Map<String, Object> body, String id, @Nullable Locale locale) {
        super(WebGraphQlRequest.getQuery(body), WebGraphQlRequest.getOperation(body), WebGraphQlRequest.getMap("variables", body), WebGraphQlRequest.getMap("extensions", body), id, locale);
        Assert.notNull((Object)uri, (String)"URI is required'");
        Assert.notNull((Object)headers, (String)"HttpHeaders is required'");
        this.uri = UriComponentsBuilder.fromUri((URI)uri).build(true);
        this.headers = headers;
    }

    private static String getQuery(Map<String, Object> body) {
        Object value = body.get("query");
        if (!(value instanceof String) || !StringUtils.hasText((String)((String)value))) {
            throw new ServerWebInputException("Invalid value for 'query'");
        }
        return (String)value;
    }

    @Nullable
    private static String getOperation(Map<String, Object> body) {
        Object value = body.get("operationName");
        if (value != null && !(value instanceof String)) {
            throw new ServerWebInputException("Invalid value for 'operationName'");
        }
        return (String)value;
    }

    @Nullable
    private static Map<String, Object> getMap(String key, Map<String, Object> body) {
        Object value = body.get(key);
        if (value != null && !(value instanceof Map)) {
            throw new ServerWebInputException("Invalid value for '" + key + "'");
        }
        return (Map)value;
    }

    public UriComponents getUri() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }
}

