/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import java.net.URI;
import java.util.function.Consumer;
import org.springframework.graphql.client.AbstractDelegatingGraphQlClient;
import org.springframework.graphql.client.AbstractGraphQlClientBuilder;
import org.springframework.graphql.client.CodecDelegate;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.graphql.client.HttpGraphQlClient;
import org.springframework.graphql.client.HttpGraphQlTransport;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;
import org.springframework.web.util.UriComponentsBuilder;

final class DefaultHttpGraphQlClientBuilder
extends AbstractGraphQlClientBuilder<DefaultHttpGraphQlClientBuilder>
implements HttpGraphQlClient.Builder<DefaultHttpGraphQlClientBuilder> {
    private final WebClient.Builder webClientBuilder;

    DefaultHttpGraphQlClientBuilder() {
        this(WebClient.builder());
    }

    DefaultHttpGraphQlClientBuilder(WebClient client) {
        this(client.mutate());
    }

    DefaultHttpGraphQlClientBuilder(WebClient.Builder clientBuilder) {
        this.webClientBuilder = clientBuilder;
    }

    @Override
    public DefaultHttpGraphQlClientBuilder url(String url) {
        this.webClientBuilder.baseUrl(url);
        return this;
    }

    @Override
    public DefaultHttpGraphQlClientBuilder url(URI url) {
        DefaultUriBuilderFactory factory = new DefaultUriBuilderFactory(UriComponentsBuilder.fromUri((URI)url));
        this.webClientBuilder.uriBuilderFactory((UriBuilderFactory)factory);
        return this;
    }

    @Override
    public DefaultHttpGraphQlClientBuilder header(String name, String ... values) {
        this.webClientBuilder.defaultHeader(name, values);
        return this;
    }

    @Override
    public DefaultHttpGraphQlClientBuilder headers(Consumer<HttpHeaders> headersConsumer) {
        this.webClientBuilder.defaultHeaders(headersConsumer);
        return this;
    }

    @Override
    public DefaultHttpGraphQlClientBuilder codecConfigurer(Consumer<CodecConfigurer> codecConfigurerConsumer) {
        this.webClientBuilder.codecs(codecConfigurerConsumer::accept);
        return this;
    }

    @Override
    public DefaultHttpGraphQlClientBuilder webClient(Consumer<WebClient.Builder> configurer) {
        configurer.accept(this.webClientBuilder);
        return this;
    }

    @Override
    public HttpGraphQlClient build() {
        this.webClientBuilder.codecs(configurer -> this.setJsonCodecs(CodecDelegate.findJsonEncoder((CodecConfigurer)configurer), CodecDelegate.findJsonDecoder((CodecConfigurer)configurer)));
        WebClient webClient = this.webClientBuilder.build();
        GraphQlClient graphQlClient = super.buildGraphQlClient(new HttpGraphQlTransport(webClient));
        return new DefaultHttpGraphQlClient(graphQlClient, webClient, this.getBuilderInitializer());
    }

    private static class DefaultHttpGraphQlClient
    extends AbstractDelegatingGraphQlClient
    implements HttpGraphQlClient {
        private final WebClient webClient;
        private final Consumer<AbstractGraphQlClientBuilder<?>> builderInitializer;

        DefaultHttpGraphQlClient(GraphQlClient delegate, WebClient webClient, Consumer<AbstractGraphQlClientBuilder<?>> builderInitializer) {
            super(delegate);
            Assert.notNull((Object)webClient, (String)"WebClient is required");
            Assert.notNull(builderInitializer, (String)"`builderInitializer` is required");
            this.webClient = webClient;
            this.builderInitializer = builderInitializer;
        }

        @Override
        public DefaultHttpGraphQlClientBuilder mutate() {
            DefaultHttpGraphQlClientBuilder builder = new DefaultHttpGraphQlClientBuilder(this.webClient);
            this.builderInitializer.accept(builder);
            return builder;
        }
    }
}

