/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data;

import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Consumer;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.DefaultBindingErrorProcessor;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class GraphQlArgumentBinder {
    private static final int DEFAULT_AUTO_GROW_COLLECTION_LIMIT = 1024;
    @Nullable
    private final SimpleTypeConverter typeConverter;
    private final BindingErrorProcessor bindingErrorProcessor = new DefaultBindingErrorProcessor();
    private final List<Consumer<DataBinder>> dataBinderInitializers = new ArrayList<Consumer<DataBinder>>();

    public GraphQlArgumentBinder() {
        this(null);
    }

    public GraphQlArgumentBinder(@Nullable ConversionService conversionService) {
        if (conversionService != null) {
            this.typeConverter = new SimpleTypeConverter();
            this.typeConverter.setConversionService(conversionService);
        } else {
            this.typeConverter = null;
        }
    }

    private SimpleTypeConverter getTypeConverter() {
        return this.typeConverter != null ? this.typeConverter : new SimpleTypeConverter();
    }

    @Nullable
    private ConversionService getConversionService() {
        return this.typeConverter != null ? this.typeConverter.getConversionService() : null;
    }

    public void addDataBinderInitializer(Consumer<DataBinder> dataBinderInitializer) {
        this.dataBinderInitializers.add(dataBinderInitializer);
    }

    @Nullable
    public Object bind(DataFetchingEnvironment environment, @Nullable String name, ResolvableType targetType) throws BindException {
        Object rawValue = name != null ? environment.getArgument(name) : environment.getArguments();
        DataBinder binder = new DataBinder(null, name != null ? "Arguments[" + name + "]" : "Arguments");
        this.initDataBinder(binder);
        BindingResult bindingResult = binder.getBindingResult();
        Stack<String> segments = new Stack<String>();
        if (name != null) {
            segments.push(name);
        }
        Object targetValue = this.bindRawValue(rawValue, targetType, targetType.resolve(Object.class), bindingResult, segments);
        if (bindingResult.hasErrors()) {
            throw new BindException(bindingResult);
        }
        return targetValue;
    }

    private void initDataBinder(DataBinder binder) {
        binder.setAutoGrowCollectionLimit(1024);
        this.dataBinderInitializers.forEach(initializer -> initializer.accept(binder));
    }

    @Nullable
    private Object bindRawValue(Object rawValue, ResolvableType targetType, Class<?> targetClass, BindingResult bindingResult, Stack<String> segments) {
        boolean isOptional;
        boolean bl = isOptional = targetClass == Optional.class;
        if (isOptional) {
            targetType = targetType.getNested(2);
            targetClass = targetType.resolve();
        }
        Object value = rawValue == null || targetClass == Object.class ? rawValue : (rawValue instanceof Collection ? this.bindCollection((Collection)((Object)rawValue), targetType, targetClass, bindingResult, segments) : (rawValue instanceof Map ? this.bindMap((Map)((Object)rawValue), targetType, targetClass, bindingResult, segments) : (targetClass.isAssignableFrom(rawValue.getClass()) ? rawValue : this.convertValue(rawValue, targetClass, bindingResult, segments))));
        return isOptional ? Optional.ofNullable(value) : value;
    }

    private Collection<?> bindCollection(Collection<Object> rawCollection, ResolvableType collectionType, Class<?> collectionClass, BindingResult bindingResult, Stack<String> segments) {
        ResolvableType elementType = collectionType.asCollection().getGeneric(new int[]{0});
        Class elementClass = collectionType.asCollection().getGeneric(new int[]{0}).resolve();
        if (elementClass == null) {
            bindingResult.rejectValue(GraphQlArgumentBinder.toArgumentPath(segments), "unknownTargetType", "Unknown target type");
            return Collections.emptyList();
        }
        Collection collection = CollectionFactory.createCollection(collectionClass, (Class)elementClass, (int)rawCollection.size());
        int index = 0;
        for (Object rawValue : rawCollection) {
            segments.push("[" + index++ + "]");
            collection.add(this.bindRawValue(rawValue, elementType, elementClass, bindingResult, segments));
            segments.pop();
        }
        return collection;
    }

    private static String toArgumentPath(Stack<String> path) {
        StringBuilder sb = new StringBuilder();
        path.forEach(sb::append);
        return sb.toString();
    }

    @Nullable
    private Object bindMap(Map<String, Object> rawMap, ResolvableType targetType, Class<?> targetClass, BindingResult bindingResult, Stack<String> segments) {
        if (Map.class.isAssignableFrom(targetClass)) {
            return this.bindMapToMap(rawMap, targetType, bindingResult, segments, targetClass);
        }
        Constructor constructor = BeanUtils.getResolvableConstructor(targetClass);
        if (constructor.getParameterCount() > 0) {
            return this.bindMapToObjectViaConstructor(rawMap, constructor, bindingResult, segments);
        }
        Object target = BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[0]);
        DataBinder dataBinder = new DataBinder(target);
        this.initDataBinder(dataBinder);
        dataBinder.getBindingResult().setNestedPath(GraphQlArgumentBinder.toArgumentPath(segments));
        dataBinder.setConversionService(this.getConversionService());
        dataBinder.bind((PropertyValues)GraphQlArgumentBinder.createPropertyValues(rawMap));
        if (dataBinder.getBindingResult().hasErrors()) {
            String nestedPath = dataBinder.getBindingResult().getNestedPath();
            for (FieldError error : dataBinder.getBindingResult().getFieldErrors()) {
                bindingResult.addError((ObjectError)new FieldError(bindingResult.getObjectName(), nestedPath + error.getField(), error.getRejectedValue(), error.isBindingFailure(), error.getCodes(), error.getArguments(), error.getDefaultMessage()));
            }
            return null;
        }
        return target;
    }

    private Map<?, Object> bindMapToMap(Map<String, Object> rawMap, ResolvableType targetType, BindingResult bindingResult, Stack<String> segments, Class<?> targetClass) {
        ResolvableType valueType = targetType.asMap().getGeneric(new int[]{1});
        Class valueClass = valueType.resolve();
        if (valueClass == null) {
            bindingResult.rejectValue(GraphQlArgumentBinder.toArgumentPath(segments), "unknownTargetType", "Unknown target type");
            return Collections.emptyMap();
        }
        Map map = CollectionFactory.createMap(targetClass, (int)rawMap.size());
        for (Map.Entry<String, Object> entry : rawMap.entrySet()) {
            String key = entry.getKey();
            segments.push("[" + key + "]");
            map.put(key, this.bindRawValue(entry.getValue(), valueType, valueClass, bindingResult, segments));
            segments.pop();
        }
        return map;
    }

    @Nullable
    private Object bindMapToObjectViaConstructor(Map<String, Object> rawMap, Constructor<?> constructor, BindingResult bindingResult, Stack<String> segments) {
        if (segments.size() > 0) {
            segments.push(".");
        }
        String[] paramNames = BeanUtils.getParameterNames(constructor);
        Class<?>[] paramTypes = constructor.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        for (int i = 0; i < paramNames.length; ++i) {
            String name = paramNames[i];
            segments.push(name);
            ResolvableType paramType = ResolvableType.forConstructorParameter(constructor, (int)i);
            args[i] = this.bindRawValue(rawMap.get(name), paramType, paramTypes[i], bindingResult, segments);
            segments.pop();
        }
        if (segments.size() > 1) {
            segments.pop();
        }
        try {
            return BeanUtils.instantiateClass(constructor, (Object[])args);
        }
        catch (BeanInstantiationException ex) {
            if (bindingResult.hasErrors()) {
                return null;
            }
            throw ex;
        }
    }

    private static MutablePropertyValues createPropertyValues(Map<String, Object> rawMap) {
        MutablePropertyValues mpvs = new MutablePropertyValues();
        Stack<String> segments = new Stack<String>();
        for (String key : rawMap.keySet()) {
            GraphQlArgumentBinder.addPropertyValue(mpvs, key, rawMap.get(key), segments);
        }
        return mpvs;
    }

    private static void addPropertyValue(MutablePropertyValues mpvs, String name, Object value, Stack<String> segments) {
        if (value instanceof List) {
            List items = (List)value;
            if (items.isEmpty()) {
                segments.push(name);
                mpvs.add(GraphQlArgumentBinder.toArgumentPath(segments), value);
                segments.pop();
            } else {
                for (int i = 0; i < items.size(); ++i) {
                    GraphQlArgumentBinder.addPropertyValue(mpvs, name + "[" + i + "]", items.get(i), segments);
                }
            }
        } else if (value instanceof Map) {
            segments.push(name + ".");
            Map map = (Map)value;
            for (String key : map.keySet()) {
                GraphQlArgumentBinder.addPropertyValue(mpvs, key, map.get(key), segments);
            }
            segments.pop();
        } else {
            segments.push(name);
            mpvs.add(GraphQlArgumentBinder.toArgumentPath(segments), value);
            segments.pop();
        }
    }

    @Nullable
    private <T> T convertValue(@Nullable Object rawValue, Class<T> type, BindingResult bindingResult, Stack<String> segments) {
        Object value = null;
        try {
            value = this.getTypeConverter().convertIfNecessary(rawValue, type, TypeDescriptor.valueOf(type));
        }
        catch (TypeMismatchException ex) {
            String name = GraphQlArgumentBinder.toArgumentPath(segments);
            ex.initPropertyName(name);
            bindingResult.recordFieldValue(name, type, rawValue);
            this.bindingErrorProcessor.processPropertyAccessException((PropertyAccessException)ex, bindingResult);
        }
        return (T)value;
    }
}

