/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.graphql.ResponseError;
import org.springframework.graphql.ResponseField;
import org.springframework.graphql.client.ClientResponseField;
import org.springframework.graphql.client.DefaultClientGraphQlResponse;
import org.springframework.graphql.client.FieldAccessException;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

final class DefaultClientResponseField
implements ClientResponseField {
    private final DefaultClientGraphQlResponse response;
    private final ResponseField field;

    DefaultClientResponseField(DefaultClientGraphQlResponse response, ResponseField field) {
        this.response = response;
        this.field = field;
    }

    @Override
    public boolean hasValue() {
        return this.field.getValue() != null;
    }

    @Override
    public String getPath() {
        return this.field.getPath();
    }

    @Override
    public List<Object> getParsedPath() {
        return this.field.getParsedPath();
    }

    @Override
    public <T> T getValue() {
        return this.field.getValue();
    }

    @Override
    public ResponseError getError() {
        return this.field.getError();
    }

    @Override
    public List<ResponseError> getErrors() {
        return this.field.getErrors();
    }

    @Override
    public <D> D toEntity(Class<D> entityType) {
        return (D)this.toEntity(ResolvableType.forType(entityType));
    }

    @Override
    public <D> D toEntity(ParameterizedTypeReference<D> entityType) {
        return (D)this.toEntity(ResolvableType.forType(entityType));
    }

    @Override
    public <D> List<D> toEntityList(Class<D> elementType) {
        return (List)this.toEntity(ResolvableType.forClassWithGenerics(List.class, (Class[])new Class[]{elementType}));
    }

    @Override
    public <D> List<D> toEntityList(ParameterizedTypeReference<D> elementType) {
        return (List)this.toEntity(ResolvableType.forClassWithGenerics(List.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType(elementType)}));
    }

    private <T> T toEntity(ResolvableType targetType) {
        if (this.getValue() == null) {
            throw new FieldAccessException(this.response.getRequest(), this.response, this);
        }
        DefaultDataBufferFactory bufferFactory = DefaultDataBufferFactory.sharedInstance;
        MimeType mimeType = MimeTypeUtils.APPLICATION_JSON;
        Map hints = Collections.emptyMap();
        DataBuffer buffer = this.response.getEncoder().encodeValue(this.getValue(), (DataBufferFactory)bufferFactory, ResolvableType.forInstance(this.getValue()), mimeType, hints);
        return (T)this.response.getDecoder().decode(buffer, targetType, mimeType, hints);
    }
}

