/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLTypeVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ResolvableType;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.repository.query.QueryByExampleExecutor;
import org.springframework.data.repository.query.ReactiveQueryByExampleExecutor;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.graphql.data.GraphQlArgumentBinder;
import org.springframework.graphql.data.query.AutoRegistrationRuntimeWiringConfigurer;
import org.springframework.graphql.data.query.AutoRegistrationTypeVisitor;
import org.springframework.graphql.data.query.PropertySelection;
import org.springframework.graphql.data.query.RepositoryUtils;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class QueryByExampleDataFetcher<T> {
    private static final Log logger = LogFactory.getLog(QueryByExampleDataFetcher.class);
    private final TypeInformation<T> domainType;
    private final GraphQlArgumentBinder argumentBinder;

    QueryByExampleDataFetcher(TypeInformation<T> domainType) {
        this.domainType = domainType;
        this.argumentBinder = new GraphQlArgumentBinder();
    }

    protected Example<T> buildExample(DataFetchingEnvironment env) throws BindException {
        ResolvableType targetType = ResolvableType.forClass((Class)this.domainType.getType());
        return Example.of((Object)this.argumentBinder.bind(env, null, targetType));
    }

    protected boolean requiresProjection(Class<?> resultType) {
        return !resultType.equals(this.domainType.getType());
    }

    protected Collection<String> buildPropertyPaths(DataFetchingFieldSelectionSet selection, Class<?> resultType) {
        if (this.domainType.getType().equals(resultType) || this.domainType.getType().isAssignableFrom(resultType) || this.domainType.isSubTypeOf(resultType)) {
            return PropertySelection.create(this.domainType, selection).toList();
        }
        return Collections.emptyList();
    }

    public static <T> Builder<T, T> builder(QueryByExampleExecutor<T> executor) {
        return new Builder(executor, RepositoryUtils.getDomainType(executor));
    }

    public static <T> ReactiveBuilder<T, T> builder(ReactiveQueryByExampleExecutor<T> executor) {
        return new ReactiveBuilder(executor, RepositoryUtils.getDomainType(executor));
    }

    public static RuntimeWiringConfigurer autoRegistrationConfigurer(List<QueryByExampleExecutor<?>> executors, List<ReactiveQueryByExampleExecutor<?>> reactiveExecutors) {
        String typeName;
        HashMap factories = new HashMap();
        for (QueryByExampleExecutor<?> queryByExampleExecutor : executors) {
            typeName = RepositoryUtils.getGraphQlTypeName(queryByExampleExecutor);
            if (typeName == null) continue;
            factories.put(typeName, single -> single != false ? QueryByExampleDataFetcher.builder(queryByExampleExecutor).single() : QueryByExampleDataFetcher.builder(queryByExampleExecutor).many());
        }
        for (ReactiveQueryByExampleExecutor reactiveQueryByExampleExecutor : reactiveExecutors) {
            typeName = RepositoryUtils.getGraphQlTypeName(reactiveQueryByExampleExecutor);
            if (typeName == null) continue;
            factories.put(typeName, single -> single != false ? QueryByExampleDataFetcher.builder(executor).single() : QueryByExampleDataFetcher.builder(executor).many());
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Auto-registration candidate typeNames " + factories.keySet()));
        }
        return new AutoRegistrationRuntimeWiringConfigurer(factories);
    }

    @Deprecated
    public static GraphQLTypeVisitor autoRegistrationTypeVisitor(List<QueryByExampleExecutor<?>> executors, List<ReactiveQueryByExampleExecutor<?>> reactiveExecutors) {
        String typeName;
        HashMap factories = new HashMap();
        for (QueryByExampleExecutor<?> queryByExampleExecutor : executors) {
            typeName = RepositoryUtils.getGraphQlTypeName(queryByExampleExecutor);
            if (typeName == null) continue;
            factories.put(typeName, single -> single != false ? QueryByExampleDataFetcher.builder(queryByExampleExecutor).single() : QueryByExampleDataFetcher.builder(queryByExampleExecutor).many());
        }
        for (ReactiveQueryByExampleExecutor reactiveQueryByExampleExecutor : reactiveExecutors) {
            typeName = RepositoryUtils.getGraphQlTypeName(reactiveQueryByExampleExecutor);
            if (typeName == null) continue;
            factories.put(typeName, single -> single != false ? QueryByExampleDataFetcher.builder(executor).single() : QueryByExampleDataFetcher.builder(executor).many());
        }
        return new AutoRegistrationTypeVisitor(factories);
    }

    private static class ReactiveManyEntityFetcher<T, R>
    extends QueryByExampleDataFetcher<T>
    implements DataFetcher<Flux<R>> {
        private final ReactiveQueryByExampleExecutor<T> executor;
        private final Class<R> resultType;
        private final Sort sort;

        ReactiveManyEntityFetcher(ReactiveQueryByExampleExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort) {
            super(domainType);
            this.executor = executor;
            this.resultType = resultType;
            this.sort = sort;
        }

        public Flux<R> get(DataFetchingEnvironment env) throws BindException {
            return (Flux)this.executor.findBy(this.buildExample(env), query -> {
                FluentQuery.ReactiveFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(this.resultType) ? queryToUse.as(this.resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), this.resultType));
                return queryToUse.all();
            });
        }
    }

    private static class ReactiveSingleEntityFetcher<T, R>
    extends QueryByExampleDataFetcher<T>
    implements DataFetcher<Mono<R>> {
        private final ReactiveQueryByExampleExecutor<T> executor;
        private final Class<R> resultType;
        private final Sort sort;

        ReactiveSingleEntityFetcher(ReactiveQueryByExampleExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort) {
            super(domainType);
            this.executor = executor;
            this.resultType = resultType;
            this.sort = sort;
        }

        public Mono<R> get(DataFetchingEnvironment env) throws BindException {
            return (Mono)this.executor.findBy(this.buildExample(env), query -> {
                FluentQuery.ReactiveFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(this.resultType) ? queryToUse.as(this.resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), this.resultType));
                return queryToUse.first();
            });
        }
    }

    private static class ManyEntityFetcher<T, R>
    extends QueryByExampleDataFetcher<T>
    implements DataFetcher<Iterable<R>> {
        private final QueryByExampleExecutor<T> executor;
        private final Class<R> resultType;
        private final Sort sort;

        ManyEntityFetcher(QueryByExampleExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort) {
            super(domainType);
            this.executor = executor;
            this.resultType = resultType;
            this.sort = sort;
        }

        public Iterable<R> get(DataFetchingEnvironment env) throws BindException {
            return (Iterable)this.executor.findBy(this.buildExample(env), query -> {
                FluentQuery.FetchableFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(this.resultType) ? queryToUse.as(this.resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), this.resultType));
                return queryToUse.all();
            });
        }
    }

    private static class SingleEntityFetcher<T, R>
    extends QueryByExampleDataFetcher<T>
    implements DataFetcher<R> {
        private final QueryByExampleExecutor<T> executor;
        private final Class<R> resultType;
        private final Sort sort;

        SingleEntityFetcher(QueryByExampleExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort) {
            super(domainType);
            this.executor = executor;
            this.resultType = resultType;
            this.sort = sort;
        }

        public R get(DataFetchingEnvironment env) throws BindException {
            return ((Optional)this.executor.findBy(this.buildExample(env), query -> {
                Class<R> resultType;
                FluentQuery.FetchableFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(resultType = this.resultType) ? queryToUse.as(resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), resultType));
                return queryToUse.first();
            })).orElse(null);
        }
    }

    public static class ReactiveBuilder<T, R> {
        private final ReactiveQueryByExampleExecutor<T> executor;
        private final TypeInformation<T> domainType;
        private final Class<R> resultType;
        private final Sort sort;

        ReactiveBuilder(ReactiveQueryByExampleExecutor<T> executor, Class<R> domainType) {
            this(executor, (TypeInformation<T>)ClassTypeInformation.from(domainType), domainType, Sort.unsorted());
        }

        ReactiveBuilder(ReactiveQueryByExampleExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort) {
            this.executor = executor;
            this.domainType = domainType;
            this.resultType = resultType;
            this.sort = sort;
        }

        public <P> ReactiveBuilder<T, P> projectAs(Class<P> projectionType) {
            Assert.notNull(projectionType, (String)"Projection type must not be null");
            return new ReactiveBuilder<T, P>(this.executor, this.domainType, projectionType, this.sort);
        }

        public ReactiveBuilder<T, R> sortBy(Sort sort) {
            Assert.notNull((Object)sort, (String)"Sort must not be null");
            return new ReactiveBuilder<T, R>(this.executor, this.domainType, this.resultType, sort);
        }

        public DataFetcher<Mono<R>> single() {
            return new ReactiveSingleEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.sort);
        }

        public DataFetcher<Flux<R>> many() {
            return new ReactiveManyEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.sort);
        }
    }

    public static class Builder<T, R> {
        private final QueryByExampleExecutor<T> executor;
        private final ClassTypeInformation<T> domainType;
        private final Class<R> resultType;
        private final Sort sort;

        Builder(QueryByExampleExecutor<T> executor, Class<R> domainType) {
            this(executor, ClassTypeInformation.from(domainType), domainType, Sort.unsorted());
        }

        Builder(QueryByExampleExecutor<T> executor, ClassTypeInformation<T> domainType, Class<R> resultType, Sort sort) {
            this.executor = executor;
            this.domainType = domainType;
            this.resultType = resultType;
            this.sort = sort;
        }

        public <P> Builder<T, P> projectAs(Class<P> projectionType) {
            Assert.notNull(projectionType, (String)"Projection type must not be null");
            return new Builder<T, P>(this.executor, this.domainType, projectionType, this.sort);
        }

        public Builder<T, R> sortBy(Sort sort) {
            Assert.notNull((Object)sort, (String)"Sort must not be null");
            return new Builder<T, R>(this.executor, this.domainType, this.resultType, sort);
        }

        public DataFetcher<R> single() {
            return new SingleEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.sort);
        }

        public DataFetcher<Iterable<R>> many() {
            return new ManyEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.sort);
        }
    }
}

