/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.SelectedField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.util.TypeInformation;

class PropertySelection {
    private final List<PropertyPath> propertyPaths;

    private PropertySelection(List<PropertyPath> propertyPaths) {
        this.propertyPaths = propertyPaths;
    }

    public static PropertySelection create(TypeInformation<?> typeInformation, DataFetchingFieldSelectionSet selectionSet) {
        return PropertySelection.create(typeInformation, new DataFetchingFieldSelection(selectionSet));
    }

    private static PropertySelection create(TypeInformation<?> typeInformation, FieldSelection selection) {
        List<PropertyPath> propertyPaths = PropertySelection.collectPropertyPaths(typeInformation, selection, path -> PropertyPath.from((String)path, (TypeInformation)typeInformation));
        return new PropertySelection(propertyPaths);
    }

    private static List<PropertyPath> collectPropertyPaths(TypeInformation<?> typeInformation, FieldSelection selection, Function<String, PropertyPath> propertyPathFactory) {
        ArrayList<PropertyPath> propertyPaths = new ArrayList<PropertyPath>();
        for (SelectedField selectedField : selection) {
            String propertyName = selectedField.getName();
            TypeInformation property = typeInformation.getProperty(propertyName);
            if (property == null) continue;
            PropertyPath propertyPath = propertyPathFactory.apply(propertyName);
            FieldSelection nestedSelection = selection.select(selectedField);
            List<PropertyPath> pathsToAdd = Collections.singletonList(propertyPath);
            if (!nestedSelection.isEmpty() && property.getActualType() != null) {
                List<PropertyPath> nestedPaths = PropertySelection.collectPropertyPaths(property.getRequiredActualType(), nestedSelection, arg_0 -> ((PropertyPath)propertyPath).nested(arg_0));
                if (!nestedPaths.isEmpty()) {
                    pathsToAdd = nestedPaths;
                }
            }
            propertyPaths.addAll(pathsToAdd);
        }
        return propertyPaths;
    }

    public List<String> toList() {
        return this.propertyPaths.stream().map(PropertyPath::toDotPath).collect(Collectors.toList());
    }

    static class DataFetchingFieldSelection
    implements FieldSelection {
        private final List<SelectedField> selectedFields;
        private final List<SelectedField> allFields;

        DataFetchingFieldSelection(DataFetchingFieldSelectionSet selectionSet) {
            this.selectedFields = selectionSet.getImmediateFields();
            this.allFields = selectionSet.getFields();
        }

        private DataFetchingFieldSelection(List<SelectedField> selectedFields, List<SelectedField> allFields) {
            this.selectedFields = selectedFields;
            this.allFields = allFields;
        }

        @Override
        public boolean isEmpty() {
            return this.selectedFields.isEmpty();
        }

        @Override
        public FieldSelection select(SelectedField field) {
            ArrayList<SelectedField> selectedFields = new ArrayList<SelectedField>();
            for (SelectedField selectedField : this.allFields) {
                if (!field.equals(selectedField.getParentField())) continue;
                selectedFields.add(selectedField);
            }
            return selectedFields.isEmpty() ? EmptyFieldSelection.INSTANCE : new DataFetchingFieldSelection(selectedFields, this.allFields);
        }

        @Override
        public Iterator<SelectedField> iterator() {
            return this.selectedFields.iterator();
        }
    }

    static interface FieldSelection
    extends Iterable<SelectedField> {
        public boolean isEmpty();

        public FieldSelection select(SelectedField var1);
    }

    static enum EmptyFieldSelection implements FieldSelection
    {
        INSTANCE;


        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public FieldSelection select(SelectedField field) {
            return INSTANCE;
        }

        @Override
        public Iterator<SelectedField> iterator() {
            return Collections.emptyIterator();
        }
    }
}

