/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.ClassPathResource;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.ResponseError;
import org.springframework.graphql.client.AbstractGraphQlClientBuilder;
import org.springframework.graphql.client.ClientGraphQlRequest;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.graphql.client.GraphQlTransport;
import org.springframework.graphql.support.DocumentSource;
import org.springframework.graphql.support.ResourceDocumentSource;
import org.springframework.graphql.test.tester.DefaultGraphQlTester;
import org.springframework.graphql.test.tester.GraphQlTester;
import org.springframework.graphql.test.tester.JacksonJsonProvider;
import org.springframework.graphql.test.tester.JacksonMappingProvider;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractGraphQlTesterBuilder<B extends AbstractGraphQlTesterBuilder<B>>
implements GraphQlTester.Builder<B> {
    private static final boolean jacksonPresent = ClassUtils.isPresent((String)"tools.jackson.databind.ObjectMapper", (ClassLoader)AbstractGraphQlClientBuilder.class.getClassLoader());
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)AbstractGraphQlClientBuilder.class.getClassLoader());
    private static final Duration DEFAULT_RESPONSE_DURATION = Duration.ofSeconds(5L);
    private @Nullable Predicate<ResponseError> errorFilter;
    private DocumentSource documentSource;
    private Configuration jsonPathConfig = Configuration.builder().build();
    private Duration responseTimeout = DEFAULT_RESPONSE_DURATION;

    public AbstractGraphQlTesterBuilder() {
        this.documentSource = AbstractGraphQlTesterBuilder.initDocumentSource();
    }

    private static DocumentSource initDocumentSource() {
        return new ResourceDocumentSource(Collections.singletonList(new ClassPathResource("graphql-test/")), ResourceDocumentSource.FILE_EXTENSIONS);
    }

    @Override
    public B errorFilter(Predicate<ResponseError> predicate) {
        this.errorFilter = this.errorFilter != null ? this.errorFilter.and(predicate) : predicate;
        return (B)this.self();
    }

    @Override
    public B documentSource(DocumentSource documentSource) {
        this.documentSource = documentSource;
        return (B)this.self();
    }

    @Override
    public B responseTimeout(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"'timeout' is required");
        this.responseTimeout = timeout;
        return (B)this.self();
    }

    private <T extends B> T self() {
        return (T)this;
    }

    protected void configureJsonPathConfig(Function<Configuration, Configuration> configurer) {
        this.jsonPathConfig = configurer.apply(this.jsonPathConfig);
    }

    protected GraphQlTester buildGraphQlTester(GraphQlTransport transport) {
        if (jacksonPresent) {
            this.configureJsonPathConfig(JacksonConfigurer::configure);
        } else if (jackson2Present) {
            this.configureJsonPathConfig(Jackson2Configurer::configure);
        }
        return new DefaultGraphQlTester(transport, this.errorFilter, this.jsonPathConfig, this.documentSource, this.responseTimeout);
    }

    protected Consumer<AbstractGraphQlTesterBuilder<?>> getBuilderInitializer() {
        return builder -> {
            if (this.errorFilter != null) {
                builder.errorFilter((Predicate)this.errorFilter);
            }
            builder.documentSource(this.documentSource);
            builder.configureJsonPathConfig(config -> this.jsonPathConfig);
            builder.responseTimeout(this.responseTimeout);
        };
    }

    protected static GraphQlTransport asTransport(final GraphQlClient client) {
        return new GraphQlTransport(){

            public Mono<GraphQlResponse> execute(GraphQlRequest request) {
                return client.document(request.getDocument()).operationName(request.getOperationName()).variables(request.getVariables()).extensions(request.getExtensions()).attributes(map -> 1.copyAttributes(map, request)).execute().cast(GraphQlResponse.class);
            }

            public Flux<GraphQlResponse> executeSubscription(GraphQlRequest request) {
                return client.document(request.getDocument()).operationName(request.getOperationName()).variables(request.getVariables()).extensions(request.getExtensions()).attributes(map -> 1.copyAttributes(map, request)).executeSubscription().cast(GraphQlResponse.class);
            }

            private static void copyAttributes(Map<String, Object> map, GraphQlRequest request) {
                if (request instanceof ClientGraphQlRequest) {
                    ClientGraphQlRequest clientGraphQlRequest = (ClientGraphQlRequest)request;
                    map.putAll(clientGraphQlRequest.getAttributes());
                }
            }
        };
    }

    private static final class Jackson2Configurer
    extends AbstractJacksonConfigurer {
        private Jackson2Configurer() {
        }

        static Configuration configure(Configuration config) {
            return Jackson2Configurer.configure(config, (JsonProvider)new com.jayway.jsonpath.spi.json.JacksonJsonProvider(), (MappingProvider)new com.jayway.jsonpath.spi.mapper.JacksonMappingProvider());
        }
    }

    private static final class JacksonConfigurer
    extends AbstractJacksonConfigurer {
        private JacksonConfigurer() {
        }

        static Configuration configure(Configuration config) {
            return JacksonConfigurer.configure(config, (JsonProvider)new JacksonJsonProvider(), new JacksonMappingProvider());
        }
    }

    private static abstract class AbstractJacksonConfigurer {
        private static final Class<?> defaultJsonProviderType;
        private static final Class<?> defaultMappingProviderType;

        private AbstractJacksonConfigurer() {
        }

        static Configuration configure(Configuration config, JsonProvider jsonProvider, MappingProvider mappingProvider) {
            if (AbstractJacksonConfigurer.isDefault(config.jsonProvider(), defaultJsonProviderType)) {
                config = config.jsonProvider(jsonProvider);
            }
            if (AbstractJacksonConfigurer.isDefault(config.mappingProvider(), defaultMappingProviderType)) {
                config = config.mappingProvider(mappingProvider);
            }
            return config;
        }

        static <T> boolean isDefault(@Nullable T provider, Class<? extends T> defaultProviderType) {
            return provider == null || defaultProviderType.isInstance(provider);
        }

        static {
            Configuration config = Configuration.defaultConfiguration();
            defaultJsonProviderType = config.jsonProvider().getClass();
            defaultMappingProviderType = config.mappingProvider().getClass();
        }
    }
}

